/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.beliefsystem.simple;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.simple.BeliefSystemLogicalCallback;
import org.drools.core.beliefsystem.simple.SimpleBeliefSet;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.beliefsystem.simple.SimpleMode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;

public class ReteSimpleBeliefSystem
implements BeliefSystem<SimpleMode> {
    private NamedEntryPoint ep;
    private TruthMaintenanceSystem tms;

    public ReteSimpleBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.ep = ep;
        this.tms = tms;
    }

    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    public void insert(LogicalDependency<SimpleMode> node, BeliefSet<SimpleMode> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean empty = beliefSet.isEmpty();
        beliefSet.add(node.getMode());
        if (empty) {
            InternalFactHandle handle = beliefSet.getFactHandle();
            this.ep.insert(handle, handle.getObject(), node.getJustifier().getRule(), node.getJustifier(), typeConf, null);
        }
    }

    public void read(LogicalDependency<SimpleMode> node, BeliefSet<SimpleMode> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        beliefSet.add(node.getMode());
    }

    public void delete(LogicalDependency<SimpleMode> node, BeliefSet<SimpleMode> beliefSet, PropagationContext context) {
        SimpleBeliefSet sBeliefSet = (SimpleBeliefSet)beliefSet;
        beliefSet.remove(node.getMode());
        InternalFactHandle bfh = beliefSet.getFactHandle();
        if (beliefSet.isEmpty() && (context.getType() != 1 && context.getType() != 2 || context.getFactHandle() != bfh)) {
            if (sBeliefSet.getWorkingMemoryAction() == null) {
                BeliefSystemLogicalCallback action = new BeliefSystemLogicalCallback(bfh, context, node.getJustifier(), false, true);
                this.ep.enQueueWorkingMemoryAction((WorkingMemoryAction)action);
                sBeliefSet.setWorkingMemoryAction((WorkingMemoryAction)action);
            } else {
                BeliefSystemLogicalCallback callback = (BeliefSystemLogicalCallback)sBeliefSet.getWorkingMemoryAction();
                callback.setUpdate(false);
                callback.setFullyRetract(true);
            }
        } else if (!beliefSet.isEmpty() && beliefSet.getFactHandle().getObject() == node.getObject()) {
            ((NamedEntryPoint)bfh.getEntryPoint()).getObjectStore().updateHandle(bfh, ((LogicalDependency)((SimpleMode)beliefSet.getFirst()).getObject()).getObject());
            if (sBeliefSet.getWorkingMemoryAction() == null) {
                BeliefSystemLogicalCallback action = new BeliefSystemLogicalCallback(bfh, context, node.getJustifier(), true, false);
                this.ep.enQueueWorkingMemoryAction((WorkingMemoryAction)action);
                sBeliefSet.setWorkingMemoryAction((WorkingMemoryAction)action);
            }
        }
    }

    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new SimpleBeliefSet((BeliefSystem)this, fh);
    }

    public LogicalDependency newLogicalDependency(Activation<SimpleMode> activation, BeliefSet<SimpleMode> beliefSet, Object object, Object value) {
        return new SimpleLogicalDependency(activation, beliefSet, object, null);
    }
}

