/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.DMNScenarioRunner;
import org.drools.scenariosimulation.backend.runner.IndexedScenarioException;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunner;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.ScenarioRunnerProvider;
import org.drools.scenariosimulation.backend.runner.SimulationRunMetadataBuilder;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerDTO;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.kie.api.runtime.KieContainer;

public abstract class AbstractScenarioRunner
extends Runner {
    protected final ClassLoader classLoader;
    protected final ExpressionEvaluatorFactory expressionEvaluatorFactory;
    protected final Description desc;
    protected final KieContainer kieContainer;
    protected final ScenarioRunnerDTO scenarioRunnerDTO;
    protected SimulationRunMetadataBuilder simulationRunMetadataBuilder;

    public AbstractScenarioRunner(KieContainer kieContainer, ScenarioRunnerDTO scenarioRunnerDTO, ExpressionEvaluatorFactory expressionEvaluatorFactory) {
        this.kieContainer = kieContainer;
        this.scenarioRunnerDTO = scenarioRunnerDTO;
        this.desc = AbstractScenarioRunner.getDescriptionForSimulation(this.getFileName(), scenarioRunnerDTO.getScenarioWithIndices());
        this.classLoader = kieContainer.getClassLoader();
        this.expressionEvaluatorFactory = expressionEvaluatorFactory;
    }

    public static Description getDescriptionForSimulation(Optional<String> className, List<ScenarioWithIndex> scenarios) {
        Description suiteDescription = Description.createSuiteDescription((String)"Test Scenarios (Preview) tests", (Annotation[])new Annotation[0]);
        scenarios.forEach(scenarioWithIndex -> suiteDescription.addChild(AbstractScenarioRunner.getDescriptionForScenario(className, scenarioWithIndex.getIndex(), (Scenario)scenarioWithIndex.getScesimData())));
        return suiteDescription;
    }

    public static Description getDescriptionForScenario(Optional<String> className, int index, Scenario scenario) {
        return Description.createTestDescription((String)className.orElse(AbstractScenarioRunner.class.getCanonicalName()), (String)String.format("#%d: %s", index, scenario.getDescription()), (Annotation[])new Annotation[0]);
    }

    public static ScenarioRunnerProvider getSpecificRunnerProvider(ScenarioSimulationModel.Type type) {
        if (ScenarioSimulationModel.Type.RULE.equals((Object)type)) {
            return RuleScenarioRunner::new;
        }
        if (ScenarioSimulationModel.Type.DMN.equals((Object)type)) {
            return DMNScenarioRunner::new;
        }
        throw new IllegalArgumentException("Impossible to run simulation of type " + type);
    }

    public void run(RunNotifier notifier) {
        this.simulationRunMetadataBuilder = SimulationRunMetadataBuilder.create();
        notifier.fireTestStarted(this.getDescription());
        for (ScenarioWithIndex scenarioWithIndex : this.scenarioRunnerDTO.getScenarioWithIndices()) {
            this.singleRunScenario(scenarioWithIndex, notifier, this.scenarioRunnerDTO.getSettings(), this.scenarioRunnerDTO.getBackground()).ifPresent(this.simulationRunMetadataBuilder::addScenarioResultMetadata);
        }
        notifier.fireTestStarted(this.getDescription());
    }

    public Description getDescription() {
        return this.desc;
    }

    protected Optional<ScenarioResultMetadata> singleRunScenario(ScenarioWithIndex scenarioWithIndex, RunNotifier runNotifier, Settings settings, Background background) {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        int index = scenarioWithIndex.getIndex();
        Description descriptionForScenario = AbstractScenarioRunner.getDescriptionForScenario(this.getFileName(), index, (Scenario)scenarioWithIndex.getScesimData());
        runNotifier.fireTestStarted(descriptionForScenario);
        try {
            this.internalRunScenario(scenarioWithIndex, scenarioRunnerData, settings, background);
        }
        catch (ScenarioException e) {
            IndexedScenarioException indexedScenarioException = new IndexedScenarioException(index, (Throwable)e);
            indexedScenarioException.setFileName(this.scenarioRunnerDTO.getFileName());
            runNotifier.fireTestFailure(new Failure(descriptionForScenario, (Throwable)indexedScenarioException));
        }
        catch (Throwable e) {
            IndexedScenarioException indexedScenarioException = new IndexedScenarioException(index, "Unexpected test error in scenario '" + ((Scenario)scenarioWithIndex.getScesimData()).getDescription() + "'", e);
            indexedScenarioException.setFileName(this.scenarioRunnerDTO.getFileName());
            runNotifier.fireTestFailure(new Failure(descriptionForScenario, (Throwable)indexedScenarioException));
        }
        runNotifier.fireTestFinished(descriptionForScenario);
        return scenarioRunnerData.getMetadata();
    }

    protected void internalRunScenario(ScenarioWithIndex scenarioWithIndex, ScenarioRunnerData scenarioRunnerData, Settings settings, Background background) {
        this.newRunnerHelper().run(this.getKieContainer(), this.scenarioRunnerDTO.getSimulationModelDescriptor(), scenarioWithIndex, this.expressionEvaluatorFactory, this.getClassLoader(), scenarioRunnerData, settings, background);
    }

    public Optional<String> getFileName() {
        return Optional.ofNullable(this.scenarioRunnerDTO.getFileName());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public Optional<SimulationRunMetadata> getLastRunResultMetadata() {
        return this.simulationRunMetadataBuilder != null ? Optional.of(this.simulationRunMetadataBuilder.build()) : Optional.empty();
    }

    protected abstract AbstractRunnerHelper newRunnerHelper();
}

