/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.serialization.protobuf.ProtobufInputMarshaller;
import org.drools.serialization.protobuf.ProtobufMarshallerReaderContext;
import org.drools.serialization.protobuf.ProtobufMarshallerWriteContext;
import org.drools.serialization.protobuf.ProtobufOutputMarshaller;
import org.drools.serialization.protobuf.ReadSessionResult;
import org.drools.serialization.protobuf.TimersInputMarshaller;
import org.drools.serialization.protobuf.marshalling.InternalMarshaller;
import org.drools.serialization.protobuf.marshalling.KieSessionInitializer;
import org.drools.serialization.protobuf.marshalling.RuleBaseNodes;
import org.drools.serialization.protobuf.timers.BehaviorJobContextTimerInputMarshaller;
import org.drools.serialization.protobuf.timers.ExpireJobContextTimerInputMarshaller;
import org.drools.serialization.protobuf.timers.TimerNodeTimerInputMarshaller;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.marshalling.MarshallingConfiguration;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ProtobufMarshaller
implements InternalMarshaller {
    protected KieSessionInitializer initializer;
    public static final Map<Integer, TimersInputMarshaller> TIMER_READERS = new HashMap<Integer, TimersInputMarshaller>();
    protected KieBase kbase;
    protected RuleBaseConfiguration ruleBaseConfig;
    protected MarshallingConfiguration marshallingConfig;
    protected ObjectMarshallingStrategyStore strategyStore;

    @Override
    public KieSessionInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public void setInitializer(KieSessionInitializer initializer) {
        this.initializer = initializer;
    }

    public ProtobufMarshaller(KieBase kbase, MarshallingConfiguration marshallingConfig) {
        this.kbase = kbase;
        this.ruleBaseConfig = ((InternalKnowledgeBase)kbase).getRuleBaseConfiguration();
        this.marshallingConfig = marshallingConfig;
        this.strategyStore = this.marshallingConfig.getObjectMarshallingStrategyStore();
    }

    public StatefulKnowledgeSession unmarshall(InputStream stream) throws IOException, ClassNotFoundException {
        return this.unmarshall(stream, null, null);
    }

    public StatefulKnowledgeSession unmarshall(InputStream stream, KieSessionConfiguration config, Environment environment) throws IOException, ClassNotFoundException {
        return this.unmarshallWithMessage(stream, config, environment).getSession();
    }

    public void unmarshall(InputStream stream, KieSession ksession) throws IOException, ClassNotFoundException {
        ProtobufMarshallerReaderContext context = this.getMarshallerReaderContext(stream, ksession.getEnvironment());
        ProtobufInputMarshaller.readSession((StatefulKnowledgeSessionImpl)ksession, context);
        context.close();
    }

    public void marshall(OutputStream stream, KieSession ksession) throws IOException {
        this.marshall(stream, ksession, ksession.getSessionClock().getCurrentTime());
    }

    public void marshall(OutputStream stream, KieSession ksession, long clockTime) throws IOException {
        ((InternalWorkingMemory)ksession).flushPropagations();
        ProtobufMarshallerWriteContext context = new ProtobufMarshallerWriteContext(stream, (InternalKnowledgeBase)this.kbase, (InternalWorkingMemory)ksession, RuleBaseNodes.getNodeMap((RuleBase)((InternalKnowledgeBase)this.kbase)), this.strategyStore, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), ksession.getEnvironment());
        context.setClockTime(clockTime);
        ProtobufOutputMarshaller.writeSession(context);
        context.close();
    }

    public MarshallingConfiguration getMarshallingConfiguration() {
        return this.marshallingConfig;
    }

    public ReadSessionResult unmarshallWithMessage(InputStream stream, KieSessionConfiguration config, Environment environment) throws IOException, ClassNotFoundException {
        if (config == null) {
            config = RuleBaseFactory.newKnowledgeSessionConfiguration();
        }
        if (environment == null) {
            environment = KieServices.get().newEnvironment();
        }
        ProtobufMarshallerReaderContext context = this.getMarshallerReaderContext(stream, environment);
        int id = ((InternalKnowledgeBase)this.kbase).nextWorkingMemoryCounter();
        ReadSessionResult readSessionResult = ProtobufInputMarshaller.readSession(context, id, environment, (SessionConfiguration)config.as(SessionConfiguration.KEY), this.initializer);
        context.close();
        if (((SessionConfiguration)config.as(SessionConfiguration.KEY)).isKeepReference()) {
            ((InternalKnowledgeBase)this.kbase).addStatefulSession((InternalWorkingMemory)readSessionResult.getSession());
        }
        return readSessionResult;
    }

    private ProtobufMarshallerReaderContext getMarshallerReaderContext(InputStream inputStream, Environment environment) throws IOException {
        return new ProtobufMarshallerReaderContext(inputStream, (InternalKnowledgeBase)this.kbase, RuleBaseNodes.getNodeMap((RuleBase)((InternalKnowledgeBase)this.kbase)), this.strategyStore, TIMER_READERS, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), environment);
    }

    static {
        TIMER_READERS.put(3, new BehaviorJobContextTimerInputMarshaller());
        TIMER_READERS.put(1, new ExpireJobContextTimerInputMarshaller());
        TIMER_READERS.put(5, new TimerNodeTimerInputMarshaller());
    }
}

