/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NamedBean;

public class KnowledgeLoggerBeanFactory
implements FactoryBean,
InitializingBean,
BeanNameAware,
NamedBean {
    private String name;
    private String beanName;
    private StatefulKnowledgeSession ksession;
    KnowledgeRuntimeLogger logger;
    String file;
    KNOWLEDGE_LOGGER_TYPE loggerType;

    public KNOWLEDGE_LOGGER_TYPE getLoggerType() {
        return this.loggerType;
    }

    public void setLoggerType(KNOWLEDGE_LOGGER_TYPE loggerType) {
        this.loggerType = loggerType;
    }

    public void setLoggerType(String loggerType) {
        this.loggerType = KNOWLEDGE_LOGGER_TYPE.valueOf(loggerType);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public StatefulKnowledgeSession getKsession() {
        return this.ksession;
    }

    public void setKsession(StatefulKnowledgeSession ksession) {
        this.ksession = ksession;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ksession == null) {
            throw new IllegalArgumentException("ksession property is mandatory");
        }
        if (this.name == null) {
            this.name = this.beanName;
        }
        this.internalAfterPropertiesSet();
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public Object getObject() throws Exception {
        return this.logger;
    }

    public Class getObjectType() {
        return KnowledgeRuntimeLogger.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void internalAfterPropertiesSet() throws Exception {
        switch (this.loggerType) {
            case LOGGER_TYPE_FILE: {
                this.logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)this.getKsession(), (String)this.getFile());
                break;
            }
            case LOGGER_TYPE_THREADED_FILE: {
                this.logger = KnowledgeRuntimeLoggerFactory.newThreadedFileLogger((KnowledgeRuntimeEventManager)this.getKsession(), (String)this.getFile(), (int)30);
                break;
            }
            case LOGGER_TYPES_CONSOLE: {
                this.logger = KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)this.getKsession());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KNOWLEDGE_LOGGER_TYPE {
        LOGGER_TYPE_FILE,
        LOGGER_TYPES_CONSOLE,
        LOGGER_TYPE_THREADED_FILE;

    }
}

