/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.drools.container.spring.beans.AbstractKnowledgeSessionBeanFactory;
import org.drools.core.SessionConfiguration;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.springframework.transaction.PlatformTransactionManager;

public class StatefulKnowledgeSessionBeanFactory
extends AbstractKnowledgeSessionBeanFactory {
    private KieSession ksession;
    private JpaConfiguration jpaConfiguration;

    public Class<KieSession> getObjectType() {
        return KieSession.class;
    }

    public JpaConfiguration getJpaConfiguration() {
        return this.jpaConfiguration;
    }

    public void setJpaConfiguration(JpaConfiguration jpaConfiguration) {
        this.jpaConfiguration = jpaConfiguration;
    }

    @Override
    protected CommandExecutor getCommandExecutor() {
        return this.ksession;
    }

    @Override
    protected void internalAfterPropertiesSet() {
        if (this.getConf() != null && this.getWorkItems() != null && !this.getWorkItems().isEmpty()) {
            Map map = ((SessionConfiguration)this.getConf()).getWorkItemHandlers();
            map.putAll(this.getWorkItems());
        }
        if (this.jpaConfiguration != null) {
            Environment env = EnvironmentFactory.newEnvironment();
            env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)this.jpaConfiguration.getEntityManagerFactory());
            env.set("org.kie.transaction.TransactionManager", (Object)this.jpaConfiguration.getPlatformTransactionManager());
            env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
            this.ksession = this.jpaConfiguration.getId() >= 0 ? JPAKnowledgeService.loadStatefulKnowledgeSession((int)this.jpaConfiguration.getId(), (KieBase)this.getKbase(), (KieSessionConfiguration)this.getConf(), (Environment)env) : JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)this.getKbase(), (KieSessionConfiguration)this.getConf(), (Environment)env);
        } else {
            this.ksession = this.getKbase().newKieSession(this.getConf(), null);
        }
        if (this.getBatch() != null && !this.getBatch().isEmpty()) {
            for (Command command : this.getBatch()) {
                this.ksession.execute(command);
            }
        }
        if (this.getNode() != null) {
            this.getNode().set(this.getName(), this.ksession);
        }
        for (AgendaEventListener agendaEventListener : this.getAgendaEventListeners()) {
            this.ksession.addEventListener(agendaEventListener);
        }
        for (ProcessEventListener processEventListener : this.getProcessEventListeners()) {
            this.ksession.addEventListener(processEventListener);
        }
        for (WorkingMemoryEventListener workingMemoryEventListener : this.getWorkingMemoryEventListeners()) {
            this.ksession.addEventListener(workingMemoryEventListener);
        }
        this.attachLoggers((KieRuntimeEventManager)this.ksession);
    }

    public static class JpaConfiguration {
        private EntityManagerFactory emf;
        private PlatformTransactionManager tm;
        private int id = -1;

        public EntityManagerFactory getEntityManagerFactory() {
            return this.emf;
        }

        public void setEntityManagerFactory(EntityManagerFactory emf) {
            this.emf = emf;
        }

        public PlatformTransactionManager getPlatformTransactionManager() {
            return this.tm;
        }

        public void setPlatformTransactionManager(PlatformTransactionManager tm) {
            this.tm = tm;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

