/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.jdbc;

import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.drools.template.parser.DataListener;
import org.drools.template.parser.DefaultTemplateContainer;
import org.drools.template.parser.TemplateDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetGenerator {
    public String compile(ResultSet rs, String template) {
        InputStream templateStream = this.getClass().getResourceAsStream(template);
        return this.compile(rs, templateStream);
    }

    public String compile(ResultSet rs, InputStream templateStream) {
        DefaultTemplateContainer tc = new DefaultTemplateContainer(templateStream);
        this.closeStream(templateStream);
        return this.compile(rs, new TemplateDataListener(tc));
    }

    public String compile(ResultSet rs, TemplateDataListener listener) {
        ArrayList<DataListener> listeners = new ArrayList<DataListener>();
        listeners.add(listener);
        this.processData(rs, listeners);
        return listener.renderDRL();
    }

    private void processData(ResultSet rs, List<DataListener> listeners) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            int i = 0;
            while (rs.next()) {
                this.newRow(listeners, i, colCount);
                int cellNum = 1;
                while (cellNum < colCount + 1) {
                    String cell;
                    int sqlType = rsmd.getColumnType(cellNum);
                    switch (sqlType) {
                        case 91: {
                            cell = rs.getDate(cellNum).toString();
                            break;
                        }
                        case 4: 
                        case 8: {
                            cell = String.valueOf(rs.getInt(cellNum));
                            break;
                        }
                        default: {
                            cell = rs.getString(cellNum);
                        }
                    }
                    this.newCell(listeners, i, cellNum - 1, cell, -1);
                    ++cellNum;
                }
                ++i;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.finishData(listeners);
    }

    private void finishData(List<DataListener> listeners) {
        for (DataListener listener : listeners) {
            listener.finishSheet();
        }
    }

    private void newRow(List<DataListener> listeners, int row, int cols) {
        for (DataListener listener : listeners) {
            listener.newRow(row, cols);
        }
    }

    public void newCell(List<DataListener> listeners, int row, int column, String value, int mergedColStart) {
        for (DataListener listener : listeners) {
            listener.newCell(row, column, value, mergedColStart);
        }
    }

    protected void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            System.err.print("WARNING: Wasn't able to correctly close stream for rule template. " + e.getMessage());
        }
    }
}

