/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.util.Map;
import org.drools.template.parser.Cell;
import org.drools.template.parser.Column;
import org.drools.template.parser.Row;

public abstract class AbstractCell<T>
implements Cell<T> {
    protected final Row row;
    protected final Column column;
    protected int index;
    protected T value;

    protected AbstractCell(Row r, Column c) {
        this.row = r;
        this.column = c;
    }

    public String toString() {
        return "Cell[" + this.column + ": " + this.value + "]";
    }

    @Override
    public Row getRow() {
        return this.row;
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void addValue(Map<String, Object> vars) {
        vars.put(this.column.getName(), this.value);
    }

    @Override
    public void setIndex(int i) {
        this.index = i;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }
}

