/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.backend.server;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.lang.Expander;
import org.drools.compiler.lang.dsl.DSLMappingFile;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.service.GuidedRuleEditorService;
import org.drools.workbench.screens.guided.rule.type.GuidedRuleDSLRResourceTypeDefinition;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.workbench.common.services.backend.file.DSLFileFilter;
import org.kie.workbench.common.services.backend.source.BaseSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GuidedRuleDSLRSourceService
extends BaseSourceService<RuleModel> {
    private static final Logger logger = LoggerFactory.getLogger(GuidedRuleDSLRSourceService.class);
    private static final DSLFileFilter FILTER_DSLS = new DSLFileFilter();
    @Inject
    private GuidedRuleDSLRResourceTypeDefinition resourceType;
    @Inject
    private GuidedRuleEditorService guidedRuleEditorService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private FileDiscoveryService fileDiscoveryService;
    @Inject
    private ProjectService projectService;

    public String getPattern() {
        return this.resourceType.getSuffix();
    }

    public String getSource(Path path, RuleModel model) {
        String dslr = RuleModelDRLPersistenceImpl.getInstance().marshal(model);
        Expander expander = this.getDSLExpander(path);
        String drl = expander.expand(dslr);
        return drl;
    }

    public String getSource(Path path) {
        return this.getSource(path, (RuleModel)this.guidedRuleEditorService.load(Paths.convert((Path)path)));
    }

    public Expander getDSLExpander(Path path) {
        DefaultExpander expander = new DefaultExpander();
        List<DSLMappingFile> dsls = this.getDSLMappingFiles(path);
        for (DSLMappingFile dsl : dsls) {
            expander.addDSLMapping(dsl.getMapping());
        }
        return expander;
    }

    private List<DSLMappingFile> getDSLMappingFiles(Path path) {
        ArrayList<DSLMappingFile> dsls = new ArrayList<DSLMappingFile>();
        org.uberfire.backend.vfs.Path vfsPath = Paths.convert((Path)path);
        org.uberfire.backend.vfs.Path packagePath = this.projectService.resolvePackage(vfsPath).getPackageMainResourcesPath();
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        Collection dslPaths = this.fileDiscoveryService.discoverFiles(nioPackagePath, (DirectoryStream.Filter)FILTER_DSLS);
        for (Path dslPath : dslPaths) {
            String dslDefinition = this.ioService.readAllString(dslPath);
            DSLTokenizedMappingFile dslFile = new DSLTokenizedMappingFile();
            try {
                if (dslFile.parseAndLoad((Reader)new StringReader(dslDefinition))) {
                    dsls.add((DSLMappingFile)dslFile);
                    continue;
                }
                logger.error("Unable to parse DSL definition: " + dslDefinition);
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage());
            }
        }
        return dsls;
    }
}

