/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.backend.server;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.backend.server.GuidedRuleEditorServiceUtilities;
import org.drools.workbench.screens.guided.rule.backend.server.GuidedRuleModelVisitor;
import org.drools.workbench.screens.guided.rule.backend.server.RuleModelWrapper;
import org.drools.workbench.screens.guided.rule.model.GuidedEditorContent;
import org.drools.workbench.screens.guided.rule.service.GuidedRuleEditorService;
import org.drools.workbench.screens.guided.rule.type.GuidedRuleDRLResourceTypeDefinition;
import org.drools.workbench.screens.guided.rule.type.GuidedRuleDSLRResourceTypeDefinition;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.file.CopyService;
import org.guvnor.common.services.shared.file.DeleteService;
import org.guvnor.common.services.shared.file.RenameService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.file.DRLFileFilter;
import org.kie.workbench.common.services.backend.file.DSLFileFilter;
import org.kie.workbench.common.services.backend.file.DSLRFileFilter;
import org.kie.workbench.common.services.backend.file.GlobalsFileFilter;
import org.kie.workbench.common.services.backend.file.RDRLFileFilter;
import org.kie.workbench.common.services.backend.file.RDSLRFileFilter;
import org.kie.workbench.common.services.backend.source.SourceServices;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class GuidedRuleEditorServiceImpl
implements GuidedRuleEditorService {
    private static final JavaFileFilter FILTER_JAVA = new JavaFileFilter();
    private static final DRLFileFilter FILTER_DRL = new DRLFileFilter();
    private static final DSLRFileFilter FILTER_DSLR = new DSLRFileFilter();
    private static final DSLFileFilter FILTER_DSL = new DSLFileFilter();
    private static final RDRLFileFilter FILTER_RDRL = new RDRLFileFilter();
    private static final RDSLRFileFilter FILTER_RDSLR = new RDSLRFileFilter();
    private static final GlobalsFileFilter FILTER_GLOBAL = new GlobalsFileFilter();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private GuidedRuleEditorServiceUtilities utilities;
    @Inject
    private ProjectService projectService;
    @Inject
    private SourceServices sourceServices;
    @Inject
    private GuidedRuleDRLResourceTypeDefinition drlResourceType;
    @Inject
    private GuidedRuleDSLRResourceTypeDefinition dslrResourceType;
    @Inject
    private GenericValidator genericValidator;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, RuleModel model, String comment) {
        try {
            Package pkg = this.projectService.resolvePackage(context);
            String packageName = pkg == null ? null : pkg.getPackageName();
            model.setPackageName(packageName);
            model.getImports().addImport(new Import("java.lang.Number"));
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, this.toSource(newPath, model), new OpenOption[]{this.utilities.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public RuleModel load(org.uberfire.backend.vfs.Path path) {
        try {
            String drl = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            List<String> globals = this.utilities.loadGlobalsForPackage(path);
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            RuleModel ruleModel = null;
            if (this.dslrResourceType.accept(path)) {
                String[] dsls = this.utilities.loadDslsForPackage(path);
                ruleModel = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, globals, oracle, dsls);
            } else {
                ruleModel = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, globals, oracle);
            }
            return ruleModel;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        try {
            RuleModel model = this.load(path);
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
            GuidedRuleModelVisitor visitor = new GuidedRuleModelVisitor(model);
            DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, visitor.getConsumedModelClasses());
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
            return new GuidedEditorContent(model, dataModel);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, RuleModel model, Metadata metadata, String comment) {
        try {
            Package pkg = this.projectService.resolvePackage(resource);
            String packageName = pkg == null ? null : pkg.getPackageName();
            model.setPackageName(packageName);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), this.toSourceUnexpanded(resource, model), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.utilities.makeCommentedOption(comment)});
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String toSource(org.uberfire.backend.vfs.Path path, RuleModel model) {
        try {
            return this.toSourceExpanded(path, model);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, RuleModel content) {
        try {
            String source = this.toSourceUnexpanded(path, content);
            return this.genericValidator.validate(path, (InputStream)new ByteArrayInputStream(source.getBytes(Charsets.UTF_8)), new DirectoryStream.Filter[]{FILTER_JAVA, FILTER_DRL, FILTER_DSLR, FILTER_DSL, FILTER_RDRL, FILTER_RDSLR, FILTER_GLOBAL});
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private String toSourceExpanded(org.uberfire.backend.vfs.Path path, RuleModel model) {
        return this.sourceServices.getServiceFor(Paths.convert((org.uberfire.backend.vfs.Path)path)).getSource(Paths.convert((org.uberfire.backend.vfs.Path)path), (Object)model);
    }

    private String toSourceUnexpanded(org.uberfire.backend.vfs.Path path, RuleModel content) {
        RuleModelWrapper model = new RuleModelWrapper(content, this.dslrResourceType.accept(path));
        String source = RuleModelDRLPersistenceImpl.getInstance().marshal((RuleModel)model);
        return source;
    }
}

