/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.workbench.common.services.backend.file.DSLFileFilter;
import org.kie.workbench.common.services.backend.file.GlobalsFileFilter;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;

@ApplicationScoped
public class GuidedRuleEditorServiceUtilities {
    private static final GlobalsFileFilter FILTER_GLOBALS = new GlobalsFileFilter();
    private static final DSLFileFilter FILTER_DSLS = new DSLFileFilter();
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private FileDiscoveryService fileDiscoveryService;
    @Inject
    private ProjectService projectService;

    public String[] loadDslsForPackage(org.uberfire.backend.vfs.Path path) {
        ArrayList<String> dsls = new ArrayList<String>();
        org.uberfire.backend.vfs.Path packagePath = this.projectService.resolvePackage(path).getPackageMainResourcesPath();
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        Collection dslPaths = this.fileDiscoveryService.discoverFiles(nioPackagePath, (DirectoryStream.Filter)FILTER_DSLS);
        for (Path dslPath : dslPaths) {
            String dslDefinition = this.ioService.readAllString(dslPath);
            dsls.add(dslDefinition);
        }
        String[] result = new String[dsls.size()];
        return dsls.toArray(result);
    }

    public List<String> loadGlobalsForPackage(org.uberfire.backend.vfs.Path path) {
        ArrayList<String> globals = new ArrayList<String>();
        org.uberfire.backend.vfs.Path packagePath = this.projectService.resolvePackage(path).getPackageMainResourcesPath();
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        Collection globalPaths = this.fileDiscoveryService.discoverFiles(nioPackagePath, (DirectoryStream.Filter)FILTER_GLOBALS);
        for (Path globalPath : globalPaths) {
            String globalDefinition = this.ioService.readAllString(globalPath);
            globals.add(globalDefinition);
        }
        return globals;
    }

    public CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(this.sessionInfo.getId(), name, null, commitMessage, when);
        return co;
    }
}

