/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.support.converters;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.drools.util.IoUtils;
import org.kie.api.builder.model.KieModuleModel;
import org.xml.sax.SAXException;

public class KieModuleValidator {
    private static final Schema schema = KieModuleValidator.loadSchema("org/kie/api/kmodule.xsd");
    private static final Schema oldSchema = KieModuleValidator.loadSchema("org/kie/api/old-kmodule.xsd");

    private static Schema loadSchema(String xsd) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory", ClassLoader.getSystemClassLoader());
            URL url = KieModuleModel.class.getClassLoader().getResource(xsd);
            Schema schema = url != null ? factory.newSchema(url) : null;
            return schema;
        }
        catch (SAXException ex) {
            throw new RuntimeException("Unable to load XSD", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    static void validate(byte[] bytes) {
        KieModuleValidator.validate((Source)new StreamSource(new ByteArrayInputStream(bytes)), new StreamSource(new ByteArrayInputStream(bytes)));
    }

    static void validate(File kModuleFile) {
        KieModuleValidator.validate((Source)new StreamSource(kModuleFile), new StreamSource(kModuleFile));
    }

    static void validate(URL kModuleUrl) {
        String urlString;
        try {
            urlString = kModuleUrl.toURI().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        KieModuleValidator.validate((Source)new StreamSource(urlString), new StreamSource(urlString));
    }

    static void validate(String kModuleString) {
        byte[] bytes = kModuleString.getBytes(IoUtils.UTF8_CHARSET);
        KieModuleValidator.validate(bytes);
    }

    static void validate(Source source, Source duplicateSource) {
        try {
            KieModuleValidator.validate(source, schema);
        }
        catch (Exception schemaException) {
            try {
                if (oldSchema != null) {
                    KieModuleValidator.validate(duplicateSource, oldSchema);
                }
            }
            catch (Exception oldSchemaException) {
                throw new RuntimeException("XSD validation failed against the new schema (" + schemaException.getMessage() + ") and against the old schema (" + oldSchemaException.getMessage() + ").", schemaException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validate(Source source, Schema schema) throws SAXException, IOException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            Validator validator = schema.newValidator();
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            validator.validate(source);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

