/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.drools.core.command.runtime.rule.InsertElementsCommand;
import org.drools.simulation.fluent.simulation.SimulationFluent;
import org.drools.simulation.fluent.simulation.impl.DefaultSimulationFluent;
import org.jbpm.simulation.AggregatedSimulationEvent;
import org.jbpm.simulation.PathFinder;
import org.jbpm.simulation.PathFinderFactory;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationContextFactory;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.SimulationEvent;
import org.jbpm.simulation.SimulationInfo;
import org.jbpm.simulation.SimulationRepository;
import org.jbpm.simulation.SimulationRunner;
import org.jbpm.simulation.converter.SimulationFilterPathFormatConverter;
import org.jbpm.simulation.helper.TestUtils;
import org.jbpm.simulation.impl.BPMN2SimulationDataProvider;
import org.jbpm.simulation.impl.SimulateProcessPathCommand;
import org.jbpm.simulation.impl.SimulationPath;
import org.jbpm.simulation.impl.WorkingMemorySimulationRepository;
import org.jbpm.simulation.impl.events.ActivitySimulationEvent;
import org.jbpm.simulation.impl.events.AggregatedEndEventSimulationEvent;
import org.jbpm.simulation.impl.events.AggregatedProcessSimulationEvent;
import org.jbpm.simulation.impl.events.EndSimulationEvent;
import org.jbpm.simulation.impl.events.GenericSimulationEvent;
import org.jbpm.simulation.impl.events.HumanTaskActivitySimulationEvent;
import org.jbpm.simulation.impl.events.ProcessInstanceEndSimulationEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.Command;
import org.kie.api.io.ResourceType;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class SimulateProcessTest {
    @Before
    public void configure() {
    }

    @Test
    public void testSimpleExclusiveGatewayTest() throws Exception {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN-SimpleExclusiveGatewayProcess.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        Assert.assertEquals((long)2L, (long)paths.size());
        SimulationContext context = SimulationContextFactory.newContext((SimulationDataProvider)new BPMN2SimulationDataProvider(this.getClass().getResourceAsStream("/BPMN-SimpleExclusiveGatewayProcess.bpmn2")));
        ReleaseId releaseId = TestUtils.createKJarWithMultipleResources("TestKbase", new String[]{"BPMN-SimpleExclusiveGatewayProcess.bpmn2"}, new ResourceType[]{ResourceType.BPMN2});
        SimulationDataProvider provider = context.getDataProvider();
        DefaultSimulationFluent f = new DefaultSimulationFluent();
        int numberOfAllInstances = 10;
        int counter = 0;
        long interval = 120000L;
        for (SimulationPath path : paths) {
            double probability = provider.calculatePathProbability(path);
            f.newPath("path" + counter);
            int instancesOfPath = (int)((double)numberOfAllInstances * probability);
            for (int i = 0; i < instancesOfPath; ++i) {
                ((SimulationFluent)((SimulationFluent)f.newStep(interval * (long)i)).newKieSession(releaseId, "TestKbase.KSession1").end("ROOT", StatefulKnowledgeSession.class.getName())).addCommand((Command)new SimulateProcessPathCommand("defaultPackage.test", context, path));
            }
            ++counter;
        }
        f.runSimulation();
    }

    @Test
    public void testSimulationRunner() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN2-TwoUserTasks.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"BPMN2-TwoUserTasks", (String)out, (int)10, (long)2000L, (String[])new String[]{"default.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        wmRepo.fireAllRules();
        Assert.assertEquals((long)4L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)50L, (long)wmRepo.getEvents().size());
        AggregatedSimulationEvent event = (AggregatedSimulationEvent)wmRepo.getAggregatedEvents().get(0);
        if (event instanceof AggregatedEndEventSimulationEvent) {
            Assert.assertNotNull((Object)event.getProperty("minProcessDuration"));
            Assert.assertFalse((boolean)event.getProperty("activityId").equals(""));
        }
        event = (AggregatedSimulationEvent)wmRepo.getAggregatedEvents().get(1);
        Assert.assertFalse((boolean)event.getProperty("activityId").equals(""));
        Assert.assertNotNull((Object)event.getProperty("minExecutionTime"));
        event = (AggregatedSimulationEvent)wmRepo.getAggregatedEvents().get(2);
        Assert.assertFalse((boolean)event.getProperty("activityId").equals(""));
        Assert.assertNotNull((Object)event.getProperty("minExecutionTime"));
        event = (AggregatedSimulationEvent)wmRepo.getAggregatedEvents().get(3);
        Assert.assertNotNull((Object)event.getProperty("minExecutionTime"));
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithGateway() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN-SimpleExclusiveGatewayProcess.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"defaultPackage.test", (String)out, (int)10, (long)2000L, (String[])new String[]{"default.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        wmRepo.fireAllRules();
        Assert.assertEquals((long)5L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)70L, (long)wmRepo.getEvents().size());
        List aggEvents = wmRepo.getAggregatedEvents();
        for (AggregatedSimulationEvent event : aggEvents) {
            if (!(event instanceof AggregatedProcessSimulationEvent)) continue;
            Map numberOfInstancePerPath = ((AggregatedProcessSimulationEvent)event).getPathNumberOfInstances();
            Assert.assertNotNull((Object)numberOfInstancePerPath);
            Assert.assertTrue((3 == (Integer)numberOfInstancePerPath.get("Path800898475-0") ? 1 : 0) != 0);
            Assert.assertTrue((7 == (Integer)numberOfInstancePerPath.get("Path-960633761-1") ? 1 : 0) != 0);
        }
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithGatewaySingleInstance() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN-SimpleExclusiveGatewayProcess.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"defaultPackage.test", (String)out, (int)1, (long)2000L, (String[])new String[]{"default.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        wmRepo.fireAllRules();
        Assert.assertEquals((long)4L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)7L, (long)wmRepo.getEvents().size());
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithGatewayTwoInstances() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN-SimpleExclusiveGatewayProcess.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"defaultPackage.test", (String)out, (int)2, (long)2000L, (String[])new String[]{"default.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        wmRepo.fireAllRules();
        Assert.assertEquals((long)5L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)14L, (long)wmRepo.getEvents().size());
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithGatewaySingleInstanceWithRunRulesOnEveryEvent() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN-SimpleExclusiveGatewayProcess.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"defaultPackage.test", (String)out, (int)5, (long)2000L, (boolean)true, (String[])new String[]{"default.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        Assert.assertEquals((long)20L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)35L, (long)wmRepo.getEvents().size());
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithRunRulesOnEveryEvent() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN-SimpleExclusiveGatewayProcess.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"defaultPackage.test", (String)out, (int)5, (long)2000L, (boolean)true, (String[])new String[]{"onevent.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        Assert.assertEquals((long)20L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)35L, (long)wmRepo.getEvents().size());
        for (SimulationEvent event : wmRepo.getEvents()) {
            if (event instanceof EndSimulationEvent || event instanceof ActivitySimulationEvent || event instanceof HumanTaskActivitySimulationEvent) {
                Assert.assertNotNull((Object)((GenericSimulationEvent)event).getAggregatedEvent());
                Assert.assertTrue((boolean)(((GenericSimulationEvent)event).getAggregatedEvent() instanceof AggregatedProcessSimulationEvent));
                continue;
            }
            if (!(event instanceof ProcessInstanceEndSimulationEvent)) continue;
            Assert.assertNull((Object)((GenericSimulationEvent)event).getAggregatedEvent());
        }
        wmRepo.getSession().execute((Command)new InsertElementsCommand((Collection)wmRepo.getAggregatedEvents()));
        wmRepo.fireAllRules();
        List summary = (List)wmRepo.getGlobal("summary");
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((long)5L, (long)summary.size());
        for (AggregatedSimulationEvent event : summary) {
            if (!(event instanceof AggregatedProcessSimulationEvent)) continue;
            Map numberOfInstancePerPath = ((AggregatedProcessSimulationEvent)event).getPathNumberOfInstances();
            Assert.assertNotNull((Object)numberOfInstancePerPath);
            Assert.assertEquals((long)1L, (long)((Integer)numberOfInstancePerPath.get("Path800898475-0")).intValue());
            Assert.assertEquals((long)4L, (long)((Integer)numberOfInstancePerPath.get("Path-960633761-1")).intValue());
        }
        SimulationInfo info = wmRepo.getSimulationInfo();
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)"defaultPackage.test", (Object)info.getProcessId());
        Assert.assertEquals((Object)"test", (Object)info.getProcessName());
        Assert.assertEquals((long)5L, (long)info.getNumberOfExecutions());
        Assert.assertEquals((long)2000L, (long)info.getInterval());
        System.out.println("Start date is " + new Date(info.getStartTime()) + " end date is " + new Date(info.getEndTime()));
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithSinglePath() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN2-UserTaskWithSimulationMetaData.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"UserTask", (String)out, (int)5, (long)2000L, (boolean)true, (String[])new String[]{"onevent.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        Assert.assertEquals((long)15L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)20L, (long)wmRepo.getEvents().size());
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithSinglePathAndCatchingEvent() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN2-SinglePathWithCatchingEvent.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"defaultPackage.test", (String)out, (int)5, (long)2000L, (boolean)true, (String[])new String[]{"onevent.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        Assert.assertEquals((long)25L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)30L, (long)wmRepo.getEvents().size());
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithSinglePathAndThrowingEvent() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN2-SinglePathWithThrowingEvent.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"defaultPackage.test", (String)out, (int)5, (long)2000L, (boolean)true, (String[])new String[]{"onevent.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        Assert.assertEquals((long)25L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)30L, (long)wmRepo.getEvents().size());
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithBoundaryEvent() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN2-SimpleWithBoundaryEvent.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"defaultPackage.test", (String)out, (int)5, (long)2000L, (boolean)true, (String[])new String[]{"onevent.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        Assert.assertEquals((long)25L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)30L, (long)wmRepo.getEvents().size());
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithScriptRuleXor() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN2-ScriptRuleXor.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"defaultPackage.demo", (String)out, (int)5, (long)2000L, (boolean)true, (String[])new String[]{"onevent.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        Assert.assertEquals((long)30L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)45L, (long)wmRepo.getEvents().size());
        wmRepo.getSession().execute((Command)new InsertElementsCommand((Collection)wmRepo.getAggregatedEvents()));
        wmRepo.fireAllRules();
        List summary = (List)wmRepo.getGlobal("summary");
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((long)7L, (long)summary.size());
        wmRepo.close();
    }

    @Test
    public void testSimulationRunnerWithLoop() throws IOException {
        InputStreamReader in = new InputStreamReader(this.getClass().getResourceAsStream("/BPMN2-loop-sim.bpmn2"));
        String out = new String();
        BufferedReader br = new BufferedReader(in);
        String line = br.readLine();
        while (line != null) {
            out = out + line;
            line = br.readLine();
        }
        SimulationRepository repo = SimulationRunner.runSimulation((String)"defaultPackage.loop-sim", (String)out, (int)5, (long)2000L, (boolean)true, (String[])new String[]{"onevent.simulation.rules.drl"});
        Assert.assertNotNull((Object)repo);
        WorkingMemorySimulationRepository wmRepo = (WorkingMemorySimulationRepository)repo;
        Assert.assertEquals((long)19L, (long)wmRepo.getAggregatedEvents().size());
        Assert.assertEquals((long)37L, (long)wmRepo.getEvents().size());
        wmRepo.close();
    }
}

