/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.time.SessionPseudoClock;
import org.jbpm.simulation.PathFinder;
import org.jbpm.simulation.PathFinderFactory;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationContextFactory;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.converter.SimulationFilterPathFormatConverter;
import org.jbpm.simulation.helper.HardCodedSimulationDataProvider;
import org.jbpm.simulation.impl.SimulateProcessPathCommand;
import org.jbpm.simulation.impl.SimulationPath;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class SimulationCommandTest {
    @Test
    public void testSimulationCommand() {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN2-ExclusiveSplit.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        SimulationContext context = SimulationContextFactory.newContext((SimulationDataProvider)new HardCodedSimulationDataProvider());
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newClassPathResource((String)"BPMN2-ExclusiveSplit.bpmn2"), ResourceType.BPMN2);
        KnowledgeBase kbase = builder.newKnowledgeBase();
        KieSessionConfiguration config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        config.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        for (SimulationPath sp : paths) {
            StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession(config, EnvironmentFactory.newEnvironment());
            ((SessionPseudoClock)session.getSessionClock()).advanceTime(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            session.execute((Command)new SimulateProcessPathCommand("com.sample.test", context, sp));
        }
    }
}

