/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.core.time.SessionPseudoClock;
import org.jbpm.simulation.PathFinder;
import org.jbpm.simulation.PathFinderFactory;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationContextFactory;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.converter.SimulationFilterPathFormatConverter;
import org.jbpm.simulation.helper.HardCodedSimulationDataProvider;
import org.jbpm.simulation.helper.TestUtils;
import org.jbpm.simulation.impl.SimulationPath;
import org.junit.Test;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class SimulationTest {
    @Test
    public void testParallelGatewayProcessSimulation() {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN2-ParallelSplit.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        SimulationContext context = SimulationContextFactory.newContext((SimulationDataProvider)new HardCodedSimulationDataProvider());
        for (SimulationPath path : paths) {
            context.setCurrentPath(path);
            StatefulKnowledgeSession session = TestUtils.createSession("BPMN2-ParallelSplit.bpmn2");
            context.setClock((SessionPseudoClock)session.getSessionClock());
            context.getClock().advanceTime(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            session.startProcess("com.sample.test");
            System.out.println("#####################################");
        }
    }

    @Test
    public void testExclusiveGatewayProcessSimulation() {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN2-ExclusiveSplit.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        SimulationContext context = SimulationContextFactory.newContext((SimulationDataProvider)new HardCodedSimulationDataProvider());
        for (SimulationPath path : paths) {
            context.setCurrentPath(path);
            StatefulKnowledgeSession session = TestUtils.createSession("BPMN2-ExclusiveSplit.bpmn2");
            context.setClock((SessionPseudoClock)session.getSessionClock());
            context.getClock().advanceTime(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            session.startProcess("com.sample.test");
            System.out.println("#####################################");
        }
    }

    @Test
    public void testUserTaskProcessSimulation() {
        PathFinder finder = PathFinderFactory.getInstance((InputStream)this.getClass().getResourceAsStream("/BPMN2-UserTask.bpmn2"));
        List paths = (List)finder.findPaths((PathFormatConverter)new SimulationFilterPathFormatConverter());
        SimulationContext context = SimulationContextFactory.newContext((SimulationDataProvider)new HardCodedSimulationDataProvider());
        for (SimulationPath path : paths) {
            context.setCurrentPath(path);
            StatefulKnowledgeSession session = TestUtils.createSession("BPMN2-UserTask.bpmn2");
            context.setClock((SessionPseudoClock)session.getSessionClock());
            context.getClock().advanceTime(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            session.startProcess("UserTask");
            System.out.println("#####################################");
        }
    }
}

