/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.ht;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.jbpm.simulation.SimulationContextFactory;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.impl.SimulationPath;
import org.jbpm.simulation.impl.ht.StaffPoolImpl;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.Node;

public class StaffPoolImplTest {
    @Test
    public void testSingleWorkingHours() {
        HumanTaskNode node = new HumanTaskNode();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("quantity", 1);
        properties.put("timeunit", "min");
        properties.put("distributiontype", "exact");
        properties.put("duration", "45");
        SimulationContextFactory.newContext((SimulationDataProvider)new TestSimulationDataProvider(properties));
        StaffPoolImpl pool = new StaffPoolImpl("test", (Node)node, 1.0);
        long startTime = System.currentTimeMillis();
        System.out.println("Start time is " + new Date(startTime));
        long waitTime = pool.allocate(startTime);
        System.out.println("Wait time is " + DurationFormatUtils.formatDurationHMS((long)waitTime));
        Assert.assertEquals((long)0L, (long)waitTime);
        System.out.println("Start time is " + new Date(startTime += 600000L));
        waitTime = pool.allocate(startTime);
        System.out.println("Wait time is " + DurationFormatUtils.formatDurationHMS((long)waitTime));
        Assert.assertEquals((long)0x200B20L, (long)waitTime);
        System.out.println("Start time is " + new Date(startTime += 600000L));
        waitTime = pool.allocate(startTime);
        System.out.println("Wait time is " + DurationFormatUtils.formatDurationHMS((long)waitTime));
        Assert.assertEquals((long)4200000L, (long)waitTime);
        System.out.println("Start time is " + new Date(startTime += 600000L));
        waitTime = pool.allocate(startTime);
        System.out.println("Wait time is " + DurationFormatUtils.formatDurationHMS((long)waitTime));
        Assert.assertEquals((long)6300000L, (long)waitTime);
    }

    @Test
    public void testRangeWorkingHours() {
        HumanTaskNode node = new HumanTaskNode();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("quantity", 1);
        properties.put("timeunit", "min");
        properties.put("distributiontype", "exact");
        properties.put("duration", "45");
        properties.put("working.hours.range", "9-11,14-18");
        SimulationContextFactory.newContext((SimulationDataProvider)new TestSimulationDataProvider(properties));
        Calendar c = Calendar.getInstance();
        c.set(11, 9);
        c.set(12, 0);
        StaffPoolImpl pool = new StaffPoolImpl("test", (Node)node, 1.0);
        long startTime = c.getTimeInMillis();
        System.out.println("Start time is " + new Date(startTime));
        long waitTime = pool.allocate(startTime);
        System.out.println("Wait time is " + DurationFormatUtils.formatDurationHMS((long)waitTime));
        System.out.println("Complete time is " + new Date(startTime + waitTime + 2700000L));
        Assert.assertEquals((long)0L, (long)waitTime);
        System.out.println("Start time is " + new Date(startTime += 600000L));
        waitTime = pool.allocate(startTime);
        System.out.println("Wait time is " + DurationFormatUtils.formatDurationHMS((long)waitTime));
        System.out.println("Complete time is " + new Date(startTime + waitTime + 2700000L));
        Assert.assertEquals((long)0x200B20L, (long)waitTime);
        System.out.println("Start time is " + new Date(startTime += 600000L));
        waitTime = pool.allocate(startTime);
        System.out.println("Wait time is " + DurationFormatUtils.formatDurationHMS((long)waitTime));
        System.out.println("Complete time is " + new Date(startTime + waitTime + 2700000L));
        Assert.assertEquals((long)15000000L, (long)waitTime);
        System.out.println("Start time is " + new Date(startTime += 600000L));
        waitTime = pool.allocate(startTime);
        System.out.println("Wait time is " + DurationFormatUtils.formatDurationHMS((long)waitTime));
        System.out.println("Complete time is " + new Date(startTime + waitTime + 2700000L));
        Assert.assertEquals((long)17100000L, (long)waitTime);
    }

    private class TestSimulationDataProvider
    implements SimulationDataProvider {
        private Map<String, Object> properties = null;

        TestSimulationDataProvider(Map<String, Object> props) {
            this.properties = props;
        }

        public Map<String, Object> getSimulationDataForNode(Node node) {
            return this.properties;
        }

        public double calculatePathProbability(SimulationPath path) {
            return 0.0;
        }

        public Map<String, Object> getProcessDataForNode(Node node) {
            return null;
        }
    }
}

