/*
 * Decompiled with CFR 0.152.
 */
package org.drools.example.api.multiplekbases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class MultipleKbasesExampleTest {
    @Test
    public void testSimpleKieBase() {
        List<Integer> list = this.useKieSession("ksession1");
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList(0, 1, 2, 3)));
    }

    @Test
    public void testKieBaseWithPackage() {
        List<Integer> list = this.useKieSession("ksession2");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList(1)));
    }

    @Test
    public void testKieBaseWithInclusion() {
        List<Integer> list = this.useKieSession("ksession3");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList(1, 2)));
    }

    @Test
    public void testKieBaseWith2Packages() {
        List<Integer> list = this.useKieSession("ksession4");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList(1, 3)));
    }

    @Test
    public void testKieBaseWithPackageAndTransitiveInclusion() {
        List<Integer> list = this.useKieSession("ksession5");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testKieBaseWithAllPackages() {
        List<Integer> list = this.useKieSession("ksession6");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList(1, 2)));
    }

    private List<Integer> useKieSession(String name) {
        KieServices ks = KieServices.Factory.get();
        KieContainer kContainer = ks.getKieClasspathContainer();
        KieSession kSession = kContainer.newKieSession(name);
        ArrayList<Integer> list = new ArrayList<Integer>();
        kSession.setGlobal("list", list);
        kSession.insert((Object)1);
        kSession.fireAllRules();
        return list;
    }
}

