/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.wizard.knowledgebase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.wizard.knowledgebase.GenerateKBaseProducer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class NewKnowledgeBaseWizardPage
extends WizardPage {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private IJavaProject project;
    private IFolder folder;
    private Text kbaseName;
    private Text kbasePkg;
    private IWorkingSet workingSet;
    private ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    private ResourceManager resourceManager;
    private static final int validKBaseNameBit = 1;
    private static final int validKBasePkgBit = 2;
    private static final int validFolderBit = 4;
    private static final int validPageMask = 7;
    private int currentPageMask = 0;

    public NewKnowledgeBaseWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        super("extendedNewKnowledgeBasePage");
        this.setTitle("New Knowledge Baset");
        this.setDescription("Create a new Knowledge Base");
        this.workbench = workbench;
        this.selection = selection;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createControls(composite);
        this.setPageComplete(true);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void createControls(Composite parent) {
        this.createProjectSelector(parent);
        this.createKnowledgeBaseName(parent);
        this.createKnowledgeBasePkgName(parent);
    }

    private void createProjectSelector(Composite container) {
        new ResourceNavigator();
        TreeViewer viewer = new TreeViewer(container, 2820);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), IDEWorkbenchPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 400;
        data.widthHint = 300;
        viewer.getControl().setLayoutData((Object)data);
        if (this.selection.getFirstElement() instanceof IFolder) {
            IResource res = (IResource)this.selection.getFirstElement();
            try {
                if (res.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                    this.project = JavaCore.create((IProject)res.getProject());
                    this.folder = (IFolder)res;
                    viewer.setSelection((ISelection)this.selection, true);
                }
            }
            catch (CoreException coreException) {}
        }
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof IFolder) {
                    IResource res = (IResource)selection.getFirstElement();
                    try {
                        if (res.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                            NewKnowledgeBaseWizardPage.this.project = JavaCore.create((IProject)res.getProject());
                            NewKnowledgeBaseWizardPage.this.folder = (IFolder)res;
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
        });
    }

    private ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFiles().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    private ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFolders().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    public final Image getImage(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter == null) {
            return null;
        }
        ImageDescriptor descriptor = adapter.getImageDescriptor(element);
        if (descriptor == null) {
            return null;
        }
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)descriptor);
    }

    protected final IWorkbenchAdapter getAdapter(Object o) {
        return (IWorkbenchAdapter)Util.getAdapter((Object)o, IWorkbenchAdapter.class);
    }

    private void createKnowledgeBaseName(Composite container) {
        Label pack = new Label(container, 0);
        pack.setText("Knowledge Base Name:");
        pack.setLayoutData((Object)new GridData(32));
        pack.setFont(this.getFont());
        this.kbaseName = new Text(container, 2048);
        this.kbaseName.setLayoutData((Object)new GridData(768));
        this.kbaseName.setToolTipText("Knowledeg Base requires a name");
        this.kbaseName.setFont(this.getFont());
        this.kbaseName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewKnowledgeBaseWizardPage.this.validKBaseName()) {
                    NewKnowledgeBaseWizardPage.this.setPageComplete(NewKnowledgeBaseWizardPage.this.currentPageMask == 7);
                } else {
                    NewKnowledgeBaseWizardPage.this.setPageComplete(false);
                }
            }
        });
    }

    private void createKnowledgeBasePkgName(Composite container) {
        Label pack = new Label(container, 0);
        pack.setText("Package:");
        pack.setLayoutData((Object)new GridData(32));
        pack.setFont(this.getFont());
        this.kbasePkg = new Text(container, 2048);
        this.kbasePkg.setLayoutData((Object)new GridData(768));
        this.kbasePkg.setToolTipText("Package required");
        this.kbasePkg.setFont(this.getFont());
        this.kbasePkg.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewKnowledgeBaseWizardPage.this.validPackageName()) {
                    NewKnowledgeBaseWizardPage.this.setPageComplete(NewKnowledgeBaseWizardPage.this.currentPageMask == 7);
                } else {
                    NewKnowledgeBaseWizardPage.this.setPageComplete(false);
                }
            }
        });
    }

    protected boolean validPage() {
        return this.validKBaseName() && this.validPackageName();
    }

    private boolean validKBaseName() {
        if (this.project == null) {
            this.currentPageMask ^= 4;
            this.setErrorMessage("You must select a folder in a JavaProject");
            return false;
        }
        if (this.kbaseName.getText() == null || this.kbaseName.getText().equals("")) {
            this.currentPageMask ^= 1;
            this.setErrorMessage("You must provide a Knowledeg Base name");
            return false;
        }
        if (this.kbaseNameExists()) {
            this.currentPageMask ^= 1;
            this.setErrorMessage("The Knowledge Base name " + this.kbaseName.getText() + " already exists");
            return false;
        }
        this.currentPageMask |= 4;
        this.currentPageMask |= 1;
        this.setErrorMessage(null);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean kbaseNameExists() {
        IFile ifile = this.project.getProject().getFile("kbasePaths.properties");
        Properties props = new Properties();
        if (!ifile.exists()) return false;
        InputStream is = null;
        try {
            is = ifile.getContents();
            props.load(is);
        }
        catch (IOException e) {
            DroolsEclipsePlugin.log(e);
            if (is == null) return props.containsKey("kbase." + this.kbaseName.getText());
            try {
                is.close();
                return props.containsKey("kbase." + this.kbaseName.getText());
            }
            catch (IOException e2) {
                DroolsEclipsePlugin.log(e2);
            }
            return props.containsKey("kbase." + this.kbaseName.getText());
        }
        catch (CoreException e) {
            try {
                DroolsEclipsePlugin.log(e);
                return props.containsKey("kbase." + this.kbaseName.getText());
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        DroolsEclipsePlugin.log(e3);
                    }
                }
            }
        }
        if (is == null) return props.containsKey("kbase." + this.kbaseName.getText());
        try {
            is.close();
            return props.containsKey("kbase." + this.kbaseName.getText());
        }
        catch (IOException e) {
            DroolsEclipsePlugin.log(e);
        }
        return props.containsKey("kbase." + this.kbaseName.getText());
    }

    private boolean validPackageName() {
        if (this.kbasePkg.getText() == null || this.kbasePkg.getText().equals("")) {
            this.currentPageMask ^= 2;
            this.setErrorMessage("You must provide a Package name for the KBase Provider");
            return false;
        }
        this.currentPageMask |= 2;
        this.setErrorMessage(null);
        return true;
    }

    public boolean finish() {
        if (!this.validPage()) {
            return false;
        }
        IFolder targetFolder = this.folder.getFolder(this.kbaseName.getText());
        try {
            NewKnowledgeBaseWizardPage.createFolder(targetFolder);
        }
        catch (CoreException e2) {
            DroolsEclipsePlugin.log(e2);
        }
        try {
            this.updateKBasePaths(this.kbaseName.getText(), targetFolder.getProjectRelativePath().toString());
            this.updateKprojectProperties(this.kbaseName.getText());
            this.createKBaseProperties(this.kbaseName.getText(), targetFolder);
        }
        catch (IOException e1) {
            DroolsEclipsePlugin.log(e1);
        }
        catch (CoreException e1) {
            DroolsEclipsePlugin.log(e1);
        }
        IPackageFragmentRoot root = this.project.getPackageFragmentRoot((IResource)targetFolder);
        try {
            IClasspathEntry[] oldEntries = this.project.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
            System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
            newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)root.getPath());
            this.project.setRawClasspath(newEntries, null);
        }
        catch (JavaModelException e) {
            DroolsEclipsePlugin.log(e);
            return false;
        }
        try {
            this.generateProducer(this.kbaseName.getText(), this.kbasePkg.getText(), targetFolder);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void generateProducer(String kbaseName, String kbasePkg, IFolder ifolder) throws IOException, CoreException {
        String s = GenerateKBaseProducer.generateProducer(kbasePkg, kbaseName);
        ifolder = ifolder.getFolder((IPath)new Path(kbasePkg.replace('.', '/')));
        NewKnowledgeBaseWizardPage.createFolder(ifolder);
        IFile ifile = ifolder.getFile(String.valueOf(kbaseName) + "Producer.java");
        if (ifile.exists()) {
            ifile.setContents((InputStream)new ByteArrayInputStream(s.getBytes()), true, true, null);
        } else {
            ifile.create((InputStream)new ByteArrayInputStream(s.getBytes()), true, null);
        }
        s = GenerateKBaseProducer.generateQualifier(kbasePkg, kbaseName);
        ifile = ifolder.getFile(String.valueOf(kbaseName) + ".java");
        if (ifile.exists()) {
            ifile.setContents((InputStream)new ByteArrayInputStream(s.getBytes()), true, true, null);
        } else {
            ifile.create((InputStream)new ByteArrayInputStream(s.getBytes()), true, null);
        }
    }

    public void updateKBasePaths(String kbaseName, String kbasePath) throws IOException, CoreException {
        IFile ifile = this.project.getProject().getFile("kbasePaths.properties");
        Properties props = new Properties();
        if (ifile.exists()) {
            InputStream is = null;
            try {
                is = ifile.getContents();
                props.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        props.setProperty("kbase." + kbaseName, kbasePath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        baos.close();
        if (ifile.exists()) {
            ifile.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, null);
        } else {
            ifile.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }

    public void updateKprojectProperties(String kbaseName) throws IOException, CoreException {
        String kbaseEntries;
        IFolder ifolder = this.project.getProject().getFolder("src");
        IFile ifile = ifolder.getFile("kproject.properties");
        Properties props = new Properties();
        if (ifile.exists()) {
            InputStream is = null;
            try {
                is = ifile.getContents();
                props.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        kbaseEntries = (kbaseEntries = props.getProperty("kbaseEntries", "")).length() == 0 ? kbaseName : String.valueOf(kbaseEntries) + ", " + kbaseName;
        props.setProperty("kbaseEntries", kbaseEntries);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        baos.close();
        if (ifile.exists()) {
            ifile.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, null);
        } else {
            ifile.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }

    public void createKBaseProperties(String kbaseName, IFolder kbaseFolder) throws IOException, CoreException {
        IFile ifile = kbaseFolder.getFile(String.valueOf(kbaseName) + ".properties");
        Properties props = new Properties();
        if (ifile.exists()) {
            InputStream is = null;
            try {
                is = ifile.getContents();
                props.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        String files = props.getProperty("files", "");
        props.setProperty("files", files);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        baos.close();
        if (ifile.exists()) {
            ifile.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, null);
        } else {
            ifile.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                NewKnowledgeBaseWizardPage.createFolder((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        }
    }
}

