/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.model;

import java.util.Collections;
import java.util.List;
import org.textmining.extraction.word.model.CHPX;
import org.textmining.extraction.word.model.NodeHelper;
import org.textmining.extraction.word.model.PropertyNode;
import org.textmining.extraction.word.model.TextPiece;
import org.textmining.extraction.word.model.TextPieceTable;

public class ComplexNodeHelper
extends NodeHelper {
    public ComplexNodeHelper(TextPieceTable tpt) {
        super(tpt);
    }

    @Override
    public void addChpNodes(List nodes, byte[] grpprl, int fcStart, int fcEnd) {
        for (int x = 0; x < this._textPieces.size(); ++x) {
            TextPiece tp = (TextPiece)this._textPieces.get(x);
            int pieceFcStart = tp.getFcStart();
            int pieceFcEnd = tp.getFcEnd();
            if (fcStart < pieceFcStart && fcEnd <= pieceFcStart || fcStart >= pieceFcEnd && fcEnd > pieceFcEnd) continue;
            int textStart = Math.max(fcStart, pieceFcStart);
            int textEnd = Math.min(fcEnd, pieceFcEnd);
            int divisor = tp.unicode() ? 2 : 1;
            int cpStart = tp.getStart() + (textStart - pieceFcStart) / divisor;
            int cpEnd = cpStart + (textEnd - textStart) / divisor;
            CHPX chpx = new CHPX(cpStart, cpEnd, grpprl);
            nodes.add(chpx);
        }
    }

    @Override
    public void sortNodes(List nodes, boolean paragraphs) {
        Collections.sort(nodes);
        if (paragraphs) {
            int len = nodes.size();
            int lastEnd = 0;
            for (int x = 0; x < len; ++x) {
                PropertyNode node = (PropertyNode)nodes.get(x);
                node.setStart(lastEnd);
                lastEnd = node.getEnd();
            }
        }
    }
}

