/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.model;

import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.model.NodeHelper;

public abstract class FormattedDiskPage {
    protected byte[] _fkp;
    protected int _crun;
    protected int _offset;
    protected NodeHelper _fc2Cp;
    protected int _currentIndex;

    public FormattedDiskPage() {
    }

    public FormattedDiskPage(byte[] documentStream, int offset, NodeHelper fc2Cp) {
        this._crun = LittleEndian.getUnsignedByte((byte[])documentStream, (int)(offset + 511));
        this._fkp = documentStream;
        this._offset = offset;
        this._fc2Cp = fc2Cp;
    }

    protected int getStart(int index) {
        return LittleEndian.getInt((byte[])this._fkp, (int)(this._offset + index * 4));
    }

    protected int getEnd(int index) {
        return LittleEndian.getInt((byte[])this._fkp, (int)(this._offset + (index + 1) * 4));
    }

    public abstract int size();

    protected abstract byte[] getGrpprl(int var1);
}

