/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word.test;

import java.io.FileInputStream;
import java.io.IOException;
import org.textmining.extraction.TextExtractor;
import org.textmining.extraction.word.PasswordProtectedException;
import org.textmining.extraction.word.Word6TextExtractor;
import org.textmining.extraction.word.test.TestWordExtraction;

public class TestWord6TextExtraction
extends TestWordExtraction {
    public void testSimple() throws IOException, PasswordProtectedException {
        this.textExtractionTest("./test/text/winword6/simple.doc", "This is a simple test of text extraction for Word documents.");
    }

    public void testFastSaved() throws IOException, PasswordProtectedException {
        this.textExtractionTest("./test/text/winword6/fastSaved.doc", "This is a simple test of text extraction for Word documents. This document is a fast saved Word document.");
    }

    public void testWithDeletedChanges() throws IOException, PasswordProtectedException {
        this.textExtractionTest("./test/text/winword6/revisions.doc", "This is a simple test of text extraction for Word documents.");
    }

    public void testFieldCodes() throws IOException, PasswordProtectedException {
        this.textExtractionTest("./test/text/winword6/fieldCode.doc", "This is a simple test of text extraction for Word documents. The page number is 1.");
    }

    @Override
    protected TextExtractor getTextExtractor(FileInputStream in) throws IOException, PasswordProtectedException {
        return new Word6TextExtractor(in);
    }
}

