/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.dspace.administer.MetadataImporter;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RegistryLoader {
    private static Logger log = LogManager.getLogger(RegistryLoader.class);
    protected static BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();

    private RegistryLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        String usage = "Usage: " + RegistryLoader.class.getName() + " (-bitstream | -metadata) registry-file.xml";
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            if (argv[0].equalsIgnoreCase("-bitstream")) {
                RegistryLoader.loadBitstreamFormats(context, argv[1]);
            } else if (argv[0].equalsIgnoreCase("-metadata")) {
                MetadataImporter.loadRegistry(argv[1], true);
            } else {
                System.err.println(usage);
            }
            context.complete();
            System.exit(0);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            System.err.println(usage);
            System.exit(1);
        }
        catch (Exception e) {
            log.fatal(org.dspace.core.LogManager.getHeader(context, "error_loading_registries", ""), (Throwable)e);
            System.err.println("Error: \n - " + e.getMessage());
            System.exit(1);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public static void loadBitstreamFormats(Context context, String filename) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException {
        Document document = RegistryLoader.loadXML(filename);
        NodeList typeNodes = XPathAPI.selectNodeList((Node)document, (String)"dspace-bitstream-types/bitstream-type");
        for (int i = 0; i < typeNodes.getLength(); ++i) {
            Node n = typeNodes.item(i);
            RegistryLoader.loadFormat(context, n);
        }
        log.info(org.dspace.core.LogManager.getHeader(context, "load_bitstream_formats", "number_loaded=" + typeNodes.getLength()));
    }

    private static void loadFormat(Context context, Node node) throws SQLException, IOException, TransformerException, AuthorizeException {
        String mimeType = RegistryLoader.getElementData(node, "mimetype");
        String shortDesc = RegistryLoader.getElementData(node, "short_description");
        String desc = RegistryLoader.getElementData(node, "description");
        String supportLevelString = RegistryLoader.getElementData(node, "support_level");
        int supportLevel = Integer.parseInt(supportLevelString);
        String internalString = RegistryLoader.getElementData(node, "internal");
        boolean internal = Boolean.valueOf(internalString);
        String[] extensions = RegistryLoader.getRepeatedElementData(node, "extension");
        BitstreamFormat exists = bitstreamFormatService.findByMIMEType(context, mimeType);
        if (exists == null) {
            exists = bitstreamFormatService.findByShortDescription(context, shortDesc);
        }
        if (exists == null) {
            BitstreamFormat format = (BitstreamFormat)bitstreamFormatService.create(context);
            format.setMIMEType(mimeType);
            bitstreamFormatService.setShortDescription(context, format, shortDesc);
            format.setDescription(desc);
            format.setSupportLevel(supportLevel);
            format.setInternal(internal);
            ArrayList<String> extensionList = new ArrayList<String>();
            extensionList.addAll(Arrays.asList(extensions));
            format.setExtensions(extensionList);
            bitstreamFormatService.update(context, format);
        }
    }

    private static Document loadXML(String filename) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(new File(filename));
    }

    private static String getElementData(Node parentElement, String childName) throws TransformerException {
        Node childNode = XPathAPI.selectSingleNode((Node)parentElement, (String)childName);
        if (childNode == null) {
            return null;
        }
        Node dataNode = childNode.getFirstChild();
        if (dataNode == null) {
            return null;
        }
        String value = dataNode.getNodeValue().trim();
        return value;
    }

    private static String[] getRepeatedElementData(Node parentElement, String childName) throws TransformerException {
        NodeList childNodes = XPathAPI.selectNodeList((Node)parentElement, (String)childName);
        String[] data = new String[childNodes.getLength()];
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node dataNode = childNodes.item(i).getFirstChild();
            data[i] = dataNode.getNodeValue().trim();
        }
        return data;
    }
}

