/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sitemap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public abstract class AbstractGenerator {
    protected int fileCount = 0;
    protected int bytesWritten;
    protected int urlsWritten;
    protected File outputDir;
    protected PrintStream currentOutput;
    private int trailingByteCount;

    public AbstractGenerator(File outputDirIn) {
        this.outputDir = outputDirIn;
        this.trailingByteCount = this.getTrailingBoilerPlate().length();
        this.currentOutput = null;
    }

    protected void startNewFile() throws IOException {
        String lbp = this.getLeadingBoilerPlate();
        OutputStream fo = new FileOutputStream(new File(this.outputDir, this.getFilename(this.fileCount)));
        if (this.useCompression()) {
            fo = new GZIPOutputStream(fo);
        }
        this.currentOutput = new PrintStream(fo);
        this.currentOutput.print(lbp);
        this.bytesWritten = lbp.length();
        this.urlsWritten = 0;
    }

    public void addURL(String url, Date lastMod) throws IOException {
        String newURLText;
        if (this.currentOutput == null) {
            this.startNewFile();
        }
        if (this.bytesWritten + (newURLText = this.getURLText(url, lastMod)).length() + this.trailingByteCount > this.getMaxSize() || this.urlsWritten + 1 > this.getMaxURLs()) {
            this.closeCurrentFile();
            this.startNewFile();
        }
        this.currentOutput.print(newURLText);
        this.bytesWritten += newURLText.length();
        ++this.urlsWritten;
    }

    protected void closeCurrentFile() throws IOException {
        this.currentOutput.print(this.getTrailingBoilerPlate());
        this.currentOutput.close();
        ++this.fileCount;
    }

    public int finish() throws IOException {
        if (null != this.currentOutput) {
            this.closeCurrentFile();
        }
        OutputStream fo = new FileOutputStream(new File(this.outputDir, this.getIndexFilename()));
        if (this.useCompression()) {
            fo = new GZIPOutputStream(fo);
        }
        PrintStream out = new PrintStream(fo);
        this.writeIndex(out, this.fileCount);
        out.close();
        return this.fileCount;
    }

    public abstract String getURLText(String var1, Date var2);

    public abstract String getLeadingBoilerPlate();

    public abstract String getTrailingBoilerPlate();

    public abstract int getMaxSize();

    public abstract int getMaxURLs();

    public abstract boolean useCompression();

    public abstract String getFilename(int var1);

    public abstract String getIndexFilename();

    public abstract void writeIndex(PrintStream var1, int var2) throws IOException;
}

