/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.Collection;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.core.Utils;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DCInputsReader {
    public static final String DEFAULT_COLLECTION = "default";
    static final String FORM_DEF_FILE = "submission-forms.xml";
    static final String PAIR_TYPE_NAME = "value-pairs-name";
    private Map<String, List<List<Map<String, String>>>> formDefns = null;
    private Map<String, List<String>> valuePairs = null;
    private DCInputSet lastInputSet = null;

    public DCInputsReader() throws DCInputsReaderException {
        String defsFile = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + File.separator + "config" + File.separator + FORM_DEF_FILE;
        this.buildInputs(defsFile);
    }

    public DCInputsReader(String fileName) throws DCInputsReaderException {
        this.buildInputs(fileName);
    }

    private void buildInputs(String fileName) throws DCInputsReaderException {
        this.formDefns = new HashMap<String, List<List<Map<String, String>>>>();
        this.valuePairs = new HashMap<String, List<String>>();
        String uri = "file:" + new File(fileName).getAbsolutePath();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(uri);
            this.doNodes(doc);
            this.checkValues();
        }
        catch (FactoryConfigurationError fe) {
            throw new DCInputsReaderException("Cannot create Submission form parser", fe);
        }
        catch (Exception e) {
            throw new DCInputsReaderException("Error creating submission forms: " + e);
        }
    }

    public Iterator<String> getPairsNameIterator() {
        return this.valuePairs.keySet().iterator();
    }

    public List<String> getPairs(String name) {
        return this.valuePairs.get(name);
    }

    public List<DCInputSet> getInputsByCollectionHandle(String collectionHandle) throws DCInputsReaderException {
        try {
            SubmissionConfig config = new SubmissionConfigReader().getSubmissionConfigByCollection(collectionHandle);
            String formName = config.getSubmissionName();
            if (formName == null) {
                throw new DCInputsReaderException("No form designated as default");
            }
            ArrayList<DCInputSet> results = new ArrayList<DCInputSet>();
            for (int idx = 0; idx < config.getNumberOfSteps(); ++idx) {
                SubmissionStepConfig step = config.getStep(idx);
                if (!"submission-form".equals(step.getType())) continue;
                results.add(this.getInputsByFormName(step.getId()));
            }
            return results;
        }
        catch (SubmissionConfigReaderException e) {
            throw new DCInputsReaderException("No form designated as default", e);
        }
    }

    public List<DCInputSet> getInputsBySubmissionName(String name) throws DCInputsReaderException {
        try {
            SubmissionConfig config = new SubmissionConfigReader().getSubmissionConfigByName(name);
            String formName = config.getSubmissionName();
            if (formName == null) {
                throw new DCInputsReaderException("No form designated as default");
            }
            ArrayList<DCInputSet> results = new ArrayList<DCInputSet>();
            for (int idx = 0; idx < config.getNumberOfSteps(); ++idx) {
                SubmissionStepConfig step = config.getStep(idx);
                if (!"submission-form".equals(step.getType())) continue;
                results.add(this.getInputsByFormName(step.getId()));
            }
            return results;
        }
        catch (SubmissionConfigReaderException e) {
            throw new DCInputsReaderException("No form designated as default", e);
        }
    }

    public DCInputSet getInputsByFormName(String formName) throws DCInputsReaderException {
        if (this.lastInputSet != null && this.lastInputSet.getFormName().equals(formName)) {
            return this.lastInputSet;
        }
        List<List<Map<String, String>>> pages = this.formDefns.get(formName);
        if (pages == null) {
            throw new DCInputsReaderException("Missing the " + formName + " form");
        }
        this.lastInputSet = new DCInputSet(formName, pages, this.valuePairs);
        return this.lastInputSet;
    }

    public int countInputs() {
        return this.formDefns.size();
    }

    public List<DCInputSet> getAllInputs(Integer limit, Integer offset) throws DCInputsReaderException {
        int idx = 0;
        int count = 0;
        LinkedList<DCInputSet> subConfigs = new LinkedList<DCInputSet>();
        for (String key : this.formDefns.keySet()) {
            if (offset == null || idx >= offset) {
                ++count;
                subConfigs.add(this.getInputsByFormName(key));
            }
            ++idx;
            if (count < limit) continue;
            break;
        }
        return subConfigs;
    }

    private void doNodes(Node n) throws SAXException, DCInputsReaderException {
        if (n == null) {
            return;
        }
        Node e = this.getElement(n);
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        boolean foundDefs = false;
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (nd == null || this.isEmptyTextNode(nd)) continue;
            String tagName = nd.getNodeName();
            if (tagName.equals("form-definitions")) {
                this.processDefinition(nd);
                foundDefs = true;
                continue;
            }
            if (!tagName.equals("form-value-pairs")) continue;
            this.processValuePairs(nd);
        }
        if (!foundDefs) {
            throw new DCInputsReaderException("No form definition found");
        }
    }

    private void processDefinition(Node e) throws SAXException, DCInputsReaderException {
        int numForms = 0;
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals("form")) continue;
            ++numForms;
            String formName = this.getAttribute(nd, "name");
            if (formName == null) {
                throw new SAXException("form element has no name attribute");
            }
            ArrayList<ArrayList<Map<String, String>>> rows = new ArrayList<ArrayList<Map<String, String>>>();
            this.formDefns.put(formName, rows);
            NodeList pl = nd.getChildNodes();
            int lenpg = pl.getLength();
            for (int j = 0; j < lenpg; ++j) {
                Node npg = pl.item(j);
                if (!npg.getNodeName().equals("row")) continue;
                ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>();
                this.processRow(formName, j, npg, fields);
                rows.add(fields);
            }
            if (rows.size() >= 1) continue;
            throw new DCInputsReaderException("Form " + formName + " has no rows");
        }
        if (numForms == 0) {
            throw new DCInputsReaderException("No form definition found");
        }
    }

    private void processRow(String formName, int rowIdx, Node n, List<Map<String, String>> fields) throws SAXException, DCInputsReaderException {
        NodeList pl = n.getChildNodes();
        int lenpg = pl.getLength();
        for (int j = 0; j < lenpg; ++j) {
            Node npg = pl.item(j);
            if (!npg.getNodeName().equals("field")) continue;
            HashMap<String, String> field = new HashMap<String, String>();
            this.processField(formName, npg, field);
            fields.add(field);
            String key = (String)field.get(PAIR_TYPE_NAME);
            if (!StringUtils.isNotBlank((CharSequence)key)) continue;
            String schema = (String)field.get("dc-schema");
            String element = (String)field.get("dc-element");
            String qualifier = (String)field.get("dc-qualifier");
            String metadataField = schema + "." + element;
            if (!StringUtils.isNotBlank((CharSequence)qualifier)) continue;
            metadataField = metadataField + "." + qualifier;
        }
        if (fields.size() < 1) {
            throw new DCInputsReaderException("Form " + formName + "row " + rowIdx + " has no fields");
        }
    }

    private void processField(String formName, Node n, Map<String, String> field) throws SAXException {
        String rpt;
        NodeList nl = n.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            String pairTypeName;
            Node nd = nl.item(i);
            if (this.isEmptyTextNode(nd)) continue;
            String tagName = nd.getNodeName();
            String value = this.getValue(nd);
            field.put(tagName, value);
            if (tagName.equals("input-type")) {
                if (!value.equals("dropdown") && !value.equals("qualdrop_value") && !value.equals("list")) continue;
                pairTypeName = this.getAttribute(nd, PAIR_TYPE_NAME);
                if (pairTypeName == null) {
                    throw new SAXException("Form " + formName + ", field " + field.get("dc-element") + "." + field.get("dc-qualifier") + " has no name attribute");
                }
                field.put(PAIR_TYPE_NAME, pairTypeName);
                continue;
            }
            if (tagName.equals("vocabulary")) {
                String closedVocabularyString = this.getAttribute(nd, "closed");
                field.put("closedVocabulary", closedVocabularyString);
                continue;
            }
            if (!tagName.equals("language") || !Boolean.valueOf(value).booleanValue()) continue;
            pairTypeName = this.getAttribute(nd, PAIR_TYPE_NAME);
            if (pairTypeName == null) {
                throw new SAXException("Form " + formName + ", field " + field.get("dc-element") + "." + field.get("dc-qualifier") + " has no language attribute");
            }
            field.put(PAIR_TYPE_NAME, pairTypeName);
        }
        String missing = null;
        if (field.get("dc-element") == null) {
            missing = "dc-element";
        }
        if (field.get("label") == null) {
            missing = "label";
        }
        if (field.get("input-type") == null) {
            missing = "input-type";
        }
        if (missing != null) {
            String msg = "Required field " + missing + " missing on form " + formName;
            throw new SAXException(msg);
        }
        String type = field.get("input-type");
        if ((type.equals("twobox") || type.equals("qualdrop_value")) && ((rpt = field.get("repeatable")) == null || !rpt.equalsIgnoreCase("yes") && !rpt.equalsIgnoreCase("true"))) {
            String msg = "The field '" + field.get("label") + "' must be repeatable";
            throw new SAXException(msg);
        }
    }

    private String checkForDups(String formName, Map<String, String> field, List<List<Map<String, String>>> pages) {
        int matches = 0;
        String err = null;
        String schema = field.get("dc-schema");
        String elem = field.get("dc-element");
        String qual = field.get("dc-qualifier");
        if (schema == null || schema.equals("")) {
            schema = MetadataSchemaEnum.DC.getName();
        }
        for (int i = 0; i < pages.size(); ++i) {
            List<Map<String, String>> pg = pages.get(i);
            for (int j = 0; j < pg.size(); ++j) {
                Map<String, String> fld = pg.get(j);
                String schemaTest = fld.get("dc-schema") == null || fld.get("dc-schema").equals("") ? MetadataSchemaEnum.DC.getName() : fld.get("dc-schema");
                if (!fld.get("dc-element").equals(elem) || !schemaTest.equals(schema)) continue;
                String ql = fld.get("dc-qualifier");
                if (qual != null) {
                    if (ql == null || !ql.equals(qual)) continue;
                    ++matches;
                    continue;
                }
                if (ql != null) continue;
                ++matches;
            }
        }
        if (matches > 1) {
            err = "Duplicate field " + schema + "." + elem + "." + qual + " detected in form " + formName;
        }
        return err;
    }

    private void processValuePairs(Node e) throws SAXException {
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            String tagName = nd.getNodeName();
            if (!tagName.equals("value-pairs")) continue;
            String pairsName = this.getAttribute(nd, PAIR_TYPE_NAME);
            String dcTerm = this.getAttribute(nd, "dc-term");
            if (pairsName == null) {
                String errString = "Missing name attribute for value-pairs for DC term " + dcTerm;
                throw new SAXException(errString);
            }
            ArrayList<String> pairs = new ArrayList<String>();
            this.valuePairs.put(pairsName, pairs);
            NodeList cl = nd.getChildNodes();
            int lench = cl.getLength();
            for (int j = 0; j < lench; ++j) {
                Node nch = cl.item(j);
                String display = null;
                String storage = null;
                if (!nch.getNodeName().equals("pair")) continue;
                NodeList pl = nch.getChildNodes();
                int plen = pl.getLength();
                for (int k = 0; k < plen; ++k) {
                    Node vn = pl.item(k);
                    String vName = vn.getNodeName();
                    if (vName.equals("displayed-value")) {
                        display = this.getValue(vn);
                        continue;
                    }
                    if (!vName.equals("stored-value") || (storage = this.getValue(vn)) != null) continue;
                    storage = "";
                }
                pairs.add(display);
                pairs.add(storage);
            }
        }
    }

    private void checkValues() throws DCInputsReaderException {
        for (String idName : this.formDefns.keySet()) {
            List<List<Map<String, String>>> rows = this.formDefns.get(idName);
            for (int j = 0; j < rows.size(); ++j) {
                List<Map<String, String>> fields = rows.get(j);
                for (int i = 0; i < fields.size(); ++i) {
                    String pairsName;
                    List<String> v;
                    Map<String, String> fld = fields.get(i);
                    String type = fld.get("input-type");
                    if (!type.equals("dropdown") && !type.equals("qualdrop_value") && !type.equals("list") || (v = this.valuePairs.get(pairsName = fld.get(PAIR_TYPE_NAME))) != null) continue;
                    String errString = "Cannot find value pairs for " + pairsName;
                    throw new DCInputsReaderException(errString);
                }
            }
        }
    }

    private Node getElement(Node nd) {
        NodeList nl = nd.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            return n;
        }
        return null;
    }

    private boolean isEmptyTextNode(Node nd) {
        String text;
        boolean isEmpty = false;
        if (nd.getNodeType() == 3 && (text = nd.getNodeValue().trim()).length() == 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    private String getAttribute(Node e, String name) {
        NamedNodeMap attrs = e.getAttributes();
        int len = attrs.getLength();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Node attr = attrs.item(i);
                if (!name.equals(attr.getNodeName())) continue;
                return attr.getNodeValue().trim();
            }
        }
        return null;
    }

    private String getValue(Node nd) {
        NodeList nl = nd.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            short type = n.getNodeType();
            if (type != 3) continue;
            return n.getNodeValue().trim();
        }
        return null;
    }

    public String getInputFormNameByCollectionAndField(Collection collection, String field) throws DCInputsReaderException {
        List<DCInputSet> inputSets = this.getInputsByCollectionHandle(collection.getHandle());
        for (DCInputSet inputSet : inputSets) {
            String standardized;
            String[] tokenized = Utils.tokenize(field);
            String schema = tokenized[0];
            String element = tokenized[1];
            String qualifier = tokenized[2];
            if (StringUtils.isBlank((CharSequence)qualifier)) {
                qualifier = null;
            }
            if (!inputSet.isFieldPresent(standardized = Utils.standardize(schema, element, qualifier, "."))) continue;
            return inputSet.getFormName();
        }
        throw new DCInputsReaderException("No field configuration found!");
    }
}

