/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.beans.Introspector;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DSpaceContextListener
implements ServletContextListener {
    private static Logger log = LogManager.getLogger(DSpaceContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        try {
            String osName = System.getProperty("os.name");
            if (osName != null && osName.toLowerCase().contains("windows")) {
                URL url = new URL("http://localhost/");
                URLConnection urlConn = url.openConnection();
                urlConn.setDefaultUseCaches(false);
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            Introspector.flushCaches();
            Enumeration<Driver> e = DriverManager.getDrivers();
            while (e.hasMoreElements()) {
                Driver driver = e.nextElement();
                if (driver.getClass().getClassLoader() != this.getClass().getClassLoader()) continue;
                DriverManager.deregisterDriver(driver);
            }
        }
        catch (RuntimeException e) {
            log.error("Failed to cleanup ClassLoader for webapp", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Failed to cleanup ClassLoader for webapp", (Throwable)e);
        }
    }
}

