/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.indexer;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authority.factory.AuthorityServiceFactory;
import org.dspace.authority.service.AuthorityService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;

public class AuthorityConsumer
implements Consumer {
    private final Logger log = LogManager.getLogger(AuthorityConsumer.class);
    protected Set<UUID> itemsToUpdateAuthority = null;
    protected Set<UUID> itemsToReindex = null;
    protected ItemService itemService;
    protected AuthorityService authorityService;

    @Override
    public void initialize() throws Exception {
        this.authorityService = AuthorityServiceFactory.getInstance().getAuthorityService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        DSpaceObject dso;
        if (this.itemsToUpdateAuthority == null) {
            this.itemsToUpdateAuthority = new HashSet<UUID>();
            this.itemsToReindex = new HashSet<UUID>();
        }
        if ((dso = event.getSubject(ctx)) instanceof Item) {
            Item item = (Item)dso;
            if (item.isArchived() && !this.itemsToReindex.contains(item.getID())) {
                this.itemsToReindex.add(item.getID());
            }
            if ("ARCHIVED: true".equals(event.getDetail())) {
                this.itemsToUpdateAuthority.add(item.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Context ctx) throws Exception {
        if (this.itemsToUpdateAuthority == null) {
            return;
        }
        try {
            Item item;
            ctx.turnOffAuthorisationSystem();
            for (UUID id : this.itemsToUpdateAuthority) {
                item = (Item)this.itemService.find(ctx, id);
                this.authorityService.indexItem(ctx, item);
            }
            for (UUID id : this.itemsToReindex) {
                item = (Item)this.itemService.find(ctx, id);
                this.authorityService.indexItem(ctx, item);
            }
        }
        catch (Exception e) {
            this.log.error("Error while consuming the authority consumer", (Throwable)e);
        }
        finally {
            this.itemsToUpdateAuthority = null;
            this.itemsToReindex = null;
            ctx.restoreAuthSystemState();
        }
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

