/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid.xml;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authority.orcid.Orcidv2;
import org.dspace.authority.orcid.xml.Converter;
import org.dspace.utils.DSpace;
import org.orcid.jaxb.model.common_v2.OrcidId;
import org.orcid.jaxb.model.record_v2.Person;
import org.orcid.jaxb.model.search_v2.Result;
import org.orcid.jaxb.model.search_v2.Search;
import org.xml.sax.SAXException;

public class XMLtoBio
extends Converter {
    private static Logger log = LogManager.getLogger(XMLtoBio.class);

    public List<Person> convert(InputStream xml) {
        ArrayList<Person> bios = new ArrayList<Person>();
        try {
            Orcidv2 connector = (Orcidv2)new DSpace().getServiceManager().getServiceByName("AuthoritySource", Orcidv2.class);
            Search search = (Search)this.unmarshall(xml, Search.class);
            for (Result result : search.getResult()) {
                OrcidId orcidIdentifier = result.getOrcidIdentifier();
                if (orcidIdentifier == null) continue;
                log.debug("Found OrcidId=" + orcidIdentifier.toString());
                String orcid = orcidIdentifier.getUriPath();
                Person bio = connector.getBio(orcid);
                if (bio == null) continue;
                bios.add(bio);
            }
        }
        catch (URISyntaxException | SAXException e) {
            log.error((Object)e);
        }
        return bios;
    }

    public Person convertSinglePerson(InputStream xml) {
        Person person = null;
        try {
            person = (Person)this.unmarshall(xml, Person.class);
            return person;
        }
        catch (URISyntaxException | SAXException e) {
            log.error((Object)e);
            return null;
        }
    }
}

