/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.browse.BrowseException;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class ItemListConfig {
    private Map<Integer, String[]> metadata = new HashMap<Integer, String[]>();
    private Map<Integer, Integer> types = new HashMap<Integer, Integer>();
    private static final int DATE = 1;
    private static final int TEXT = 2;
    private final transient ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public ItemListConfig() throws BrowseException {
        try {
            Object[] browseFields = this.configurationService.getArrayProperty("webui.itemlist.columns");
            if (ArrayUtils.isEmpty((Object[])browseFields)) {
                throw new BrowseException("There is no configuration for webui.itemlist.columns");
            }
            int i = 1;
            for (Object token : browseFields) {
                Integer key = i;
                if (((String)token).indexOf("(date)") > 0) {
                    token = ((String)token).replaceAll("\\(date\\)", "");
                    this.types.put(key, 1);
                } else {
                    this.types.put(key, 2);
                }
                String[] mdBits = this.interpretField(((String)token).trim(), null);
                this.metadata.put(key, mdBits);
                ++i;
            }
        }
        catch (IOException e) {
            throw new BrowseException(e);
        }
    }

    public int numCols() {
        return this.metadata.size();
    }

    public String[] getMetadata(int col) {
        return this.metadata.get(col);
    }

    public final String[] interpretField(String mfield, String init) throws IOException {
        StringTokenizer sta = new StringTokenizer(mfield, ".");
        String[] field = new String[]{init, init, init};
        int i = 0;
        while (sta.hasMoreTokens()) {
            field[i++] = sta.nextToken();
        }
        if (field[0] == null || field[1] == null) {
            throw new IOException("at least a schema and element be specified in configuration.  You supplied: " + mfield);
        }
        return field;
    }
}

