/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.dao.RelationshipDAO;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.virtual.VirtualMetadataPopulator;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class RelationshipServiceImpl
implements RelationshipService {
    private static final Logger log = LogManager.getLogger();
    @Autowired(required=true)
    protected RelationshipDAO relationshipDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected RelationshipTypeService relationshipTypeService;
    @Autowired
    private VirtualMetadataPopulator virtualMetadataPopulator;

    @Override
    public Relationship create(Context context) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can modify relationship");
        }
        return this.relationshipDAO.create(context, new Relationship());
    }

    @Override
    public Relationship create(Context c, Item leftItem, Item rightItem, RelationshipType relationshipType, int leftPlace, int rightPlace) throws AuthorizeException, SQLException {
        Relationship relationship = new Relationship();
        relationship.setLeftItem(leftItem);
        relationship.setRightItem(rightItem);
        relationship.setRelationshipType(relationshipType);
        relationship.setLeftPlace(leftPlace);
        relationship.setRightPlace(rightPlace);
        return this.create(c, relationship);
    }

    @Override
    public Relationship create(Context context, Relationship relationship) throws SQLException, AuthorizeException {
        if (this.isRelationshipValidToCreate(context, relationship)) {
            if (this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1) || this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
                this.updatePlaceInRelationship(context, relationship, true);
                return this.relationshipDAO.create(context, relationship);
            }
            throw new AuthorizeException("You do not have write rights on this relationship's items");
        }
        throw new IllegalArgumentException("The relationship given was not valid");
    }

    @Override
    public void updatePlaceInRelationship(Context context, Relationship relationship, boolean isCreation) throws SQLException, AuthorizeException {
        int i;
        Item leftItem = relationship.getLeftItem();
        List<Relationship> leftRelationships = this.findByItemAndRelationshipType(context, leftItem, relationship.getRelationshipType(), true);
        Item rightItem = relationship.getRightItem();
        List<Relationship> rightRelationships = this.findByItemAndRelationshipType(context, rightItem, relationship.getRelationshipType(), false);
        context.turnOffAuthorisationSystem();
        if (!this.virtualMetadataPopulator.isUseForPlaceTrueForRelationshipType(relationship.getRelationshipType(), true)) {
            if (!leftRelationships.isEmpty()) {
                leftRelationships.sort(Comparator.comparingInt(Relationship::getLeftPlace));
                for (i = 0; i < leftRelationships.size(); ++i) {
                    leftRelationships.get(i).setLeftPlace(i);
                }
                relationship.setLeftPlace(leftRelationships.size());
            } else {
                relationship.setLeftPlace(0);
            }
        } else {
            this.updateItem(context, leftItem);
        }
        if (!this.virtualMetadataPopulator.isUseForPlaceTrueForRelationshipType(relationship.getRelationshipType(), false)) {
            if (!rightRelationships.isEmpty()) {
                rightRelationships.sort(Comparator.comparingInt(Relationship::getRightPlace));
                for (i = 0; i < rightRelationships.size(); ++i) {
                    rightRelationships.get(i).setRightPlace(i);
                }
                relationship.setRightPlace(rightRelationships.size());
            } else {
                relationship.setRightPlace(0);
            }
        } else {
            this.updateItem(context, rightItem);
        }
        if (isCreation) {
            this.handleCreationPlaces(context, relationship);
        }
        context.restoreAuthSystemState();
    }

    @Override
    public void updateItem(Context context, Item relatedItem) throws SQLException, AuthorizeException {
        relatedItem.setMetadataModified();
        this.itemService.update(context, relatedItem);
    }

    private void handleCreationPlaces(Context context, Relationship relationship) throws SQLException {
        List<Relationship> leftRelationships = this.findByItemAndRelationshipType(context, relationship.getLeftItem(), relationship.getRelationshipType(), true);
        List<Relationship> rightRelationships = this.findByItemAndRelationshipType(context, relationship.getRightItem(), relationship.getRelationshipType(), false);
        leftRelationships.sort((o1, o2) -> o2.getLeftPlace() - o1.getLeftPlace());
        rightRelationships.sort((o1, o2) -> o2.getRightPlace() - o1.getRightPlace());
        if (!leftRelationships.isEmpty()) {
            relationship.setLeftPlace(leftRelationships.get(0).getLeftPlace() + 1);
        } else {
            relationship.setLeftPlace(0);
        }
        if (!rightRelationships.isEmpty()) {
            relationship.setRightPlace(rightRelationships.get(0).getRightPlace() + 1);
        } else {
            relationship.setRightPlace(0);
        }
    }

    @Override
    public int findLeftPlaceByLeftItem(Context context, Item item) throws SQLException {
        return this.relationshipDAO.findLeftPlaceByLeftItem(context, item);
    }

    @Override
    public int findRightPlaceByRightItem(Context context, Item item) throws SQLException {
        return this.relationshipDAO.findRightPlaceByRightItem(context, item);
    }

    private boolean isRelationshipValidToCreate(Context context, Relationship relationship) throws SQLException {
        RelationshipType relationshipType = relationship.getRelationshipType();
        if (!this.verifyEntityTypes(relationship.getLeftItem(), relationshipType.getLeftType())) {
            log.warn("The relationship has been deemed invalid since the leftItem and leftType do no match on entityType");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        if (!this.verifyEntityTypes(relationship.getRightItem(), relationshipType.getRightType())) {
            log.warn("The relationship has been deemed invalid since the rightItem and rightType do no match on entityType");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        if (!this.verifyMaxCardinality(context, relationship.getLeftItem(), relationshipType.getLeftMaxCardinality(), relationshipType)) {
            log.warn("The relationship has been deemed invalid since the left item has more relationships than the left max cardinality allows after we'd store this relationship");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        if (!this.verifyMaxCardinality(context, relationship.getRightItem(), relationshipType.getRightMaxCardinality(), relationshipType)) {
            log.warn("The relationship has been deemed invalid since the right item has more relationships than the right max cardinality allows after we'd store this relationship");
            this.logRelationshipTypeDetailsForError(relationshipType);
            return false;
        }
        return true;
    }

    private void logRelationshipTypeDetailsForError(RelationshipType relationshipType) {
        log.warn("The relationshipType's ID is: " + relationshipType.getID());
        log.warn("The relationshipType's left label is: " + relationshipType.getLeftLabel());
        log.warn("The relationshipType's right label is: " + relationshipType.getRightLabel());
        log.warn("The relationshipType's left entityType label is: " + relationshipType.getLeftType().getLabel());
        log.warn("The relationshipType's right entityType label is: " + relationshipType.getRightType().getLabel());
        log.warn("The relationshipType's left min cardinality is: " + relationshipType.getLeftMinCardinality());
        log.warn("The relationshipType's left max cardinality is: " + relationshipType.getLeftMaxCardinality());
        log.warn("The relationshipType's right min cardinality is: " + relationshipType.getRightMinCardinality());
        log.warn("The relationshipType's right max cardinality is: " + relationshipType.getRightMaxCardinality());
    }

    private boolean verifyMaxCardinality(Context context, Item itemToProcess, Integer maxCardinality, RelationshipType relationshipType) throws SQLException {
        List<Relationship> rightRelationships = this.findByItemAndRelationshipType(context, itemToProcess, relationshipType, false);
        return maxCardinality == null || rightRelationships.size() < maxCardinality;
    }

    private boolean verifyEntityTypes(Item itemToProcess, EntityType entityTypeToProcess) {
        List<MetadataValue> list = this.itemService.getMetadata(itemToProcess, "relationship", "type", null, "*");
        if (list.isEmpty()) {
            return false;
        }
        String leftEntityType = list.get(0).getValue();
        return StringUtils.equals((CharSequence)leftEntityType, (CharSequence)entityTypeToProcess.getLabel());
    }

    @Override
    public Relationship find(Context context, int id) throws SQLException {
        Relationship relationship = (Relationship)this.relationshipDAO.findByID(context, Relationship.class, id);
        return relationship;
    }

    @Override
    public List<Relationship> findByItem(Context context, Item item) throws SQLException {
        List<Relationship> list = this.relationshipDAO.findByItem(context, item);
        list.sort((o1, o2) -> {
            int relationshipType = o1.getRelationshipType().getLeftLabel().compareTo(o2.getRelationshipType().getLeftLabel());
            if (relationshipType != 0) {
                return relationshipType;
            }
            if (o1.getLeftItem() == item) {
                return o1.getLeftPlace() - o2.getLeftPlace();
            }
            return o1.getRightPlace() - o2.getRightPlace();
        });
        return list;
    }

    @Override
    public List<Relationship> findAll(Context context) throws SQLException {
        return this.relationshipDAO.findAll(context, Relationship.class);
    }

    @Override
    public void update(Context context, Relationship relationship) throws SQLException, AuthorizeException {
        this.update(context, Collections.singletonList(relationship));
    }

    @Override
    public void update(Context context, List<Relationship> relationships) throws SQLException, AuthorizeException {
        if (CollectionUtils.isNotEmpty(relationships)) {
            for (Relationship relationship : relationships) {
                if (this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1) || this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
                    if (!this.isRelationshipValidToCreate(context, relationship)) continue;
                    this.relationshipDAO.save(context, relationship);
                    continue;
                }
                throw new AuthorizeException("You do not have write rights on this relationship's items");
            }
        }
    }

    @Override
    public void delete(Context context, Relationship relationship) throws SQLException, AuthorizeException {
        if (this.isRelationshipValidToDelete(context, relationship)) {
            if (!this.authorizeService.authorizeActionBoolean(context, relationship.getLeftItem(), 1) && !this.authorizeService.authorizeActionBoolean(context, relationship.getRightItem(), 1)) {
                throw new AuthorizeException("You do not have write rights on this relationship's items");
            }
        } else {
            throw new IllegalArgumentException("The relationship given was not valid");
        }
        this.relationshipDAO.delete(context, relationship);
        this.updatePlaceInRelationship(context, relationship, false);
    }

    private boolean isRelationshipValidToDelete(Context context, Relationship relationship) throws SQLException {
        if (relationship == null) {
            log.warn("The relationship has been deemed invalid since the relation was null");
            return false;
        }
        if (relationship.getID() == null) {
            log.warn("The relationship has been deemed invalid since the ID off the given relationship was null");
            return false;
        }
        if (this.find(context, relationship.getID()) == null) {
            log.warn("The relationship has been deemed invalid since the relationship is not present in the DB with the current ID");
            this.logRelationshipTypeDetailsForError(relationship.getRelationshipType());
            return false;
        }
        if (!this.checkMinCardinality(context, relationship.getLeftItem(), relationship, relationship.getRelationshipType().getLeftMinCardinality(), true)) {
            log.warn("The relationship has been deemed invalid since the leftMinCardinality constraint would be violated upon deletion");
            this.logRelationshipTypeDetailsForError(relationship.getRelationshipType());
            return false;
        }
        if (!this.checkMinCardinality(context, relationship.getRightItem(), relationship, relationship.getRelationshipType().getRightMinCardinality(), false)) {
            log.warn("The relationship has been deemed invalid since the rightMinCardinality constraint would be violated upon deletion");
            this.logRelationshipTypeDetailsForError(relationship.getRelationshipType());
            return false;
        }
        return true;
    }

    private boolean checkMinCardinality(Context context, Item item, Relationship relationship, Integer minCardinality, boolean isLeft) throws SQLException {
        List<Relationship> list = this.findByItemAndRelationshipType(context, item, relationship.getRelationshipType(), isLeft);
        return minCardinality == null || list.size() > minCardinality;
    }

    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft) throws SQLException {
        List<Relationship> list = this.findByItem(context, item);
        LinkedList<Relationship> listToReturn = new LinkedList<Relationship>();
        for (Relationship relationship : list) {
            if (isLeft) {
                if (!StringUtils.equals((CharSequence)relationship.getRelationshipType().getLeftLabel(), (CharSequence)relationshipType.getLeftLabel())) continue;
                listToReturn.add(relationship);
                continue;
            }
            if (!StringUtils.equals((CharSequence)relationship.getRelationshipType().getRightLabel(), (CharSequence)relationshipType.getRightLabel())) continue;
            listToReturn.add(relationship);
        }
        return listToReturn;
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType) throws SQLException {
        List<Relationship> list = this.findByItem(context, item);
        LinkedList<Relationship> listToReturn = new LinkedList<Relationship>();
        for (Relationship relationship : list) {
            if (!relationship.getRelationshipType().equals(relationshipType)) continue;
            listToReturn.add(relationship);
        }
        return listToReturn;
    }

    @Override
    public List<Relationship> findByRelationshipType(Context context, RelationshipType relationshipType) throws SQLException {
        return this.relationshipDAO.findByRelationshipType(context, relationshipType);
    }
}

