/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DSpaceControlledVocabulary
extends SelfNamedPlugin
implements ChoiceAuthority {
    private static Logger log = LogManager.getLogger(DSpaceControlledVocabulary.class);
    protected static String xpathTemplate = "//node[contains(translate(@label,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz'),'%s')]";
    protected static String idTemplate = "//node[@id = '%s']";
    protected static String idParentTemplate = "//node[@id = '%s']/parent::isComposedBy";
    protected static String[] pluginNames = null;
    protected String vocabularyName = null;
    protected InputSource vocabulary = null;
    protected Boolean suggestHierarchy = true;
    protected Boolean storeHierarchy = true;
    protected String hierarchyDelimiter = "::";

    public static String[] getPluginNames() {
        if (pluginNames == null) {
            DSpaceControlledVocabulary.initPluginNames();
        }
        return (String[])ArrayUtils.clone((Object[])pluginNames);
    }

    private static synchronized void initPluginNames() {
        if (pluginNames == null) {
            String vocabulariesPath = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + "/config/controlled-vocabularies/";
            class XmlFilter
            implements FilenameFilter {
                XmlFilter() {
                }

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            }
            String[] xmlFiles = new File(vocabulariesPath).list(new XmlFilter());
            ArrayList<String> names = new ArrayList<String>();
            for (String filename : xmlFiles) {
                names.add(new File(filename).getName().replace(".xml", ""));
            }
            pluginNames = names.toArray(new String[names.size()]);
            log.info("Got plugin names = " + Arrays.deepToString(pluginNames));
        }
    }

    protected void init() {
        if (this.vocabulary == null) {
            ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
            log.info("Initializing " + this.getClass().getName());
            this.vocabularyName = this.getPluginInstanceName();
            String vocabulariesPath = config.getProperty("dspace.dir") + "/config/controlled-vocabularies/";
            String configurationPrefix = "vocabulary.plugin." + this.vocabularyName;
            this.storeHierarchy = config.getBooleanProperty(configurationPrefix + ".hierarchy.store", this.storeHierarchy.booleanValue());
            this.suggestHierarchy = config.getBooleanProperty(configurationPrefix + ".hierarchy.suggest", this.suggestHierarchy.booleanValue());
            String configuredDelimiter = config.getProperty(configurationPrefix + ".delimiter");
            if (configuredDelimiter != null) {
                this.hierarchyDelimiter = configuredDelimiter.replaceAll("(^\"|\"$)", "");
            }
            String filename = vocabulariesPath + this.vocabularyName + ".xml";
            log.info("Loading " + filename);
            this.vocabulary = new InputSource(filename);
        }
    }

    protected String buildString(Node node) {
        if (node.getNodeType() == 9) {
            return "";
        }
        String parentValue = this.buildString(node.getParentNode());
        Node currentLabel = node.getAttributes().getNamedItem("label");
        if (currentLabel != null) {
            String currentValue = currentLabel.getNodeValue();
            if (parentValue.equals("")) {
                return currentValue;
            }
            return parentValue + this.hierarchyDelimiter + currentValue;
        }
        return parentValue;
    }

    @Override
    public Choices getMatches(String field, String text, Collection collection, int start, int limit, String locale) {
        Choice[] choices;
        this.init();
        log.debug("Getting matches for '" + text + "'");
        String xpathExpression = "";
        String[] textHierarchy = text.split(this.hierarchyDelimiter, -1);
        for (int i = 0; i < textHierarchy.length; ++i) {
            xpathExpression = xpathExpression + String.format(xpathTemplate, textHierarchy[i].replaceAll("'", "&apos;").toLowerCase());
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList results = (NodeList)xpath.evaluate(xpathExpression, this.vocabulary, XPathConstants.NODESET);
            String[] authorities = new String[results.getLength()];
            String[] values = new String[results.getLength()];
            String[] labels = new String[results.getLength()];
            String[] parent = new String[results.getLength()];
            String[] notes = new String[results.getLength()];
            for (int i = 0; i < results.getLength(); ++i) {
                Node node = results.item(i);
                this.readNode(authorities, values, labels, parent, notes, i, node);
            }
            int resultCount = labels.length - start;
            if (limit > 0 && resultCount > limit) {
                resultCount = limit;
            }
            choices = new Choice[resultCount];
            if (resultCount > 0) {
                for (int i = 0; i < resultCount; ++i) {
                    choices[i] = new Choice(authorities[start + i], values[start + i], labels[start + i]);
                    if (StringUtils.isNotBlank((CharSequence)parent[i])) {
                        choices[i].extras.put("parent", parent[i]);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)notes[i])) continue;
                    choices[i].extras.put("note", notes[i]);
                }
            }
        }
        catch (XPathExpressionException e) {
            choices = new Choice[]{};
        }
        return new Choices(choices, 0, choices.length, 400, false);
    }

    @Override
    public Choices getBestMatch(String field, String text, Collection collection, String locale) {
        this.init();
        log.debug("Getting best match for '" + text + "'");
        return this.getMatches(field, text, collection, 0, 2, locale);
    }

    @Override
    public String getLabel(String field, String key, String locale) {
        this.init();
        String xpathExpression = String.format(idTemplate, key);
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node node = (Node)xpath.evaluate(xpathExpression, this.vocabulary, XPathConstants.NODE);
            return node.getAttributes().getNamedItem("label").getNodeValue();
        }
        catch (XPathExpressionException e) {
            return "";
        }
    }

    @Override
    public boolean isHierarchical() {
        return true;
    }

    @Override
    public Choice getChoice(String fieldKey, String authKey, String locale) {
        this.init();
        log.debug("Getting matches for '" + authKey + "'");
        String xpathExpression = String.format(idTemplate, authKey);
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node node = (Node)xpath.evaluate(xpathExpression, this.vocabulary, XPathConstants.NODE);
            if (node != null) {
                String[] authorities = new String[1];
                String[] values = new String[1];
                String[] labels = new String[1];
                String[] parent = new String[1];
                String[] note = new String[1];
                this.readNode(authorities, values, labels, parent, note, 0, node);
                if (values.length > 0) {
                    Choice choice = new Choice(authorities[0], values[0], labels[0]);
                    if (StringUtils.isNotBlank((CharSequence)parent[0])) {
                        choice.extras.put("parent", parent[0]);
                    }
                    if (StringUtils.isNotBlank((CharSequence)note[0])) {
                        choice.extras.put("note", note[0]);
                    }
                    return choice;
                }
            }
        }
        catch (XPathExpressionException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return new Choice("", "", "");
    }

    private void readNode(String[] authorities, String[] values, String[] labels, String[] parent, String[] notes, int i, Node node) {
        String hierarchy = this.buildString(node);
        labels[i] = this.suggestHierarchy != false ? hierarchy : node.getAttributes().getNamedItem("label").getNodeValue();
        values[i] = this.storeHierarchy != false ? hierarchy : node.getAttributes().getNamedItem("label").getNodeValue();
        NodeList childNodes = node.getChildNodes();
        for (int ci = 0; ci < childNodes.getLength(); ++ci) {
            String nodeValue;
            Node firstChild = childNodes.item(ci);
            if (firstChild == null || !"hasNote".equals(firstChild.getNodeName()) || !StringUtils.isNotBlank((CharSequence)(nodeValue = firstChild.getTextContent()))) continue;
            notes[i] = nodeValue;
        }
        Node idAttr = node.getAttributes().getNamedItem("id");
        if (null != idAttr) {
            Node parentIdAttr;
            Node parentN;
            authorities[i] = idAttr.getNodeValue();
            if (this.isHierarchical() && (parentN = node.getParentNode()) != null && (parentN = parentN.getParentNode()) != null && null != (parentIdAttr = parentN.getAttributes().getNamedItem("id"))) {
                parent[i] = parentIdAttr.getNodeValue();
            }
        } else {
            authorities[i] = null;
            parent[i] = null;
        }
    }
}

