/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.SelfNamedPlugin;
import org.jdom.Element;
import org.jdom.Namespace;

public class SimpleDCDisseminationCrosswalk
extends SelfNamedPlugin
implements DisseminationCrosswalk {
    private static final Namespace DC_NS = Namespace.getNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/");
    private static final String DC_XSD = "http://dublincore.org/schemas/xmls/simpledc20021212.xsd";
    private static final String schemaLocation = DC_NS.getURI() + " " + "http://dublincore.org/schemas/xmls/simpledc20021212.xsd";
    private static final Namespace[] namespaces = new Namespace[]{DC_NS, XSI_NS};
    private static final String[] aliases = new String[]{"SimpleDC", "DC"};
    protected final ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public static String[] getPluginNames() {
        return (String[])ArrayUtils.clone((Object[])aliases);
    }

    @Override
    public Element disseminateElement(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Element root = new Element("simpledc", DC_NS);
        root.setAttribute("schemaLocation", schemaLocation, XSI_NS);
        root.addContent(this.disseminateListInternal(dso, false));
        return root;
    }

    @Override
    public List<Element> disseminateList(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        return this.disseminateListInternal(dso, true);
    }

    public List<Element> disseminateListInternal(DSpaceObject dso, boolean addSchema) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("SimpleDCDisseminationCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        List<MetadataValue> allDC = this.itemService.getMetadata(item, MetadataSchemaEnum.DC.getName(), "*", "*", "*");
        ArrayList<Element> dcl = new ArrayList<Element>(allDC.size());
        for (MetadataValue metadataValue : allDC) {
            MetadataField metadataField = metadataValue.getMetadataField();
            if (metadataField.getElement().equals("description") && metadataField.getQualifier() != null && metadataField.getQualifier().equals("provenance")) continue;
            String element = metadataField.getElement().equals("contributor") && metadataField.getQualifier() != null && metadataField.getQualifier().equals("author") ? "creator" : metadataField.getElement();
            Element field = new Element(element, DC_NS);
            field.addContent(metadataValue.getValue());
            if (addSchema) {
                field.setAttribute("schemaLocation", schemaLocation, XSI_NS);
            }
            dcl.add(field);
        }
        return dcl;
    }

    @Override
    public Namespace[] getNamespaces() {
        return (Namespace[])ArrayUtils.clone((Object[])namespaces);
    }

    @Override
    public String getSchemaLocation() {
        return schemaLocation;
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2;
    }

    @Override
    public boolean preferList() {
        return true;
    }
}

