/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.Relationship_;
import org.dspace.content.dao.RelationshipDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class RelationshipDAOImpl
extends AbstractHibernateDAO<Relationship>
implements RelationshipDAO {
    @Override
    public List<Relationship> findByItem(Context context, Item item) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)item), (Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)item)));
        return this.list(context, criteriaQuery, false, Relationship.class, -1, -1);
    }

    @Override
    public int findLeftPlaceByLeftItem(Context context, Item item) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)item));
        List<Relationship> list = this.list(context, criteriaQuery, false, Relationship.class, -1, -1);
        list.sort((o1, o2) -> o2.getLeftPlace() - o1.getLeftPlace());
        if (!list.isEmpty()) {
            return list.get(0).getLeftPlace();
        }
        return 1;
    }

    @Override
    public int findRightPlaceByRightItem(Context context, Item item) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)item));
        List<Relationship> list = this.list(context, criteriaQuery, false, Relationship.class, -1, -1);
        list.sort((o1, o2) -> o2.getLeftPlace() - o1.getLeftPlace());
        if (!list.isEmpty()) {
            return list.get(0).getLeftPlace();
        }
        return 1;
    }

    @Override
    public List<Relationship> findByRelationshipType(Context context, RelationshipType relationshipType) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType));
        return this.list(context, criteriaQuery, true, Relationship.class, -1, -1);
    }
}

