/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.curate.CurationTask;
import org.dspace.curate.ResolvedTask;
import org.dspace.curate.ScriptedTask;
import org.dspace.services.factory.DSpaceServicesFactory;

public class TaskResolver {
    private static Logger log = LogManager.getLogger(TaskResolver.class);
    protected static final String CATALOG = "task.catalog";
    protected final String scriptDir = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("curate.script.dir");
    protected Properties catalog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean installScript(String taskName, String fileName) {
        File script = new File(this.scriptDir, fileName);
        if (script.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(script));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("#") || line.indexOf("$td=") <= 0) continue;
                    String desc = line.substring(line.indexOf("$td=") + 4);
                    String[] tokens = desc.split("\\|");
                    if (tokens[1].length() == 0) {
                        desc = tokens[0] + "|" + fileName + "|" + tokens[2];
                    }
                    this.addDescriptor(taskName, desc);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException ioE) {
                log.error("Error reading task script: " + fileName);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioE) {
                        log.error("Error closing task script: " + fileName);
                    }
                }
            }
        } else {
            log.error("Task script: " + fileName + "not found in: " + this.scriptDir);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptor(String taskName, String descriptor) {
        this.loadCatalog();
        this.catalog.put(taskName, descriptor);
        Writer writer = null;
        try {
            writer = new FileWriter(new File(this.scriptDir, CATALOG));
            this.catalog.store(writer, "do not edit");
        }
        catch (IOException ioE) {
            log.error("Error saving scripted task catalog: task.catalog");
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioE) {
                    log.error("Error closing scripted task catalog: task.catalog");
                }
            }
        }
    }

    public ResolvedTask resolveTask(String taskName) {
        CurationTask ctask = (CurationTask)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(CurationTask.class, taskName);
        if (ctask != null) {
            return new ResolvedTask(taskName, ctask);
        }
        this.loadCatalog();
        String scriptDesc = this.catalog.getProperty(taskName);
        if (scriptDesc != null) {
            ScriptEngineManager mgr = new ScriptEngineManager();
            String[] tokens = scriptDesc.split("\\|");
            ScriptEngine engine = mgr.getEngineByName(tokens[0]);
            if (engine != null) {
                File script = new File(this.scriptDir, tokens[1]);
                if (script.exists()) {
                    try {
                        FileReader reader = new FileReader(script);
                        engine.eval(reader);
                        ((Reader)reader).close();
                        ScriptedTask stask = (ScriptedTask)engine.eval(tokens[2]);
                        return new ResolvedTask(taskName, stask);
                    }
                    catch (FileNotFoundException fnfE) {
                        log.error("Script: '" + script.getName() + "' not found for task: " + taskName);
                    }
                    catch (IOException ioE) {
                        log.error("Error loading script: '" + script.getName() + "'");
                    }
                    catch (ScriptException scE) {
                        log.error("Error evaluating script: '" + script.getName() + "' msg: " + scE.getMessage());
                    }
                } else {
                    log.error("No script: '" + script.getName() + "' found for task: " + taskName);
                }
            } else {
                log.error("Script engine: '" + tokens[0] + "' is not installed");
            }
        }
        return null;
    }

    protected void loadCatalog() {
        if (this.catalog == null) {
            this.catalog = new Properties();
            File catalogFile = new File(this.scriptDir, CATALOG);
            if (catalogFile.exists()) {
                try {
                    FileReader reader = new FileReader(catalogFile);
                    this.catalog.load(reader);
                    ((Reader)reader).close();
                }
                catch (IOException ioE) {
                    log.error("Error loading scripted task catalog: task.catalog");
                }
            }
        }
    }
}

