/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverFilterQuery;
import org.dspace.discovery.DiscoverHitHighlightingField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.FacetYearRange;
import org.dspace.discovery.FullTextContentStreams;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.SolrServiceSearchPlugin;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.discovery.configuration.DiscoveryHitHighlightFieldConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightingConfiguration;
import org.dspace.discovery.configuration.DiscoveryMoreLikeThisConfiguration;
import org.dspace.discovery.configuration.DiscoveryRecentSubmissionsConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.discovery.configuration.HierarchicalSidebarFacetConfiguration;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.dspace.util.MultiFormatDateParser;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SolrServiceImpl
implements SearchService,
IndexingService {
    public static final String DISCOVER_WORKFLOW_CONFIGURATION_NAME = "workflow";
    public static final String DISCOVER_WORKSPACE_CONFIGURATION_NAME = "workspace";
    private static final Logger log = LogManager.getLogger(SolrServiceImpl.class);
    protected static final String LAST_INDEXED_FIELD = "SolrIndexer.lastIndexed";
    protected static final String HANDLE_FIELD = "handle";
    protected static final String RESOURCE_UNIQUE_ID = "search.uniqueid";
    protected static final String RESOURCE_TYPE_FIELD = "search.resourcetype";
    protected static final String RESOURCE_ID_FIELD = "search.resourceid";
    protected static final String NAMED_RESOURCE_TYPE = "namedresourcetype";
    public static final String FILTER_SEPARATOR = "\n|||\n";
    public static final String AUTHORITY_SEPARATOR = "###";
    public static final String STORE_SEPARATOR = "\n|||\n";
    public static final String VARIANTS_STORE_SEPARATOR = "###";
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;
    @Autowired(required=true)
    protected ChoiceAuthorityService choiceAuthorityService;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected MetadataAuthorityService metadataAuthorityService;
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    protected XmlWorkflowItemService workflowItemService;
    @Autowired(required=true)
    protected ClaimedTaskService claimedTaskService;
    @Autowired(required=true)
    protected PoolTaskService poolTaskService;
    @Autowired(required=true)
    protected XmlWorkflowFactory workflowFactory;
    @Autowired(required=true)
    protected GroupService groupService;
    protected SolrClient solr = null;

    protected SolrServiceImpl() {
    }

    protected SolrClient getSolr() {
        if (this.solr == null) {
            UrlValidator urlValidator = new UrlValidator(8L);
            String solrService = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.search.server");
            if (urlValidator.isValid(solrService) || ConfigurationManager.getBooleanProperty("discovery", "solr.url.validation.enabled", true)) {
                try {
                    log.debug("Solr URL: " + solrService);
                    HttpSolrClient solrServer = new HttpSolrClient.Builder(solrService).build();
                    solrServer.setBaseURL(solrService);
                    solrServer.setUseMultiPartPost(true);
                    SolrQuery solrQuery = new SolrQuery().setQuery("search.resourcetype:2 AND search.resourceid:1");
                    solrQuery.setFields(new String[]{RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD});
                    solrServer.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
                    DatabaseUtils.checkReindexDiscovery(this);
                    this.solr = solrServer;
                }
                catch (IOException | SolrServerException e) {
                    log.error("Error while initializing solr server", e);
                }
            } else {
                log.error("Error while initializing solr, invalid url: " + solrService);
            }
        }
        return this.solr;
    }

    @Override
    public void indexContent(Context context, IndexableObject dso) throws SQLException {
        this.indexContent(context, dso, false);
    }

    @Override
    public void indexContent(Context context, IndexableObject dso, boolean force) throws SQLException {
        try {
            String uuid = dso.getID().toString();
            switch (dso.getType()) {
                case 2: {
                    Item item = (Item)dso;
                    if (item.isArchived() || item.isWithdrawn()) {
                        if (force || this.requiresIndexing(dso.getUniqueIndexID(), ((Item)dso).getLastModified())) {
                            this.unIndexContent(context, dso);
                            this.buildDocument(context, (Item)dso);
                        }
                        break;
                    }
                    this.unIndexContent(context, dso);
                    log.info("Removed Item: " + uuid + " from Index");
                    this.indexInProgressSubmissionItem(context, (Item)dso);
                    break;
                }
                case 3: {
                    this.buildDocument(context, (org.dspace.content.Collection)dso);
                    log.info("Wrote Collection: " + uuid + " to Index");
                    break;
                }
                case 4: {
                    this.buildDocument(context, (Community)dso);
                    log.info("Wrote Community: " + uuid + " to Index");
                    break;
                }
                default: {
                    log.error("Only Items, Collections and Communities can be Indexed");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void unIndexContent(Context context, IndexableObject dso) throws SQLException, IOException {
        this.unIndexContent(context, dso, false);
    }

    @Override
    public void unIndexContent(Context context, IndexableObject dso, boolean commit) throws SQLException, IOException {
        try {
            if (dso == null) {
                return;
            }
            String uniqueID = dso.getUniqueIndexID();
            log.debug("Try to delete uniqueID:" + uniqueID);
            this.getSolr().deleteById(uniqueID);
            if (2 == dso.getType()) {
                this.deleteInProgressSubmissionByItemID(uniqueID);
            }
            if (commit) {
                this.getSolr().commit();
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            this.emailException(exception);
        }
    }

    @Override
    public void unIndexContent(Context context, String searchUniqueID) throws IOException {
        this.unIndexContent(context, searchUniqueID, false);
    }

    @Override
    public void unIndexContent(Context context, String searchUniqueID, boolean commit) throws IOException {
        try {
            if (this.getSolr() != null) {
                this.getSolr().deleteById(searchUniqueID);
                if (searchUniqueID.startsWith("2-")) {
                    this.deleteInProgressSubmissionByItemID(searchUniqueID);
                }
                if (commit) {
                    this.getSolr().commit();
                }
            }
        }
        catch (SolrServerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void reIndexContent(Context context, IndexableObject dso) throws SQLException, IOException {
        try {
            this.indexContent(context, dso);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            this.emailException(exception);
        }
    }

    @Override
    public void createIndex(Context c) throws SQLException, IOException {
        this.updateIndex(c, true);
    }

    @Override
    public void updateIndex(Context context) {
        this.updateIndex(context, false);
    }

    @Override
    public void updateIndex(Context context, boolean force) {
        this.updateIndex(context, force, 2);
        this.updateIndex(context, force, 3);
        this.updateIndex(context, force, 4);
    }

    @Override
    public void updateIndex(Context context, boolean force, int type) {
        try {
            switch (type) {
                case 2: {
                    Iterator<Item> items = this.itemService.findAllUnfiltered(context);
                    while (items.hasNext()) {
                        Iterator item = items.next();
                        this.indexContent(context, (IndexableObject)((Object)item), force);
                        context.uncacheEntity(item);
                    }
                    for (WorkspaceItem wsi : this.workspaceItemService.findAll(context)) {
                        this.indexContent(context, wsi.getItem(), force);
                        context.uncacheEntity(wsi);
                    }
                    for (WorkflowItem wfi : this.workflowItemService.findAll(context)) {
                        this.indexContent(context, wfi.getItem(), force);
                        context.uncacheEntity(wfi);
                    }
                    break;
                }
                case 3: {
                    List<org.dspace.content.Collection> collections = this.collectionService.findAll(context);
                    for (org.dspace.content.Collection collection : collections) {
                        this.indexContent(context, collection, force);
                    }
                    break;
                }
                case 4: {
                    List<Community> communities = this.communityService.findAll(context);
                    for (Community community : communities) {
                        this.indexContent(context, community, force);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No type known: " + type);
                }
            }
            if (this.getSolr() != null) {
                this.getSolr().commit();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void cleanIndex(boolean force) throws IOException, SQLException, SearchServiceException {
        if (force) {
            try {
                this.getSolr().deleteByQuery("search.resourcetype:[2 TO 4] AND search.resourcetype:[8 TO 11]");
            }
            catch (Exception e) {
                throw new SearchServiceException(e.getMessage(), e);
            }
        } else {
            this.cleanIndex(false, 2);
            this.cleanIndex(false, 3);
            this.cleanIndex(false, 4);
            this.cleanIndex(false, 8);
            this.cleanIndex(false, 10);
            this.cleanIndex(false, 11);
            this.cleanIndex(false, 9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanIndex(boolean force, int type) throws IOException, SQLException, SearchServiceException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        try {
            if (this.getSolr() == null) {
                return;
            }
            if (force) {
                this.getSolr().deleteByQuery("search.resourcetype:" + type);
            } else {
                SolrQuery query = new SolrQuery();
                query.setFields(new String[]{HANDLE_FIELD});
                query.setQuery("search.resourcetype:" + type);
                QueryResponse rsp = this.getSolr().query((SolrParams)query, SolrRequest.METHOD.POST);
                SolrDocumentList docs = rsp.getResults();
                for (SolrDocument doc : docs) {
                    String uniqueID = (String)doc.getFieldValue(RESOURCE_UNIQUE_ID);
                    IndexableObject o = this.findIndexableObject(context, doc);
                    if (o == null) {
                        log.info("Deleting: " + uniqueID);
                        this.unIndexContent(context, uniqueID);
                        continue;
                    }
                    log.debug("Keeping: " + o.getUniqueIndexID());
                }
            }
        }
        catch (Exception e) {
            log.error("Error cleaning discovery index: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.abort();
        }
    }

    @Override
    public void optimize() {
        try {
            if (this.getSolr() == null) {
                return;
            }
            long start = System.currentTimeMillis();
            System.out.println("SOLR Search Optimize -- Process Started:" + start);
            this.getSolr().optimize();
            long finish = System.currentTimeMillis();
            System.out.println("SOLR Search Optimize -- Process Finished:" + finish);
            System.out.println("SOLR Search Optimize -- Total time taken:" + (finish - start) + " (ms).");
        }
        catch (SolrServerException sse) {
            System.err.println(sse.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    @Override
    public void buildSpellCheck() throws SearchServiceException, IOException {
        try {
            if (this.getSolr() == null) {
                return;
            }
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.set("spellcheck", true);
            solrQuery.set("spellcheck.build", true);
            this.getSolr().query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
        }
        catch (SolrServerException e) {
            log.error((Object)e, (Throwable)e);
            throw new SearchServiceException(e);
        }
    }

    protected void emailException(Exception exception) {
        try {
            String recipient = ConfigurationManager.getProperty("alert.recipient");
            if (StringUtils.isNotBlank((CharSequence)recipient)) {
                String stackTrace;
                Email email = Email.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "internal_error"));
                email.addRecipient(recipient);
                email.addArgument(ConfigurationManager.getProperty("dspace.url"));
                email.addArgument(new Date());
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument(stackTrace);
                email.send();
            }
        }
        catch (Exception e) {
            log.warn("Unable to send email alert", (Throwable)e);
        }
    }

    protected boolean requiresIndexing(String handle, Date lastModified) throws SQLException, IOException, SearchServiceException {
        QueryResponse rsp;
        boolean reindexItem = false;
        boolean inIndex = false;
        SolrQuery query = new SolrQuery();
        query.setQuery("search.uniqueid:" + handle);
        query.setFields(new String[]{LAST_INDEXED_FIELD});
        try {
            if (this.getSolr() == null) {
                return false;
            }
            rsp = this.getSolr().query((SolrParams)query, SolrRequest.METHOD.POST);
        }
        catch (SolrServerException e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
        for (SolrDocument doc : rsp.getResults()) {
            Date lastIndexed;
            inIndex = true;
            Object value = doc.getFieldValue(LAST_INDEXED_FIELD);
            if (!(value instanceof Date) || !(lastIndexed = (Date)value).before(lastModified)) continue;
            reindexItem = true;
        }
        return reindexItem || !inIndex;
    }

    protected List<String> getItemLocations(Context context, Item myitem) throws SQLException {
        Vector<String> locations = new Vector<String>();
        List<Community> communities = this.itemService.getCommunities(context, myitem);
        List<org.dspace.content.Collection> collections = myitem.getCollections();
        int i = 0;
        for (i = 0; i < communities.size(); ++i) {
            locations.add("m" + communities.get(i).getID());
        }
        for (i = 0; i < collections.size(); ++i) {
            locations.add("l" + collections.get(i).getID());
        }
        return locations;
    }

    protected List<String> getCollectionLocations(Context context, org.dspace.content.Collection target) throws SQLException {
        Vector<String> locations = new Vector<String>();
        List<Community> communities = this.communityService.getAllParents(context, target);
        for (Community community : communities) {
            locations.add("m" + community.getID());
        }
        return locations;
    }

    protected List<String> getCommunityLocations(Community target) throws SQLException {
        Vector<String> locations = new Vector<String>();
        List<Community> communities = target.getParentCommunities();
        for (Community community : communities) {
            locations.add("m" + community.getID());
        }
        return locations;
    }

    @Override
    public String createLocationQueryForAdministrableItems(Context context) throws SQLException {
        StringBuilder locationQuery = new StringBuilder();
        if (context.getCurrentUser() != null) {
            List<Group> groupList = EPersonServiceFactory.getInstance().getGroupService().allMemberGroups(context, context.getCurrentUser());
            List<ResourcePolicy> communitiesPolicies = AuthorizeServiceFactory.getInstance().getResourcePolicyService().find(context, context.getCurrentUser(), groupList, 11, 4);
            List<ResourcePolicy> collectionsPolicies = AuthorizeServiceFactory.getInstance().getResourcePolicyService().find(context, context.getCurrentUser(), groupList, 11, 3);
            ArrayList<org.dspace.content.Collection> allCollections = new ArrayList<org.dspace.content.Collection>();
            for (ResourcePolicy rp : collectionsPolicies) {
                org.dspace.content.Collection collection = (org.dspace.content.Collection)ContentServiceFactory.getInstance().getCollectionService().find(context, rp.getdSpaceObject().getID());
                allCollections.add(collection);
            }
            if (CollectionUtils.isNotEmpty(communitiesPolicies) || CollectionUtils.isNotEmpty(allCollections)) {
                locationQuery.append("location:( ");
                for (int i = 0; i < communitiesPolicies.size(); ++i) {
                    ResourcePolicy rp;
                    rp = communitiesPolicies.get(i);
                    Community community = (Community)ContentServiceFactory.getInstance().getCommunityService().find(context, rp.getdSpaceObject().getID());
                    locationQuery.append("m").append(community.getID());
                    if (i != communitiesPolicies.size() - 1) {
                        locationQuery.append(" OR ");
                    }
                    allCollections.addAll(ContentServiceFactory.getInstance().getCommunityService().getAllCollections(context, community));
                }
                Iterator collIter = allCollections.iterator();
                if (communitiesPolicies.size() > 0 && allCollections.size() > 0) {
                    locationQuery.append(" OR ");
                }
                while (collIter.hasNext()) {
                    locationQuery.append("l").append(((org.dspace.content.Collection)collIter.next()).getID());
                    if (!collIter.hasNext()) continue;
                    locationQuery.append(" OR ");
                }
                locationQuery.append(")");
            } else {
                log.warn("We have a collection or community admin with ID: " + context.getCurrentUser().getID() + " without any administrable collection or community!");
            }
        }
        return locationQuery.toString();
    }

    protected void writeDocument(SolrInputDocument doc, FullTextContentStreams streams) throws IOException {
        try {
            if (this.getSolr() != null) {
                if (streams != null && !streams.isEmpty()) {
                    ContentStreamUpdateRequest req = new ContentStreamUpdateRequest("/update/extract");
                    req.addContentStream((ContentStream)streams);
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    for (String name : doc.getFieldNames()) {
                        for (Object val : doc.getFieldValues(name)) {
                            params.add("literal." + name, new String[]{val.toString()});
                        }
                    }
                    req.setParams(params);
                    req.setParam("uprefix", "attr_");
                    req.setParam("fmap.content", "fulltext");
                    req.setParam("extractFormat", "text");
                    req.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
                    req.process(this.getSolr());
                } else {
                    this.getSolr().add(doc);
                }
            }
        }
        catch (SolrServerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void buildDocument(Context context, Community community) throws SQLException, IOException {
        List<String> locations = this.getCommunityLocations(community);
        SolrInputDocument doc = this.buildDocument(4, community.getID(), community.getHandle(), locations);
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration(community);
        DiscoveryHitHighlightingConfiguration highlightingConfiguration = discoveryConfiguration.getHitHighlightingConfiguration();
        ArrayList<String> highlightedMetadataFields = new ArrayList<String>();
        if (highlightingConfiguration != null) {
            for (DiscoveryHitHighlightFieldConfiguration configuration : highlightingConfiguration.getMetadataFields()) {
                highlightedMetadataFields.add(configuration.getField());
            }
        }
        String description = this.communityService.getMetadata(community, "introductory_text");
        String description_abstract = this.communityService.getMetadata(community, "short_description");
        String description_table = this.communityService.getMetadata(community, "side_bar_text");
        String rights = this.communityService.getMetadata(community, "copyright_text");
        String title = this.communityService.getMetadata(community, "name");
        List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(community.getType());
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description", description);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.abstract", description_abstract);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.tableofcontents", description_table);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.rights", rights);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.title", title);
        List solrServiceIndexPlugins = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrServiceIndexPlugin.class);
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : solrServiceIndexPlugins) {
            solrServiceIndexPlugin.additionalIndex(context, community, doc);
        }
        this.writeDocument(doc, null);
    }

    protected void buildDocument(Context context, org.dspace.content.Collection collection) throws SQLException, IOException {
        List<String> locations = this.getCollectionLocations(context, collection);
        SolrInputDocument doc = this.buildDocument(3, collection.getID(), collection.getHandle(), locations);
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration(collection);
        DiscoveryHitHighlightingConfiguration highlightingConfiguration = discoveryConfiguration.getHitHighlightingConfiguration();
        ArrayList<String> highlightedMetadataFields = new ArrayList<String>();
        if (highlightingConfiguration != null) {
            for (DiscoveryHitHighlightFieldConfiguration configuration : highlightingConfiguration.getMetadataFields()) {
                highlightedMetadataFields.add(configuration.getField());
            }
        }
        String description = this.collectionService.getMetadata(collection, "introductory_text");
        String description_abstract = this.collectionService.getMetadata(collection, "short_description");
        String description_table = this.collectionService.getMetadata(collection, "side_bar_text");
        String provenance = this.collectionService.getMetadata(collection, "provenance_description");
        String rights = this.collectionService.getMetadata(collection, "copyright_text");
        String rights_license = this.collectionService.getMetadata(collection, "license");
        String title = this.collectionService.getMetadata(collection, "name");
        List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(collection.getType());
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description", description);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.abstract", description_abstract);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.tableofcontents", description_table);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.provenance", provenance);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.rights", rights);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.rights.license", rights_license);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.title", title);
        List solrServiceIndexPlugins = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrServiceIndexPlugin.class);
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : solrServiceIndexPlugins) {
            solrServiceIndexPlugin.additionalIndex(context, collection, doc);
        }
        this.writeDocument(doc, null);
    }

    protected void addContainerMetadataField(SolrInputDocument doc, List<String> highlightedMetadataFields, List<String> toIgnoreMetadataFields, String metadataField, String value) {
        if ((toIgnoreMetadataFields == null || !toIgnoreMetadataFields.contains(metadataField)) && StringUtils.isNotBlank((CharSequence)value)) {
            doc.addField(metadataField, (Object)value);
            if (highlightedMetadataFields.contains(metadataField)) {
                doc.addField(metadataField + "_hl", (Object)value);
            }
        }
    }

    protected void buildDocument(Context context, Item item) throws SQLException, IOException {
        String handle = item.getHandle();
        if (handle == null) {
            handle = this.handleService.findHandle(context, item);
        }
        List<String> locations = this.getItemLocations(context, item);
        SolrInputDocument doc = this.buildDocument(2, item.getID(), handle, locations);
        log.debug("Building Item: " + handle);
        doc.addField("archived", (Object)item.isArchived());
        doc.addField("withdrawn", (Object)item.isWithdrawn());
        doc.addField("discoverable", (Object)item.isDiscoverable());
        doc.addField("lastModified", (Object)item.getLastModified());
        EPerson submitter = item.getSubmitter();
        if (submitter != null) {
            this.addFacetIndex(doc, "submitter", submitter.getID().toString(), submitter.getFullName());
        }
        List<DiscoveryConfiguration> discoveryConfigurations = SearchUtils.getAllDiscoveryConfigurations(item);
        this.addDiscoveryFields(doc, context, item, discoveryConfigurations);
        String typeText = StringUtils.deleteWhitespace((String)item.getTypeText().toLowerCase());
        String acvalue = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.facet.namedtype." + typeText, typeText + "###" + typeText);
        if (StringUtils.isNotBlank((CharSequence)acvalue)) {
            this.addNamedResourceTypeIndex(doc, acvalue);
        }
        try {
            this.writeDocument(doc, new FullTextContentStreams(context, item));
            log.info("Wrote Item: " + item.getUniqueIndexID() + " to Index");
        }
        catch (RuntimeException e) {
            log.error("Error while writing item to discovery index: " + item.getUniqueIndexID() + " message:" + e.getMessage(), (Throwable)e);
        }
    }

    protected void addDiscoveryFields(SolrInputDocument doc, Context context, Item item, List<DiscoveryConfiguration> discoveryConfigurations) throws SQLException, IOException {
        ArrayList<String> sortFieldsAdded = new ArrayList<String>();
        HashMap searchFilters = null;
        HashSet<String> hitHighlightingFields = new HashSet<String>();
        try {
            searchFilters = new HashMap();
            HashMap<String, DiscoverySortFieldConfiguration> sortFields = new HashMap<String, DiscoverySortFieldConfiguration>();
            HashMap<String, DiscoveryRecentSubmissionsConfiguration> recentSubmissionsConfigurationMap = new HashMap<String, DiscoveryRecentSubmissionsConfiguration>();
            HashSet<String> moreLikeThisFields = new HashSet<String>();
            HashSet<String> appliedConf = new HashSet<String>();
            HashSet<String> appliedDiscoverySearchFilter = new HashSet<String>();
            for (DiscoveryConfiguration discoveryConfiguration : discoveryConfigurations) {
                DiscoveryMoreLikeThisConfiguration moreLikeThisConfiguration;
                DiscoveryHitHighlightingConfiguration hitHighlightingConfiguration;
                DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration;
                if (appliedConf.contains(discoveryConfiguration.getId())) continue;
                appliedConf.add(discoveryConfiguration.getId());
                for (int i = 0; i < discoveryConfiguration.getSearchFilters().size(); ++i) {
                    if (appliedDiscoverySearchFilter.contains(discoveryConfiguration.getSearchFilters().get(i).getIndexFieldName())) continue;
                    appliedDiscoverySearchFilter.add(discoveryConfiguration.getSearchFilters().get(i).getIndexFieldName());
                    LinkedList metadataValueList = new LinkedList();
                    boolean shouldExposeMinMax = false;
                    DiscoverySearchFilter discoverySearchFilter = discoveryConfiguration.getSearchFilters().get(i);
                    if (StringUtils.equalsIgnoreCase((CharSequence)discoverySearchFilter.getFilterType(), (CharSequence)"facet") && ((DiscoverySearchFilterFacet)discoverySearchFilter).exposeMinAndMaxValue()) {
                        shouldExposeMinMax = true;
                    }
                    for (int j = 0; j < discoverySearchFilter.getMetadataFields().size(); ++j) {
                        String metadataField = discoverySearchFilter.getMetadataFields().get(j);
                        List resultingList = searchFilters.get(metadataField) != null ? (List)searchFilters.get(metadataField) : new ArrayList();
                        if (shouldExposeMinMax) {
                            String[] splittedMetadataField = metadataField.split("\\.");
                            String schema = splittedMetadataField[0];
                            String element = splittedMetadataField.length > 1 ? splittedMetadataField[1] : null;
                            String qualifier = splittedMetadataField.length > 2 ? splittedMetadataField[2] : null;
                            metadataValueList.addAll(this.itemService.getMetadata(item, schema, element, qualifier, "*"));
                        }
                        resultingList.add(discoverySearchFilter);
                        searchFilters.put(metadataField, resultingList);
                    }
                    if (metadataValueList.isEmpty() || !shouldExposeMinMax) continue;
                    metadataValueList.sort(new Comparator<MetadataValue>(){

                        @Override
                        public int compare(MetadataValue mdv1, MetadataValue mdv2) {
                            return mdv1.getValue().compareTo(mdv2.getValue());
                        }
                    });
                    MetadataValue firstMetadataValue = (MetadataValue)metadataValueList.get(0);
                    MetadataValue lastMetadataValue = (MetadataValue)metadataValueList.get(metadataValueList.size() - 1);
                    doc.addField(discoverySearchFilter.getIndexFieldName() + "_min", (Object)firstMetadataValue.getValue());
                    doc.addField(discoverySearchFilter.getIndexFieldName() + "_min_sort", (Object)firstMetadataValue.getValue());
                    doc.addField(discoverySearchFilter.getIndexFieldName() + "_max", (Object)lastMetadataValue.getValue());
                    doc.addField(discoverySearchFilter.getIndexFieldName() + "_max_sort", (Object)lastMetadataValue.getValue());
                }
                DiscoverySortConfiguration sortConfiguration = discoveryConfiguration.getSearchSortConfiguration();
                if (sortConfiguration != null) {
                    for (DiscoverySortFieldConfiguration discoverySortConfiguration : sortConfiguration.getSortFields()) {
                        sortFields.put(discoverySortConfiguration.getMetadataField(), discoverySortConfiguration);
                    }
                }
                if ((recentSubmissionConfiguration = discoveryConfiguration.getRecentSubmissionConfiguration()) != null) {
                    recentSubmissionsConfigurationMap.put(recentSubmissionConfiguration.getMetadataSortField(), recentSubmissionConfiguration);
                }
                if ((hitHighlightingConfiguration = discoveryConfiguration.getHitHighlightingConfiguration()) != null) {
                    List<DiscoveryHitHighlightFieldConfiguration> fieldConfigurations = hitHighlightingConfiguration.getMetadataFields();
                    for (DiscoveryHitHighlightFieldConfiguration fieldConfiguration : fieldConfigurations) {
                        hitHighlightingFields.add(fieldConfiguration.getField());
                    }
                }
                if ((moreLikeThisConfiguration = discoveryConfiguration.getMoreLikeThisConfiguration()) == null) continue;
                for (String metadataField : moreLikeThisConfiguration.getSimilarityMetadataFields()) {
                    moreLikeThisFields.add(metadataField);
                }
            }
            ArrayList<String> toProjectionFields = new ArrayList<String>();
            String[] projectionFields = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("discovery.index.projection");
            if (projectionFields != null) {
                for (String field : projectionFields) {
                    toProjectionFields.add(field.trim());
                }
            }
            List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(item.getType());
            List<MetadataValue> mydc = this.itemService.getMetadata(item, "*", "*", "*", "*");
            for (MetadataValue meta : mydc) {
                boolean ignoreAuthority;
                int minConfidence;
                String field;
                MetadataField metadataField = meta.getMetadataField();
                MetadataSchema metadataSchema = metadataField.getMetadataSchema();
                String unqualifiedField = field = metadataSchema.getName() + "." + metadataField.getElement();
                String value = meta.getValue();
                if (value == null) continue;
                if (metadataField.getQualifier() != null && !metadataField.getQualifier().trim().equals("")) {
                    field = field + "." + metadataField.getQualifier();
                }
                if (toIgnoreMetadataFields != null && (toIgnoreMetadataFields.contains(field) || toIgnoreMetadataFields.contains(unqualifiedField + "." + "*"))) continue;
                String authority = null;
                String preferedLabel = null;
                List<String> variants = null;
                boolean isAuthorityControlled = this.metadataAuthorityService.isAuthorityControlled(metadataField);
                int n = minConfidence = isAuthorityControlled ? this.metadataAuthorityService.getMinConfidence(metadataField) : 600;
                if (isAuthorityControlled && meta.getAuthority() != null && meta.getConfidence() >= minConfidence && !(ignoreAuthority = ((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore." + field, (Object)((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore", (Object)new Boolean(false))), true)).booleanValue())) {
                    boolean ignoreVariants;
                    authority = meta.getAuthority();
                    boolean ignorePrefered = (Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-prefered." + field, (Object)((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-prefered", (Object)new Boolean(false))), true);
                    if (!ignorePrefered) {
                        preferedLabel = this.choiceAuthorityService.getLabel(meta, meta.getLanguage());
                    }
                    if (!(ignoreVariants = ((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-variants." + field, (Object)((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("discovery.index.authority.ignore-variants", (Object)new Boolean(false))), true)).booleanValue())) {
                        variants = this.choiceAuthorityService.getVariants(meta);
                    }
                }
                if (searchFilters.get(field) != null || searchFilters.get(unqualifiedField + "." + "*") != null) {
                    List searchFilterConfigs = (List)searchFilters.get(field);
                    if (searchFilterConfigs == null) {
                        searchFilterConfigs = (List)searchFilters.get(unqualifiedField + "." + "*");
                    }
                    for (DiscoverySearchFilter searchFilter : searchFilterConfigs) {
                        Date date = null;
                        String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
                        if (separator == null) {
                            separator = "\n|||\n";
                        }
                        if (searchFilter.getType().equals("date") && (date = MultiFormatDateParser.parse(value)) != null) {
                            value = DateFormatUtils.formatUTC((Date)date, (String)"yyyy-MM-dd");
                        }
                        doc.addField(searchFilter.getIndexFieldName(), (Object)value);
                        doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)value);
                        if (authority != null && preferedLabel == null) {
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)(value + "###" + authority));
                            doc.addField(searchFilter.getIndexFieldName() + "_authority", (Object)authority);
                            doc.addField(searchFilter.getIndexFieldName() + "_acid", (Object)(value.toLowerCase() + separator + value + "###" + authority));
                        }
                        if (preferedLabel != null) {
                            doc.addField(searchFilter.getIndexFieldName(), preferedLabel);
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)preferedLabel);
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)(preferedLabel + "###" + authority));
                            doc.addField(searchFilter.getIndexFieldName() + "_authority", (Object)authority);
                            doc.addField(searchFilter.getIndexFieldName() + "_acid", (Object)(preferedLabel.toLowerCase() + separator + preferedLabel + "###" + authority));
                        }
                        if (variants != null) {
                            for (String var : variants) {
                                doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)var);
                                doc.addField(searchFilter.getIndexFieldName() + "_acid", (Object)(var.toLowerCase() + separator + var + "###" + authority));
                            }
                        }
                        doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)(value.toLowerCase() + separator + value));
                        if (preferedLabel != null) {
                            doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)(preferedLabel.toLowerCase() + separator + preferedLabel));
                        }
                        if (variants != null) {
                            for (String var : variants) {
                                doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)(var.toLowerCase() + separator + var));
                            }
                        }
                        if (!searchFilter.getFilterType().equals("facet")) continue;
                        if (searchFilter.getType().equals("text")) {
                            if (authority != null) {
                                String facetValue = preferedLabel != null ? preferedLabel : value;
                                doc.addField(searchFilter.getIndexFieldName() + "_filter", (Object)(facetValue.toLowerCase() + separator + facetValue + "###" + authority));
                                continue;
                            }
                            doc.addField(searchFilter.getIndexFieldName() + "_filter", (Object)(value.toLowerCase() + separator + value));
                            continue;
                        }
                        if (searchFilter.getType().equals("date")) {
                            if (date == null) continue;
                            String indexField = searchFilter.getIndexFieldName() + ".year";
                            String yearUTC = DateFormatUtils.formatUTC((Date)date, (String)"yyyy");
                            doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)yearUTC);
                            doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)yearUTC);
                            doc.addField(indexField, (Object)yearUTC);
                            if (yearUTC.startsWith("0")) {
                                doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)yearUTC.replaceFirst("0*", ""));
                                doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)yearUTC.replaceFirst("0*", ""));
                                doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)value.replaceFirst("0*", ""));
                                doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)value.replaceFirst("0*", ""));
                            }
                            if (doc.getField(indexField + "_sort") != null) continue;
                            doc.addField(indexField + "_sort", (Object)yearUTC);
                            continue;
                        }
                        if (!searchFilter.getType().equals("hierarchical")) continue;
                        HierarchicalSidebarFacetConfiguration hierarchicalSidebarFacetConfiguration = (HierarchicalSidebarFacetConfiguration)searchFilter;
                        Object[] subValues = value.split(hierarchicalSidebarFacetConfiguration.getSplitter());
                        if (hierarchicalSidebarFacetConfiguration.isSkipFirstNodeLevel() && 1 < subValues.length) {
                            subValues = (String[])ArrayUtils.subarray((Object[])subValues, (int)1, (int)subValues.length);
                        }
                        for (int i = 0; i < subValues.length; ++i) {
                            StringBuilder valueBuilder = new StringBuilder();
                            for (int j = 0; j <= i; ++j) {
                                valueBuilder.append((String)subValues[j]);
                                if (j >= i) continue;
                                valueBuilder.append(hierarchicalSidebarFacetConfiguration.getSplitter());
                            }
                            String indexValue = valueBuilder.toString().trim();
                            doc.addField(searchFilter.getIndexFieldName() + "_tax_" + i + "_filter", (Object)(indexValue.toLowerCase() + separator + indexValue));
                            for (int j = i; j < subValues.length; ++j) {
                                doc.addField(searchFilter.getIndexFieldName() + "_filter", (Object)(indexValue.toLowerCase() + separator + indexValue));
                                doc.addField(searchFilter.getIndexFieldName() + "_keyword", (Object)indexValue);
                            }
                        }
                    }
                }
                if (!(sortFields.get(field) == null && recentSubmissionsConfigurationMap.get(field) == null || sortFieldsAdded.contains(field))) {
                    String type = sortFields.get(field) != null ? ((DiscoverySortFieldConfiguration)sortFields.get(field)).getType() : ((DiscoveryRecentSubmissionsConfiguration)recentSubmissionsConfigurationMap.get(field)).getType();
                    if (type.equals("date")) {
                        Date date = MultiFormatDateParser.parse(value);
                        if (date != null) {
                            doc.addField(field + "_dt", (Object)date);
                        } else {
                            log.warn("Error while indexing sort date field, item: " + item.getHandle() + " metadata field: " + field + " date value: " + date);
                        }
                    } else {
                        doc.addField(field + "_sort", (Object)value);
                    }
                    sortFieldsAdded.add(field);
                }
                if (hitHighlightingFields.contains(field) || hitHighlightingFields.contains("*") || hitHighlightingFields.contains(unqualifiedField + "." + "*")) {
                    if (authority != null) {
                        doc.addField(field + "_hl", (Object)(value + "###" + authority));
                    } else {
                        doc.addField(field + "_hl", (Object)value);
                    }
                }
                if (moreLikeThisFields.contains(field) || moreLikeThisFields.contains(unqualifiedField + "." + "*")) {
                    doc.addField(field + "_mlt", (Object)value);
                }
                doc.addField(field, (Object)value);
                if (authority != null) {
                    doc.addField(field + "_authority", (Object)authority);
                }
                if (toProjectionFields.contains(field) || toProjectionFields.contains(unqualifiedField + "." + "*")) {
                    StringBuffer variantsToStore = new StringBuffer();
                    if (variants != null) {
                        for (String var : variants) {
                            variantsToStore.append("###");
                            variantsToStore.append(var);
                        }
                    }
                    doc.addField(field + "_stored", (Object)(value + "\n|||\n" + preferedLabel + "\n|||\n" + (variantsToStore.length() > "###".length() ? variantsToStore.substring("###".length()) : "null") + "\n|||\n" + authority + "\n|||\n" + meta.getLanguage()));
                }
                if (meta.getLanguage() == null || meta.getLanguage().trim().equals("")) continue;
                String langField = field + "." + meta.getLanguage();
                doc.addField(langField, (Object)value);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.debug("  Added Metadata");
        try {
            List<MetadataValue> values = this.itemService.getMetadataByMetadataString(item, "dc.relation.ispartof");
            if (values != null && values.size() > 0 && values.get(0) != null && values.get(0).getValue() != null) {
                String handlePrefix = this.handleService.getCanonicalPrefix();
                doc.addField("publication_grp", (Object)values.get(0).getValue().replaceFirst(handlePrefix, ""));
            } else {
                doc.addField("publication_grp", (Object)item.getHandle());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.debug("  Added Grouping");
        List solrServiceIndexPlugins = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrServiceIndexPlugin.class);
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : solrServiceIndexPlugins) {
            solrServiceIndexPlugin.additionalIndex(context, item, doc);
        }
    }

    private void deleteInProgressSubmissionByItemID(String uniqueID) throws SolrServerException, IOException {
        String query = "inprogress.item:\"" + uniqueID + "\"";
        log.debug("Try to delete all in progress submission [DELETEBYQUERY]:" + query);
        this.getSolr().deleteByQuery(query);
    }

    private void addFacetIndex(SolrInputDocument document, String field, String authority, String fvalue) {
        this.addFacetIndex(document, field, fvalue, authority, fvalue);
    }

    private void addFacetIndex(SolrInputDocument document, String field, String sortValue, String authority, String fvalue) {
        String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
        if (separator == null) {
            separator = "\n|||\n";
        }
        String acvalue = sortValue + separator + fvalue + "###" + authority;
        document.addField(field + "_filter", (Object)acvalue);
        document.addField(field + "_keyword", (Object)fvalue);
        document.addField(field + "_ac", (Object)(fvalue.toLowerCase() + separator + fvalue));
        if (StringUtils.isNotBlank((CharSequence)authority)) {
            document.addField(field + "_acid", (Object)(fvalue.toLowerCase() + separator + fvalue + "###" + authority));
            document.addField(field + "_authority", (Object)authority);
        }
    }

    private void indexInProgressSubmissionItem(Context context, Item item) throws SQLException, IOException, SolrServerException, WorkflowConfigurationException {
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.workflowItemService.findByItem(context, item);
        if (workflowItem == null) {
            WorkspaceItem workspaceItem = this.workspaceItemService.findByItem(context, item);
            if (workspaceItem == null) {
                return;
            }
            List<String> locations = this.getCollectionLocations(context, workspaceItem.getCollection());
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.addField("lastModified", (Object)item.getLastModified());
            EPerson submitter = workspaceItem.getSubmitter();
            if (submitter != null) {
                this.addFacetIndex(doc, "submitter", submitter.getID().toString(), submitter.getFullName());
            }
            List<DiscoveryConfiguration> discoveryConfigurations = SearchUtils.getAllDiscoveryConfigurations(workspaceItem);
            this.addDiscoveryFields(doc, context, item, discoveryConfigurations);
            this.addBasicInfoToDocument(doc, 8, workspaceItem.getID(), null, locations);
            String acvalue = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.facet.namedtype.workspace");
            if (StringUtils.isBlank((CharSequence)acvalue)) {
                acvalue = workspaceItem.getTypeText();
            }
            this.addNamedResourceTypeIndex(doc, acvalue);
            doc.addField("inprogress.item", (Object)item.getUniqueIndexID());
            this.getSolr().add(doc);
        } else {
            String acvalue;
            String acvalue2;
            SolrInputDocument claimDoc;
            List<String> locations = this.getCollectionLocations(context, workflowItem.getCollection());
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.addField("inprogress.item", (Object)item.getUniqueIndexID());
            doc.addField("lastModified", (Object)item.getLastModified());
            EPerson submitter = workflowItem.getSubmitter();
            if (submitter != null) {
                this.addFacetIndex(doc, "submitter", submitter.getID().toString(), submitter.getFullName());
            }
            List<DiscoveryConfiguration> discoveryConfigurations = SearchUtils.getAllDiscoveryConfigurations(workflowItem);
            this.addDiscoveryFields(doc, context, item, discoveryConfigurations);
            List<ClaimedTask> claimedTasks = this.claimedTaskService.find(context, workflowItem);
            List<PoolTask> pools = this.poolTaskService.find(context, workflowItem);
            ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
            if (claimedTasks != null) {
                for (ClaimedTask claimedTask : claimedTasks) {
                    claimDoc = doc.deepCopy();
                    this.addBasicInfoToDocument(claimDoc, 11, claimedTask.getID(), null, locations);
                    this.addFacetIndex(claimDoc, "action", claimedTask.getActionID(), claimedTask.getActionID());
                    this.addFacetIndex(claimDoc, "step", claimedTask.getStepID(), claimedTask.getStepID());
                    claimDoc.addField("taskfor", (Object)("e" + claimedTask.getOwner().getID().toString()));
                    acvalue2 = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.facet.namedtype.workflow.claimed");
                    if (StringUtils.isBlank((CharSequence)acvalue2)) {
                        acvalue2 = claimedTask.getTypeText();
                    }
                    this.addNamedResourceTypeIndex(claimDoc, acvalue2);
                    docs.add(claimDoc);
                }
            }
            if (pools != null) {
                for (PoolTask poolTask : pools) {
                    claimDoc = doc.deepCopy();
                    this.addBasicInfoToDocument(claimDoc, 10, poolTask.getID(), null, locations);
                    this.addFacetIndex(claimDoc, "action", poolTask.getActionID(), poolTask.getActionID());
                    this.addFacetIndex(claimDoc, "step", poolTask.getStepID(), poolTask.getStepID());
                    if (poolTask.getEperson() != null) {
                        claimDoc.addField("taskfor", (Object)("e" + poolTask.getEperson().getID().toString()));
                    }
                    if (poolTask.getGroup() != null) {
                        claimDoc.addField("taskfor", (Object)("g" + poolTask.getGroup().getID().toString()));
                    }
                    if (StringUtils.isBlank((CharSequence)(acvalue2 = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.facet.namedtype.workflow.pooled")))) {
                        acvalue2 = poolTask.getTypeText();
                    }
                    this.addNamedResourceTypeIndex(claimDoc, acvalue2);
                    docs.add(claimDoc);
                }
            }
            if (StringUtils.isBlank((CharSequence)(acvalue = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.facet.namedtype.workflow.item")))) {
                acvalue = workflowItem.getTypeText();
            }
            this.addNamedResourceTypeIndex(doc, acvalue);
            this.addBasicInfoToDocument(doc, 9, workflowItem.getID(), null, locations);
            docs.add(doc);
            if (docs.size() > 0) {
                this.getSolr().add(docs);
            } else {
                log.error("No tasks found for workflowitem " + workflowItem.getID());
            }
        }
    }

    protected SolrInputDocument buildDocument(int type, UUID id, String handle, List<String> locations) {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        this.addBasicInfoToDocument(doc, type, id, handle, locations);
        return doc;
    }

    private void addBasicInfoToDocument(SolrInputDocument doc, int type, Serializable id, String handle, List<String> locations) {
        doc.addField(LAST_INDEXED_FIELD, (Object)new Date());
        doc.addField(RESOURCE_UNIQUE_ID, (Object)(type + "-" + id));
        doc.addField(RESOURCE_TYPE_FIELD, (Object)Integer.toString(type));
        doc.addField(RESOURCE_ID_FIELD, (Object)id.toString());
        if (handle != null) {
            doc.addField(HANDLE_FIELD, (Object)handle);
        }
        if (locations != null) {
            for (String location : locations) {
                doc.addField("location", (Object)location);
                if (location.startsWith("m")) {
                    doc.addField("location.comm", (Object)location.substring(1));
                    continue;
                }
                doc.addField("location.coll", (Object)location.substring(1));
            }
        }
    }

    public Date toDate(String t) {
        SimpleDateFormat[] dfArr;
        switch (t.length()) {
            case 1: {
                t = "0" + t;
            }
            case 2: {
                t = "0" + t;
            }
            case 3: {
                t = "0" + t;
            }
            case 4: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy")};
                break;
            }
            case 6: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMM")};
                break;
            }
            case 7: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM")};
                break;
            }
            case 8: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy MMM")};
                break;
            }
            case 10: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd")};
                break;
            }
            case 11: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy MMM dd")};
                break;
            }
            case 20: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")};
                break;
            }
            default: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")};
            }
        }
        for (SimpleDateFormat df : dfArr) {
            try {
                df.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                df.setLenient(false);
                return df.parse(t);
            }
            catch (ParseException pe) {
                log.error("Unable to parse date format", (Throwable)pe);
            }
        }
        return null;
    }

    public String locationToName(Context context, String field, String value) throws SQLException {
        if ("location.comm".equals(field) || "location.coll".equals(field)) {
            int type = "location.comm".equals(field) ? 4 : 3;
            DSpaceObject commColl = null;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                commColl = this.contentServiceFactory.getDSpaceObjectService(type).find(context, UUID.fromString(value));
            }
            if (commColl != null) {
                return commColl.getName();
            }
        }
        return value;
    }

    @Override
    public DiscoverResult search(Context context, DiscoverQuery query) throws SearchServiceException {
        return this.search(context, query, false);
    }

    @Override
    public DiscoverResult search(Context context, IndexableObject dso, DiscoverQuery query) throws SearchServiceException {
        return this.search(context, dso, query, false);
    }

    @Override
    public DiscoverResult search(Context context, IndexableObject dso, DiscoverQuery discoveryQuery, boolean includeUnDiscoverable) throws SearchServiceException {
        if (dso != null) {
            if (dso instanceof Community) {
                discoveryQuery.addFilterQueries("location:m" + dso.getID());
            } else if (dso instanceof org.dspace.content.Collection) {
                discoveryQuery.addFilterQueries("location:l" + dso.getID());
            } else if (dso instanceof Item) {
                discoveryQuery.addFilterQueries("handle:" + ((Item)dso).getHandle());
            }
        }
        return this.search(context, discoveryQuery, includeUnDiscoverable);
    }

    @Override
    public DiscoverResult search(Context context, DiscoverQuery discoveryQuery, boolean includeUnDiscoverable) throws SearchServiceException {
        try {
            if (this.getSolr() == null) {
                return new DiscoverResult();
            }
            SolrQuery solrQuery = this.resolveToSolrQuery(context, discoveryQuery, includeUnDiscoverable);
            QueryResponse queryResponse = this.getSolr().query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            return this.retrieveResult(context, discoveryQuery, queryResponse);
        }
        catch (Exception e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
    }

    protected SolrQuery resolveToSolrQuery(Context context, DiscoverQuery discoveryQuery, boolean includeUnDiscoverable) throws SearchServiceException {
        int i;
        SolrQuery solrQuery = new SolrQuery();
        String query = "*:*";
        if (discoveryQuery.getQuery() != null) {
            query = discoveryQuery.getQuery();
        }
        solrQuery.setQuery(query);
        for (String string : discoveryQuery.getSearchFields()) {
            solrQuery.addField(string);
        }
        solrQuery.addField(HANDLE_FIELD);
        solrQuery.addField(RESOURCE_TYPE_FIELD);
        solrQuery.addField(RESOURCE_ID_FIELD);
        if (discoveryQuery.isSpellCheck()) {
            solrQuery.setParam("spellcheck.q", new String[]{query});
            solrQuery.setParam("spellcheck.collate", Boolean.TRUE.booleanValue());
            solrQuery.setParam("spellcheck", Boolean.TRUE.booleanValue());
        }
        if (!includeUnDiscoverable) {
            solrQuery.addFilterQuery(new String[]{"NOT(withdrawn:true)"});
            solrQuery.addFilterQuery(new String[]{"NOT(discoverable:false)"});
        }
        for (i = 0; i < discoveryQuery.getFilterQueries().size(); ++i) {
            String string = discoveryQuery.getFilterQueries().get(i);
            solrQuery.addFilterQuery(new String[]{string});
        }
        if (discoveryQuery.getDSpaceObjectFilter() != -1) {
            solrQuery.addFilterQuery(new String[]{"search.resourcetype:" + discoveryQuery.getDSpaceObjectFilter()});
        }
        for (i = 0; i < discoveryQuery.getFieldPresentQueries().size(); ++i) {
            String string = discoveryQuery.getFieldPresentQueries().get(i);
            solrQuery.addFilterQuery(new String[]{string + ":[* TO *]"});
        }
        if (discoveryQuery.getStart() != -1) {
            solrQuery.setStart(Integer.valueOf(discoveryQuery.getStart()));
        }
        if (discoveryQuery.getMaxResults() != -1) {
            solrQuery.setRows(Integer.valueOf(discoveryQuery.getMaxResults()));
        }
        if (discoveryQuery.getSortField() != null) {
            SolrQuery.ORDER order = SolrQuery.ORDER.asc;
            if (discoveryQuery.getSortOrder().equals((Object)DiscoverQuery.SORT_ORDER.desc)) {
                order = SolrQuery.ORDER.desc;
            }
            solrQuery.addSort(discoveryQuery.getSortField(), order);
        }
        for (String string : discoveryQuery.getProperties().keySet()) {
            List<String> list = discoveryQuery.getProperties().get(string);
            solrQuery.add(string, list.toArray(new String[list.size()]));
        }
        List<DiscoverFacetField> facetFields = discoveryQuery.getFacetFields();
        if (0 < facetFields.size()) {
            for (DiscoverFacetField discoverFacetField : facetFields) {
                String field = this.transformFacetField(discoverFacetField, discoverFacetField.getField(), false);
                solrQuery.addFacetField(new String[]{field});
                solrQuery.add("f." + field + "." + "facet.limit", new String[]{String.valueOf(discoverFacetField.getLimit())});
                String facetSort = DiscoveryConfigurationParameters.SORT.COUNT.equals((Object)discoverFacetField.getSortOrder()) ? "count" : "index";
                solrQuery.add("f." + field + "." + "facet.sort", new String[]{facetSort});
                if (discoverFacetField.getOffset() != -1) {
                    solrQuery.setParam("f." + field + "." + "facet.offset", new String[]{String.valueOf(discoverFacetField.getOffset())});
                }
                if (discoverFacetField.getPrefix() == null) continue;
                solrQuery.setFacetPrefix(field, discoverFacetField.getPrefix());
            }
        }
        List<String> list = discoveryQuery.getFacetQueries();
        for (String facetQuery : list) {
            solrQuery.addFacetQuery(facetQuery);
        }
        if (discoveryQuery.getFacetMinCount() != -1) {
            solrQuery.setFacetMinCount(discoveryQuery.getFacetMinCount());
        }
        if (CollectionUtils.isNotEmpty(facetFields) || CollectionUtils.isNotEmpty(list)) {
            solrQuery.setParam("facet.offset", new String[]{String.valueOf(discoveryQuery.getFacetOffset())});
        }
        if (0 < discoveryQuery.getHitHighlightingFields().size()) {
            solrQuery.setHighlight(true);
            solrQuery.add("hl.usePhraseHighlighter", new String[]{Boolean.TRUE.toString()});
            for (DiscoverHitHighlightingField highlightingField : discoveryQuery.getHitHighlightingFields()) {
                solrQuery.addHighlightField(highlightingField.getField() + "_hl");
                solrQuery.add("f." + highlightingField.getField() + "_hl." + "hl.fragsize", new String[]{String.valueOf(highlightingField.getMaxChars())});
                solrQuery.add("f." + highlightingField.getField() + "_hl." + "hl.snippets", new String[]{String.valueOf(highlightingField.getMaxSnippets())});
            }
        }
        boolean bl = StringUtils.startsWith((CharSequence)discoveryQuery.getDiscoveryConfigurationName(), (CharSequence)DISCOVER_WORKSPACE_CONFIGURATION_NAME);
        boolean isWorkflow = StringUtils.startsWith((CharSequence)discoveryQuery.getDiscoveryConfigurationName(), (CharSequence)DISCOVER_WORKFLOW_CONFIGURATION_NAME);
        EPerson currentUser = context.getCurrentUser();
        if (currentUser == null && (isWorkflow || bl)) {
            throw new IllegalStateException("An anonymous user cannot perform a workspace or workflow search");
        }
        if (bl) {
            solrQuery.addFilterQuery(new String[]{"submitter_authority:(" + currentUser.getID() + ")"});
        } else if (isWorkflow) {
            Set<Group> groups;
            try {
                groups = this.groupService.allMemberGroupsSet(context, currentUser);
            }
            catch (SQLException e) {
                throw new SearchServiceException(e.getMessage(), e);
            }
            StringBuilder controllerQuery = new StringBuilder();
            controllerQuery.append("taskfor:(e" + currentUser.getID());
            for (Group group : groups) {
                controllerQuery.append(" OR g").append(group.getID());
            }
            controllerQuery.append(")");
            solrQuery.addFilterQuery(new String[]{controllerQuery.toString()});
        }
        List solrServiceSearchPlugins = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrServiceSearchPlugin.class);
        for (SolrServiceSearchPlugin searchPlugin : solrServiceSearchPlugins) {
            searchPlugin.additionalSearchParameters(context, discoveryQuery, solrQuery);
        }
        return solrQuery;
    }

    protected DiscoverResult retrieveResult(Context context, DiscoverQuery query, QueryResponse solrQueryResponse) throws SQLException {
        DiscoverResult result = new DiscoverResult();
        if (solrQueryResponse != null) {
            String recommendedQuery;
            result.setSearchTime(solrQueryResponse.getQTime());
            result.setStart(query.getStart());
            result.setMaxResults(query.getMaxResults());
            result.setTotalSearchResults(solrQueryResponse.getResults().getNumFound());
            List<String> searchFields = query.getSearchFields();
            for (SolrDocument doc : solrQueryResponse.getResults()) {
                Map highlightedFields;
                IndexableObject dso = this.findIndexableObject(context, doc);
                if (dso == null) {
                    log.error(org.dspace.core.LogManager.getHeader(context, "Error while retrieving DSpace object from discovery index", "Handle: " + doc.getFirstValue(HANDLE_FIELD)));
                    continue;
                }
                result.addIndexableObject(dso);
                DiscoverResult.SearchDocument resultDoc = new DiscoverResult.SearchDocument();
                for (String field : searchFields) {
                    ArrayList<String> valuesAsString = new ArrayList<String>();
                    for (Object o : doc.getFieldValues(field)) {
                        valuesAsString.add(String.valueOf(o));
                    }
                    resultDoc.addSearchField(field, valuesAsString.toArray(new String[valuesAsString.size()]));
                }
                result.addSearchDocument(dso, resultDoc);
                if (solrQueryResponse.getHighlighting() == null || !MapUtils.isNotEmpty((Map)(highlightedFields = (Map)solrQueryResponse.getHighlighting().get(dso.getType() + "-" + dso.getID())))) continue;
                HashMap resultMap = new HashMap();
                for (String key : highlightedFields.keySet()) {
                    List highlightOriginalValue = (List)highlightedFields.get(key);
                    ArrayList<String[]> resultHighlightOriginalValue = new ArrayList<String[]>();
                    for (String highlightValue : highlightOriginalValue) {
                        String[] splitted = highlightValue.split("###");
                        resultHighlightOriginalValue.add(splitted);
                    }
                    resultMap.put(key.substring(0, key.lastIndexOf("_hl")), (List)highlightedFields.get(key));
                }
                result.addHighlightedResult(dso, new DiscoverResult.IndexableObjectHighlightResult(dso, resultMap));
            }
            List facetFields = solrQueryResponse.getFacetFields();
            if (facetFields != null) {
                for (int i = 0; i < facetFields.size(); ++i) {
                    FacetField facetField = (FacetField)facetFields.get(i);
                    DiscoverFacetField facetFieldConfig = query.getFacetFields().get(i);
                    List facetValues = facetField.getValues();
                    if (facetValues == null) continue;
                    if (facetFieldConfig.getType().equals("date") && facetFieldConfig.getSortOrder().equals((Object)DiscoveryConfigurationParameters.SORT.VALUE)) {
                        Collections.reverse(facetValues);
                    }
                    for (FacetField.Count facetValue : facetValues) {
                        String displayedValue = this.transformDisplayedValue(context, facetField.getName(), facetValue.getName());
                        String field = this.transformFacetField(facetFieldConfig, facetField.getName(), true);
                        String authorityValue = this.transformAuthorityValue(context, facetField.getName(), facetValue.getName());
                        String sortValue = this.transformSortValue(context, facetField.getName(), facetValue.getName());
                        String filterValue = displayedValue;
                        if (StringUtils.isNotBlank((CharSequence)authorityValue)) {
                            filterValue = authorityValue;
                        }
                        result.addFacetResult(field, new DiscoverResult.FacetResult(filterValue, displayedValue, authorityValue, sortValue, facetValue.getCount(), facetFieldConfig.getType()));
                    }
                }
            }
            if (solrQueryResponse.getFacetQuery() != null) {
                LinkedHashMap sortedFacetQueries = new LinkedHashMap(solrQueryResponse.getFacetQuery());
                for (String facetQuery : sortedFacetQueries.keySet()) {
                    Integer count;
                    String facetField = facetQuery.substring(0, facetQuery.indexOf(":"));
                    String name = "";
                    String filter = "";
                    if (facetQuery.indexOf(91) > -1 && facetQuery.lastIndexOf(93) > -1) {
                        name = facetQuery.substring(facetQuery.indexOf(91) + 1);
                        name = name.substring(0, name.lastIndexOf(93)).replaceAll("TO", "-");
                        filter = facetQuery.substring(facetQuery.indexOf(91));
                        filter = filter.substring(0, filter.lastIndexOf(93) + 1);
                    }
                    if (0 >= (count = (Integer)sortedFacetQueries.get(facetQuery))) continue;
                    result.addFacetResult(facetField, new DiscoverResult.FacetResult(filter, name, null, name, count.intValue(), "date"));
                }
            }
            if (solrQueryResponse.getSpellCheckResponse() != null && StringUtils.isNotBlank((CharSequence)(recommendedQuery = solrQueryResponse.getSpellCheckResponse().getCollatedResult()))) {
                result.setSpellCheckQuery(recommendedQuery);
            }
        }
        return result;
    }

    protected IndexableObject findIndexableObject(Context context, SolrDocument doc) throws SQLException {
        Integer type = (Integer)doc.getFirstValue(RESOURCE_TYPE_FIELD);
        Object id = doc.getFirstValue(RESOURCE_ID_FIELD);
        String handle = (String)doc.getFirstValue(HANDLE_FIELD);
        IndexableObject o = null;
        Comparable<UUID> uid = null;
        if (type != null && id != null) {
            switch (type) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    uid = Integer.parseInt((String)id);
                    break;
                }
                default: {
                    uid = UUID.fromString((String)id);
                }
            }
        }
        if (uid != null) {
            o = (IndexableObject)this.contentServiceFactory.getIndexableObjectService(type).findIndexableObject(context, (UUID)uid);
        }
        if (o == null) {
            log.warn("Not able to retrieve object RESOURCE_ID:" + id + " - RESOURCE_TYPE_ID:" + type + " - HANDLE:" + handle);
        }
        return o;
    }

    public List<IndexableObject> search(Context context, String query, int offset, int max, String ... filterquery) {
        return this.search(context, query, null, true, offset, max, filterquery);
    }

    @Override
    public List<IndexableObject> search(Context context, String query, String orderfield, boolean ascending, int offset, int max, String ... filterquery) {
        try {
            if (this.getSolr() == null) {
                return Collections.emptyList();
            }
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(query);
            solrQuery.setFields(new String[]{RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD});
            solrQuery.setStart(Integer.valueOf(offset));
            solrQuery.setRows(Integer.valueOf(max));
            if (orderfield != null) {
                solrQuery.addSort(orderfield, ascending ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            }
            if (filterquery != null) {
                solrQuery.addFilterQuery(filterquery);
            }
            QueryResponse rsp = this.getSolr().query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            SolrDocumentList docs = rsp.getResults();
            Iterator iter = docs.iterator();
            ArrayList<IndexableObject> result = new ArrayList<IndexableObject>();
            while (iter.hasNext()) {
                SolrDocument doc = (SolrDocument)iter.next();
                Object o = this.contentServiceFactory.getIndexableObjectService((Integer)doc.getFirstValue(RESOURCE_TYPE_FIELD)).findIndexableObject(context, UUID.fromString((String)doc.getFirstValue(RESOURCE_ID_FIELD)));
                if (o == null) continue;
                result.add((IndexableObject)o);
            }
            return result;
        }
        catch (Exception e) {
            log.error(org.dspace.core.LogManager.getHeader(context, "Error while quering solr", "Query: " + query), (Throwable)e);
            return new ArrayList<IndexableObject>(0);
        }
    }

    @Override
    public DiscoverFilterQuery toFilterQuery(Context context, String field, String operator, String value) throws SQLException {
        DiscoverFilterQuery result = new DiscoverFilterQuery();
        StringBuilder filterQuery = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)field) && StringUtils.isNotBlank((CharSequence)value)) {
            filterQuery.append(field);
            if (operator.endsWith("equals")) {
                filterQuery.append("_keyword");
            } else if (operator.endsWith("authority")) {
                filterQuery.append("_authority");
            }
            if (operator.startsWith("not")) {
                filterQuery.insert(0, "-");
            }
            filterQuery.append(":");
            if ("equals".equals(operator) || "notequals".equals(operator)) {
                if (!value.matches("\\[.*TO.*\\]")) {
                    value = ClientUtils.escapeQueryChars((String)value);
                    filterQuery.append(value);
                } else {
                    if (value.matches("\\[\\d{1,4} TO \\d{1,4}\\]")) {
                        int minRange = Integer.parseInt(value.substring(1, value.length() - 1).split(" TO ")[0]);
                        int maxRange = Integer.parseInt(value.substring(1, value.length() - 1).split(" TO ")[1]);
                        value = "[" + String.format("%04d", minRange) + " TO " + String.format("%04d", maxRange) + "]";
                    }
                    filterQuery.append(value);
                }
            } else if (!value.matches("\\[.*TO.*\\]")) {
                value = ClientUtils.escapeQueryChars((String)value);
                filterQuery.append("(").append(value).append(")");
            } else {
                filterQuery.append(value);
            }
            result.setDisplayedValue(this.transformDisplayedValue(context, field, value));
        }
        result.setFilterQuery(filterQuery.toString());
        return result;
    }

    @Override
    public List<Item> getRelatedItems(Context context, Item item, DiscoveryMoreLikeThisConfiguration mltConfig) {
        ArrayList<Item> results = new ArrayList<Item>();
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery("handle: " + item.getHandle());
            solrQuery.setFields(new String[]{HANDLE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD});
            solrQuery.setParam("mlt", true);
            Collection similarityMetadataFields = CollectionUtils.collect(mltConfig.getSimilarityMetadataFields(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return input + "_mlt";
                }
            });
            solrQuery.setParam("mlt.fl", new String[]{StringUtils.join((Iterable)similarityMetadataFields, (char)',')});
            solrQuery.setParam("mlt.mintf", new String[]{String.valueOf(mltConfig.getMinTermFrequency())});
            solrQuery.setParam("mlt.count", new String[]{String.valueOf(mltConfig.getMax())});
            solrQuery.setParam("mlt.minwl", new String[]{String.valueOf(mltConfig.getMinWordLength())});
            if (this.getSolr() == null) {
                return Collections.emptyList();
            }
            QueryResponse rsp = this.getSolr().query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            NamedList mltResults = (NamedList)rsp.getResponse().get("moreLikeThis");
            if (mltResults != null && mltResults.get(item.getType() + "-" + item.getID()) != null) {
                SolrDocumentList relatedDocs = (SolrDocumentList)mltResults.get(item.getType() + "-" + item.getID());
                for (Object relatedDoc : relatedDocs) {
                    SolrDocument relatedDocument = (SolrDocument)relatedDoc;
                    IndexableObject relatedItem = this.findIndexableObject(context, relatedDocument);
                    if (relatedItem.getType() != 2) continue;
                    results.add((Item)relatedItem);
                }
            }
        }
        catch (Exception e) {
            log.error(org.dspace.core.LogManager.getHeader(context, "Error while retrieving related items", "Handle: " + item.getHandle()), (Throwable)e);
        }
        return results;
    }

    @Override
    public String toSortFieldIndex(String metadataField, String type) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"score", (CharSequence)metadataField)) {
            return "score";
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"date")) {
            return metadataField + "_dt";
        }
        return metadataField + "_sort";
    }

    protected String transformFacetField(DiscoverFacetField facetFieldConfig, String field, boolean removePostfix) {
        if (facetFieldConfig.getType().equals("text")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_filter"));
            }
            return field + "_filter";
        }
        if (facetFieldConfig.getType().equals("date")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf(".year"));
            }
            return field + ".year";
        }
        if (facetFieldConfig.getType().equals("ac")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_ac"));
            }
            return field + "_ac";
        }
        if (facetFieldConfig.getType().equals("hierarchical")) {
            if (removePostfix) {
                return StringUtils.substringBeforeLast((String)field, (String)"_tax_");
            }
            return field + "_tax_0_filter";
        }
        if (facetFieldConfig.getType().equals("authority")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_acid"));
            }
            return field + "_acid";
        }
        if (facetFieldConfig.getType().equals("standard")) {
            return field;
        }
        return field;
    }

    protected String transformDisplayedValue(Context context, String field, String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (field.equals("location.comm") || field.equals("location.coll")) {
            value = this.locationToName(context, field, value);
        } else if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid")) {
            int start;
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuffer valueBuffer = new StringBuffer();
            for (int i = start = fqParts.length / 2; i < fqParts.length; ++i) {
                String[] split = fqParts[i].split("###", 2);
                valueBuffer.append(split[0]);
            }
            value = valueBuffer.toString();
        } else if (value.matches("\\((.*?)\\)")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected String transformAuthorityValue(Context context, String field, String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (field.equals("location.comm") || field.equals("location.coll")) {
            return value;
        }
        if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid")) {
            int start;
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuffer authorityBuffer = new StringBuffer();
            for (int i = start = fqParts.length / 2; i < fqParts.length; ++i) {
                String[] split = fqParts[i].split("###", 2);
                if (split.length != 2) continue;
                authorityBuffer.append(split[1]);
            }
            if (authorityBuffer.length() > 0) {
                return authorityBuffer.toString();
            }
        }
        return null;
    }

    protected String transformSortValue(Context context, String field, String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (field.equals("location.comm") || field.equals("location.coll")) {
            value = this.locationToName(context, field, value);
        } else if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid")) {
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuffer valueBuffer = new StringBuffer();
            int end = fqParts.length / 2;
            for (int i = 0; i < end; ++i) {
                valueBuffer.append(fqParts[i]);
            }
            value = valueBuffer.toString();
        } else if (value.matches("\\((.*?)\\)")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    @Override
    public void indexContent(Context context, IndexableObject dso, boolean force, boolean commit) throws SearchServiceException, SQLException {
        this.indexContent(context, dso, force);
        if (commit) {
            this.commit();
        }
    }

    @Override
    public void commit() throws SearchServiceException {
        try {
            if (this.getSolr() != null) {
                this.getSolr().commit();
            }
        }
        catch (Exception e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
    }

    @Override
    public String escapeQueryChars(String query) {
        return ClientUtils.escapeQueryChars((String)query);
    }

    @Override
    public FacetYearRange getFacetYearRange(Context context, IndexableObject scope, DiscoverySearchFilterFacet facet, List<String> filterQueries, DiscoverQuery parentQuery) throws SearchServiceException {
        FacetYearRange result = new FacetYearRange(facet);
        result.calculateRange(context, filterQueries, scope, this, parentQuery);
        return result;
    }

    @Override
    public String calculateExtremeValue(Context context, String valueField, String sortField, DiscoverQuery.SORT_ORDER sortOrder) throws SearchServiceException {
        List<DiscoverResult.SearchDocument> searchDocuments;
        DiscoverQuery maxQuery = new DiscoverQuery();
        maxQuery.setMaxResults(1);
        maxQuery.addFieldPresentQueries(valueField);
        maxQuery.setSortField(sortField, sortOrder);
        maxQuery.addSearchField(valueField);
        DiscoverResult maxResult = this.search(context, maxQuery);
        if (0 < maxResult.getIndexableObjects().size() && 0 < (searchDocuments = maxResult.getSearchDocument(maxResult.getIndexableObjects().get(0))).size() && 0 < searchDocuments.get(0).getSearchFieldValues(valueField).size()) {
            return searchDocuments.get(0).getSearchFieldValues(valueField).get(0);
        }
        return null;
    }

    private void addNamedResourceTypeIndex(SolrInputDocument document, String filterValue) {
        String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
        if (separator == null) {
            separator = "\n|||\n";
        }
        String[] avalues = filterValue.split("###");
        String sortValue = avalues[0];
        String authorityValue = avalues.length == 2 ? avalues[1] : filterValue;
        int idxSeparator = sortValue.indexOf(separator);
        String displayValue = idxSeparator != -1 ? sortValue.substring(idxSeparator + separator.length()) : sortValue;
        this.addFacetIndex(document, NAMED_RESOURCE_TYPE, sortValue, authorityValue, displayValue);
    }
}

