/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.configuration;

import java.util.List;
import org.dspace.discovery.configuration.DiscoveryConfigurationException;
import org.springframework.beans.factory.annotation.Required;

public class DiscoverySearchFilter {
    protected String indexFieldName;
    protected List<String> metadataFields;
    protected String type = "text";
    public static final String FILTER_TYPE_DEFAULT = "default";
    protected boolean isOpenByDefault = false;
    protected int pageSize;

    public String getIndexFieldName() {
        return this.indexFieldName;
    }

    @Required
    public void setIndexFieldName(String indexFieldName) {
        this.indexFieldName = indexFieldName;
    }

    public List<String> getMetadataFields() {
        return this.metadataFields;
    }

    @Required
    public void setMetadataFields(List<String> metadataFields) {
        this.metadataFields = metadataFields;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) throws DiscoveryConfigurationException {
        if (type.equalsIgnoreCase("text")) {
            this.type = "text";
        } else if (type.equalsIgnoreCase("date")) {
            this.type = "date";
        } else {
            if (type.equalsIgnoreCase("hierarchical")) {
                throw new DiscoveryConfigurationException("The " + type + " can't be used with a default side bar facet use the \"HierarchicalSidebarFacetConfiguration\" class instead.");
            }
            this.type = type;
        }
    }

    public String getFilterType() {
        return FILTER_TYPE_DEFAULT;
    }

    public boolean isOpenByDefault() {
        return this.isOpenByDefault;
    }

    public void setIsOpenByDefault(boolean isOpenByDefault) {
        this.isOpenByDefault = isOpenByDefault;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

