/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;

public class DiscoverySortConfiguration {
    public static final String SCORE = "score";
    private DiscoverySortFieldConfiguration defaultSort = null;
    private List<DiscoverySortFieldConfiguration> sortFields = new ArrayList<DiscoverySortFieldConfiguration>();
    private SORT_ORDER defaultSortOrder = SORT_ORDER.desc;

    public DiscoverySortFieldConfiguration getDefaultSort() {
        return this.defaultSort;
    }

    public void setDefaultSort(DiscoverySortFieldConfiguration defaultSort) {
        this.defaultSort = defaultSort;
    }

    public List<DiscoverySortFieldConfiguration> getSortFields() {
        return this.sortFields;
    }

    public void setSortFields(List<DiscoverySortFieldConfiguration> sortFields) {
        this.sortFields = sortFields;
    }

    public SORT_ORDER getDefaultSortOrder() {
        return this.defaultSortOrder;
    }

    public void setDefaultSortOrder(SORT_ORDER defaultSortOrder) {
        this.defaultSortOrder = defaultSortOrder;
    }

    public DiscoverySortFieldConfiguration getSortFieldConfiguration(String sortField) {
        if (StringUtils.isBlank((CharSequence)sortField)) {
            return null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)SCORE, (CharSequence)sortField)) {
            DiscoverySortFieldConfiguration configuration = new DiscoverySortFieldConfiguration();
            configuration.setMetadataField(SCORE);
            return configuration;
        }
        if (this.defaultSort != null && StringUtils.equals((CharSequence)this.defaultSort.getMetadataField(), (CharSequence)sortField)) {
            return this.defaultSort;
        }
        for (DiscoverySortFieldConfiguration sortFieldConfiguration : CollectionUtils.emptyIfNull(this.sortFields)) {
            if (!StringUtils.equals((CharSequence)sortFieldConfiguration.getMetadataField(), (CharSequence)sortField)) continue;
            return sortFieldConfiguration;
        }
        return null;
    }

    public static enum SORT_ORDER {
        desc,
        asc;

    }
}

