/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.RegistrationDataService;
import org.springframework.beans.factory.annotation.Autowired;

public class AccountServiceImpl
implements AccountService {
    private static Logger log = LogManager.getLogger(AccountServiceImpl.class);
    @Autowired(required=true)
    protected EPersonService ePersonService;
    @Autowired(required=true)
    protected RegistrationDataService registrationDataService;

    protected AccountServiceImpl() {
    }

    @Override
    public void sendRegistrationInfo(Context context, String email) throws SQLException, IOException, MessagingException, AuthorizeException {
        this.sendInfo(context, email, true, true);
    }

    @Override
    public void sendForgotPasswordInfo(Context context, String email) throws SQLException, IOException, MessagingException, AuthorizeException {
        this.sendInfo(context, email, false, true);
    }

    @Override
    public EPerson getEPerson(Context context, String token) throws SQLException, AuthorizeException {
        String email = this.getEmail(context, token);
        if (email == null) {
            return null;
        }
        return this.ePersonService.findByEmail(context, email);
    }

    @Override
    public String getEmail(Context context, String token) throws SQLException {
        RegistrationData registrationData = this.registrationDataService.findByToken(context, token);
        if (registrationData == null) {
            return null;
        }
        return registrationData.getEmail();
    }

    @Override
    public void deleteToken(Context context, String token) throws SQLException {
        this.registrationDataService.deleteByToken(context, token);
    }

    protected RegistrationData sendInfo(Context context, String email, boolean isRegister, boolean send) throws SQLException, IOException, MessagingException, AuthorizeException {
        RegistrationData rd = this.registrationDataService.findByEmail(context, email);
        if (rd == null) {
            rd = (RegistrationData)this.registrationDataService.create(context);
            rd.setToken(Utils.generateHexKey());
            rd.setEmail(email);
            this.registrationDataService.update(context, rd);
            if (log.isDebugEnabled()) {
                log.debug("Created callback " + rd.getID() + " with token " + rd.getToken() + " with email \"" + email + "\"");
            }
        }
        if (send) {
            this.sendEmail(context, email, isRegister, rd);
        }
        return rd;
    }

    protected void sendEmail(Context context, String email, boolean isRegister, RegistrationData rd) throws MessagingException, IOException, SQLException {
        String base = ConfigurationManager.getProperty("dspace.url");
        String specialLink = new StringBuffer().append(base).append(base.endsWith("/") ? "" : "/").append(isRegister ? "register" : "forgot").append("?").append("token=").append(rd.getToken()).toString();
        Locale locale = context.getCurrentLocale();
        Email bean = Email.getEmail(I18nUtil.getEmailFilename(locale, isRegister ? "register" : "change_password"));
        bean.addRecipient(email);
        bean.addArgument(specialLink);
        bean.send();
        if (log.isInfoEnabled()) {
            log.info("Sent " + (isRegister ? "registration" : "account") + " information to " + email);
        }
    }
}

