/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.Handle;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HandleIdentifierProvider
extends IdentifierProvider {
    private static Logger log = LogManager.getLogger(HandleIdentifierProvider.class);
    protected static final String EXAMPLE_PREFIX = "123456789";
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected ItemService itemService;

    @Override
    public boolean supports(Class<? extends Identifier> identifier) {
        return Handle.class.isAssignableFrom(identifier);
    }

    @Override
    public boolean supports(String identifier) {
        String[] additionalPrefixes;
        String prefix = this.handleService.getPrefix();
        String canonicalPrefix = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("handle.canonical.prefix");
        if (identifier == null) {
            return false;
        }
        if (identifier.startsWith(prefix + "/") || identifier.startsWith(canonicalPrefix) || identifier.startsWith("hdl:") || identifier.startsWith("info:hdl") || identifier.matches("^https?://hdl\\.handle\\.net/.*") || identifier.matches("^https?://.+/handle/.*")) {
            return true;
        }
        for (String additionalPrefix : additionalPrefixes = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("handle.additional.prefixes")) {
            if (!identifier.startsWith(additionalPrefix + "/")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String register(Context context, DSpaceObject dso) {
        try {
            String id = this.mint(context, dso);
            if (dso instanceof Item) {
                Item item = (Item)dso;
                this.populateHandleMetadata(context, item, id);
            }
            return id;
        }
        catch (Exception e) {
            log.error(org.dspace.core.LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID(), e);
        }
    }

    @Override
    public void register(Context context, DSpaceObject dso, String identifier) {
        try {
            this.handleService.createHandle(context, dso, identifier);
            if (dso instanceof Item) {
                Item item = (Item)dso;
                this.populateHandleMetadata(context, item, identifier);
            }
        }
        catch (Exception e) {
            log.error(org.dspace.core.LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID(), e);
        }
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) {
        try {
            this.handleService.createHandle(context, dso, identifier);
        }
        catch (Exception e) {
            log.error(org.dspace.core.LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public String mint(Context context, DSpaceObject dso) {
        if (dso.getHandle() != null) {
            return dso.getHandle();
        }
        try {
            return this.handleService.createHandle(context, dso);
        }
        catch (Exception e) {
            log.error(org.dspace.core.LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier, String ... attributes) {
        try {
            return this.handleService.resolveToObject(context, identifier);
        }
        catch (Exception e) {
            log.error(org.dspace.core.LogManager.getHeader(context, "Error while resolving handle to item", "handle: " + identifier), (Throwable)e);
            return null;
        }
    }

    @Override
    public String lookup(Context context, DSpaceObject dso) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        try {
            return this.handleService.findHandle(context, dso);
        }
        catch (SQLException sqe) {
            throw new IdentifierNotResolvableException(sqe.getMessage(), sqe);
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        this.delete(context, dso);
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
        try {
            this.handleService.unbindHandle(context, dso);
        }
        catch (SQLException sqe) {
            throw new IdentifierException(sqe.getMessage(), sqe);
        }
    }

    public static String retrieveHandleOutOfUrl(String url) throws SQLException {
        if (!url.contains("/")) {
            return null;
        }
        String[] splitUrl = url.split("/");
        return splitUrl[splitUrl.length - 2] + "/" + splitUrl[splitUrl.length - 1];
    }

    public static String getPrefix() {
        String prefix = ConfigurationManager.getProperty("handle.prefix");
        if (null == prefix) {
            prefix = EXAMPLE_PREFIX;
            log.error("handle.prefix is not configured; using " + prefix);
        }
        return prefix;
    }

    protected void populateHandleMetadata(Context context, Item item, String handle) throws SQLException, IOException, AuthorizeException {
        String handleref = this.handleService.getCanonicalForm(handle);
        boolean identifierExists = false;
        List<MetadataValue> identifiers = this.itemService.getMetadata(item, MetadataSchemaEnum.DC.getName(), "identifier", "uri", "*");
        for (MetadataValue identifier : identifiers) {
            if (!handleref.equals(identifier.getValue())) continue;
            identifierExists = true;
        }
        if (!identifierExists) {
            this.itemService.addMetadata(context, item, MetadataSchemaEnum.DC.getName(), "identifier", "uri", null, handleref);
        }
    }
}

