/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic.dao.impl;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.Item_;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.BasicWorkflowItem_;
import org.dspace.workflowbasic.dao.BasicWorkflowItemDAO;

public class BasicWorkflowItemDAOImpl
extends AbstractHibernateDAO<BasicWorkflowItem>
implements BasicWorkflowItemDAO {
    protected BasicWorkflowItemDAOImpl() {
    }

    @Override
    public BasicWorkflowItem findByItem(Context context, Item i) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<BasicWorkflowItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, BasicWorkflowItem.class);
        Root basicWorkflowItemRoot = criteriaQuery.from(BasicWorkflowItem.class);
        criteriaQuery.select((Selection)basicWorkflowItemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)basicWorkflowItemRoot.get(BasicWorkflowItem_.item), (Object)i));
        return this.uniqueResult(context, criteriaQuery, false, BasicWorkflowItem.class, -1, -1);
    }

    @Override
    public List<BasicWorkflowItem> findBySubmitter(Context context, EPerson ep) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<BasicWorkflowItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, BasicWorkflowItem.class);
        Root basicWorkflowItemRoot = criteriaQuery.from(BasicWorkflowItem.class);
        Join join = basicWorkflowItemRoot.join("item");
        criteriaQuery.select((Selection)basicWorkflowItemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)join.get(Item_.submitter), (Object)ep));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)basicWorkflowItemRoot.get(BasicWorkflowItem_.workflowitemId)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, BasicWorkflowItem.class, -1, -1);
    }

    @Override
    public List<BasicWorkflowItem> findByCollection(Context context, Collection c) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<BasicWorkflowItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, BasicWorkflowItem.class);
        Root basicWorkflowItemRoot = criteriaQuery.from(BasicWorkflowItem.class);
        criteriaQuery.select((Selection)basicWorkflowItemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)basicWorkflowItemRoot.get(BasicWorkflowItem_.collection), (Object)c));
        return this.list(context, criteriaQuery, false, BasicWorkflowItem.class, -1, -1);
    }

    @Override
    public List<BasicWorkflowItem> findByPooledTasks(Context context, EPerson ePerson) throws SQLException {
        String queryString = "select wf from TaskListItem as tli join tli.workflowItem wf where tli.ePerson = :eperson ORDER BY wf.workflowitemId";
        Query query = this.createQuery(context, queryString);
        query.setParameter("eperson", (Object)ePerson);
        return this.list(query);
    }

    @Override
    public List<BasicWorkflowItem> findByOwner(Context context, EPerson ePerson) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<BasicWorkflowItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, BasicWorkflowItem.class);
        Root basicWorkflowItemRoot = criteriaQuery.from(BasicWorkflowItem.class);
        criteriaQuery.select((Selection)basicWorkflowItemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)basicWorkflowItemRoot.get(BasicWorkflowItem_.owner), (Object)ePerson));
        return this.list(context, criteriaQuery, false, BasicWorkflowItem.class, -1, -1);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM BasicWorkflowItem"));
    }
}

