/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.core.Context;
import org.dspace.workflow.WorkflowException;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.UserSelectionActionConfig;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.InProgressUserService;

public class Step {
    protected InProgressUserService inProgressUserService = XmlWorkflowServiceFactory.getInstance().getInProgressUserService();
    protected XmlWorkflowFactory xmlWorkflowFactory = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory();
    private UserSelectionActionConfig userSelectionMethod;
    private HashMap<String, WorkflowActionConfig> actionConfigsMap = new HashMap();
    private List<String> actionConfigsList;
    private Map<Integer, String> outcomes;
    private String id;
    private Role role;
    private Workflow workflow;
    private int requiredUsers;

    public Step(String id, Workflow workflow, Role role, UserSelectionActionConfig userSelectionMethod, List<String> actionConfigsList, Map<Integer, String> outcomes, int requiredUsers) {
        this.outcomes = outcomes;
        this.userSelectionMethod = userSelectionMethod;
        this.role = role;
        this.actionConfigsList = actionConfigsList;
        this.id = id;
        userSelectionMethod.setStep(this);
        this.requiredUsers = requiredUsers;
        this.workflow = workflow;
    }

    public WorkflowActionConfig getActionConfig(String actionID) {
        if (this.actionConfigsMap.get(actionID) != null) {
            return this.actionConfigsMap.get(actionID);
        }
        WorkflowActionConfig action = this.xmlWorkflowFactory.createWorkflowActionConfig(actionID);
        action.setStep(this);
        this.actionConfigsMap.put(actionID, action);
        return action;
    }

    public boolean hasUI() {
        for (String actionConfigId : this.actionConfigsList) {
            WorkflowActionConfig actionConfig = this.getActionConfig(actionConfigId);
            if (!actionConfig.requiresUI()) continue;
            return true;
        }
        return false;
    }

    public String getNextStepID(int outcome) throws WorkflowException, IOException, WorkflowConfigurationException, SQLException {
        return this.outcomes.get(outcome);
    }

    public boolean isValidStep(Context context, XmlWorkflowItem wfi) throws WorkflowConfigurationException, SQLException {
        return this.getUserSelectionMethod() != null && this.getUserSelectionMethod().getProcessingAction() != null && this.getUserSelectionMethod().getProcessingAction().isValidUserSelection(context, wfi, this.hasUI());
    }

    public UserSelectionActionConfig getUserSelectionMethod() {
        return this.userSelectionMethod;
    }

    public WorkflowActionConfig getNextAction(WorkflowActionConfig currentAction) {
        int index = this.actionConfigsList.indexOf(currentAction.getId());
        if (index < this.actionConfigsList.size() - 1) {
            return this.getActionConfig(this.actionConfigsList.get(index + 1));
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public boolean isFinished(Context c, XmlWorkflowItem wfi) throws SQLException {
        return this.inProgressUserService.getNumberOfFinishedUsers(c, wfi) == this.requiredUsers;
    }

    public int getRequiredUsers() {
        return this.requiredUsers;
    }

    public Role getRole() {
        return this.role;
    }
}

