/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.userassignment;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.userassignment.UserSelectionAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class ClaimAction
extends UserSelectionAction {
    @Override
    public void activate(Context context, XmlWorkflowItem wfItem) throws SQLException, IOException, AuthorizeException {
        Step owningStep = this.getParent().getStep();
        RoleMembers allroleMembers = this.getParent().getStep().getRole().getMembers(context, wfItem);
        if (allroleMembers != null && (allroleMembers.getGroups().size() > 0 || allroleMembers.getEPersons().size() > 0)) {
            XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().createPoolTasks(context, wfItem, allroleMembers, owningStep, this.getParent());
            this.alertUsersOnActivation(context, wfItem, allroleMembers);
        } else {
            this.log.info(LogManager.getHeader(context, "warning while activating claim action", "No group or person was found for the following roleid: " + this.getParent().getStep().getRole().getId()));
        }
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        XmlWorkflowServiceFactory.getInstance().getWorkflowRequirementsService().addClaimedUser(c, wfi, step, c.getCurrentUser());
        return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
    }

    @Override
    public void alertUsersOnActivation(Context c, XmlWorkflowItem wfi, RoleMembers roleMembers) throws IOException, SQLException {
        try {
            XmlWorkflowService xmlWorkflowService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService();
            xmlWorkflowService.alertUsersOnTaskActivation(c, wfi, "submit_task", roleMembers.getAllUniqueMembers(c), wfi.getItem().getName(), wfi.getCollection().getName(), wfi.getSubmitter().getFullName(), "New task available.", xmlWorkflowService.getMyDSpaceLink());
        }
        catch (MessagingException e) {
            this.log.info(LogManager.getHeader(c, "error emailing user(s) for claimed task", "step: " + this.getParent().getStep().getId() + " workflowitem: " + wfi.getID()));
        }
    }

    @Override
    public void regenerateTasks(Context c, XmlWorkflowItem wfi, RoleMembers roleMembers) throws SQLException, AuthorizeException, IOException {
        if (roleMembers != null && (roleMembers.getEPersons().size() > 0 || roleMembers.getGroups().size() > 0)) {
            XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().createPoolTasks(c, wfi, roleMembers, this.getParent().getStep(), this.getParent());
            if (ConfigurationManager.getBooleanProperty("workflow", "notify.returned.tasks", true)) {
                this.alertUsersOnActivation(c, wfi, roleMembers);
            }
        } else {
            this.log.info(LogManager.getHeader(c, "warning while activating claim action", "No group or person was found for the following roleid: " + this.getParent().getStep().getId()));
        }
    }

    @Override
    public boolean isFinished(XmlWorkflowItem wfi) {
        return false;
    }

    @Override
    public boolean isValidUserSelection(Context context, XmlWorkflowItem wfi, boolean hasUI) throws WorkflowConfigurationException, SQLException {
        if (hasUI) {
            Step step = this.getParent().getStep();
            Role role = step.getRole();
            if (role != null) {
                RoleMembers roleMembers = role.getMembers(context, wfi);
                ArrayList<EPerson> epersons = roleMembers.getAllUniqueMembers(context);
                return epersons.size() != 0 && step.getRequiredUsers() <= epersons.size();
            }
            throw new WorkflowConfigurationException("The next step is invalid, since it doesn't have a valid role");
        }
        return true;
    }

    @Override
    public boolean usesTaskPool() {
        return true;
    }
}

