/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dspace.content.DSpaceObject;

public class DiscoverResult {
    private long totalSearchResults;
    private int start;
    private List<DSpaceObject> dspaceObjects = new ArrayList<DSpaceObject>();
    private Map<String, List<FacetResult>> facetResults = new LinkedHashMap<String, List<FacetResult>>();
    private Map<String, List<SearchDocument>> searchDocuments = new LinkedHashMap<String, List<SearchDocument>>();
    private int maxResults = -1;

    public void addDSpaceObject(DSpaceObject dso) {
        this.dspaceObjects.add(dso);
    }

    public List<DSpaceObject> getDspaceObjects() {
        return this.dspaceObjects;
    }

    public long getTotalSearchResults() {
        return this.totalSearchResults;
    }

    public void setTotalSearchResults(long totalSearchResults) {
        this.totalSearchResults = totalSearchResults;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void addFacetResult(String facetField, FacetResult ... facetResults) {
        List<FacetResult> facetValues = this.facetResults.get(facetField);
        if (facetValues == null) {
            facetValues = new ArrayList<FacetResult>();
        }
        facetValues.addAll(Arrays.asList(facetResults));
        this.facetResults.put(facetField, facetValues);
    }

    public Map<String, List<FacetResult>> getFacetResults() {
        return this.facetResults;
    }

    public List<FacetResult> getFacetResult(String facet) {
        return this.facetResults.get(facet) == null ? new ArrayList<FacetResult>() : this.facetResults.get(facet);
    }

    public void addSearchDocument(DSpaceObject dso, SearchDocument searchDocument) {
        String dsoString = SearchDocument.getDspaceObjectStringRepresentation(dso);
        List<SearchDocument> docs = this.searchDocuments.get(dsoString);
        if (docs == null) {
            docs = new ArrayList<SearchDocument>();
        }
        docs.add(searchDocument);
        this.searchDocuments.put(dsoString, docs);
    }

    public List<SearchDocument> getSearchDocument(DSpaceObject dso) {
        String dsoString = SearchDocument.getDspaceObjectStringRepresentation(dso);
        List<SearchDocument> result = this.searchDocuments.get(dsoString);
        if (result == null) {
            return new ArrayList<SearchDocument>();
        }
        return result;
    }

    public static final class SearchDocument {
        private Map<String, List<String>> searchFields = new LinkedHashMap<String, List<String>>();

        public void addSearchField(String field, String ... values) {
            List<String> searchFieldValues = this.searchFields.get(field);
            if (searchFieldValues == null) {
                searchFieldValues = new ArrayList<String>();
            }
            searchFieldValues.addAll(Arrays.asList(values));
            this.searchFields.put(field, searchFieldValues);
        }

        public Map<String, List<String>> getSearchFields() {
            return this.searchFields;
        }

        public List<String> getSearchFieldValues(String field) {
            if (this.searchFields.get(field) == null) {
                return new ArrayList<String>();
            }
            return this.searchFields.get(field);
        }

        public static String getDspaceObjectStringRepresentation(DSpaceObject dso) {
            return dso.getType() + ":" + dso.getID();
        }
    }

    public static final class FacetResult {
        private String asFilterQuery;
        private String displayedValue;
        private long count;

        public FacetResult(String asFilterQuery, String displayedValue, long count) {
            this.asFilterQuery = asFilterQuery;
            this.displayedValue = displayedValue;
            this.count = count;
        }

        public String getAsFilterQuery() {
            return this.asFilterQuery;
        }

        public String getDisplayedValue() {
            return this.displayedValue;
        }

        public long getCount() {
            return this.count;
        }
    }
}

