/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverFilterQuery;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.discovery.configuration.DiscoveryRecentSubmissionsConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.discovery.configuration.SidebarFacetConfiguration;
import org.dspace.handle.HandleManager;
import org.dspace.utils.DSpace;
import org.springframework.stereotype.Service;

@Service
public class SolrServiceImpl
implements SearchService,
IndexingService {
    private static final Logger log = Logger.getLogger(SolrServiceImpl.class);
    private static final String LAST_INDEXED_FIELD = "SolrIndexer.lastIndexed";
    public static final String FILTER_SEPARATOR = "|||";
    private CommonsHttpSolrServer solr = null;

    protected CommonsHttpSolrServer getSolr() throws MalformedURLException, SolrServerException {
        if (this.solr == null) {
            String solrService = new DSpace().getConfigurationService().getProperty("discovery.search.server");
            log.debug((Object)("Solr URL: " + solrService));
            this.solr = new CommonsHttpSolrServer(solrService);
            this.solr.setBaseURL(solrService);
            SolrQuery solrQuery = new SolrQuery().setQuery("search.resourcetype:2 AND search.resourceid:1");
            this.solr.query((SolrParams)solrQuery);
        }
        return this.solr;
    }

    public void indexContent(Context context, DSpaceObject dso) throws SQLException {
        this.indexContent(context, dso, false);
    }

    public void indexContent(Context context, DSpaceObject dso, boolean force) throws SQLException {
        String handle = dso.getHandle();
        if (handle == null) {
            handle = HandleManager.findHandle((Context)context, (DSpaceObject)dso);
        }
        try {
            switch (dso.getType()) {
                case 2: {
                    Item item = (Item)dso;
                    if (item.isArchived() && !item.isWithdrawn()) {
                        if (this.requiresIndexing(handle, ((Item)dso).getLastModified()) || force) {
                            this.unIndexContent(context, handle);
                            this.buildDocument(context, (Item)dso);
                        }
                        break;
                    }
                    this.unIndexContent(context, handle);
                    log.info((Object)("Removed Item: " + handle + " from Index"));
                    break;
                }
                case 3: {
                    this.buildDocument((Collection)dso);
                    log.info((Object)("Wrote Collection: " + handle + " to Index"));
                    break;
                }
                case 4: {
                    this.buildDocument((Community)dso);
                    log.info((Object)("Wrote Community: " + handle + " to Index"));
                    break;
                }
                default: {
                    log.error((Object)"Only Items, Collections and Communities can be Indexed");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void unIndexContent(Context context, DSpaceObject dso) throws SQLException, IOException {
        try {
            this.unIndexContent(context, dso.getHandle());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.emailException(exception);
        }
    }

    public void unIndexContent(Context context, String handle) throws IOException, SQLException {
        this.unIndexContent(context, handle, false);
    }

    public void unIndexContent(Context context, String handle, boolean commit) throws SQLException, IOException {
        try {
            this.getSolr().deleteById(handle);
            if (commit) {
                this.getSolr().commit();
            }
        }
        catch (SolrServerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void reIndexContent(Context context, DSpaceObject dso) throws SQLException, IOException {
        try {
            this.indexContent(context, dso);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.emailException(exception);
        }
    }

    public void createIndex(Context c) throws SQLException, IOException {
        this.updateIndex(c, true);
    }

    public void updateIndex(Context context) {
        this.updateIndex(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex(Context context, boolean force) {
        try {
            Community[] communities;
            Collection[] collections;
            ItemIterator items = null;
            try {
                items = Item.findAll((Context)context);
                while (items.hasNext()) {
                    Item item = items.next();
                    this.indexContent(context, (DSpaceObject)item, force);
                    item.decache();
                }
            }
            finally {
                if (items != null) {
                    items.close();
                }
            }
            for (Collection collection : collections = Collection.findAll((Context)context)) {
                this.indexContent(context, (DSpaceObject)collection, force);
                context.removeCached((Object)collection, collection.getID());
            }
            for (Community community : communities = Community.findAll((Context)context)) {
                this.indexContent(context, (DSpaceObject)community, force);
                context.removeCached((Object)community, community.getID());
            }
            this.getSolr().commit();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void cleanIndex(boolean force) throws IOException, SQLException, SearchServiceException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        try {
            if (force) {
                this.getSolr().deleteByQuery("*:*");
            } else {
                SolrQuery query = new SolrQuery();
                query.setQuery("*:*");
                QueryResponse rsp = this.getSolr().query((SolrParams)query);
                SolrDocumentList docs = rsp.getResults();
                for (SolrDocument doc : docs) {
                    String handle = (String)doc.getFieldValue("handle");
                    DSpaceObject o = HandleManager.resolveToObject((Context)context, (String)handle);
                    if (o == null) {
                        log.info((Object)("Deleting: " + handle));
                        this.unIndexContent(context, handle);
                        continue;
                    }
                    context.removeCached((Object)o, o.getID());
                    log.debug((Object)("Keeping: " + handle));
                }
            }
        }
        catch (Exception e) {
            throw new SearchServiceException(e.getMessage(), (Throwable)e);
        }
        finally {
            context.abort();
        }
    }

    public void optimize() {
        try {
            long start = System.currentTimeMillis();
            System.out.println("SOLR Search Optimize -- Process Started:" + start);
            this.getSolr().optimize();
            long finish = System.currentTimeMillis();
            System.out.println("SOLR Search Optimize -- Process Finished:" + finish);
            System.out.println("SOLR Search Optimize -- Total time taken:" + (finish - start) + " (ms).");
        }
        catch (SolrServerException sse) {
            System.err.println(sse.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    private void emailException(Exception exception) {
        try {
            String recipient = ConfigurationManager.getProperty((String)"alert.recipient");
            if (recipient != null) {
                String stackTrace;
                Email email = ConfigurationManager.getEmail((String)I18nUtil.getEmailFilename((Locale)Locale.getDefault(), (String)"internal_error"));
                email.addRecipient(recipient);
                email.addArgument((Object)ConfigurationManager.getProperty((String)"dspace.url"));
                email.addArgument((Object)new Date());
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument((Object)stackTrace);
                email.send();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to send email alert", (Throwable)e);
        }
    }

    private boolean requiresIndexing(String handle, Date lastModified) throws SQLException, IOException, SearchServiceException {
        QueryResponse rsp;
        boolean reindexItem = false;
        boolean inIndex = false;
        SolrQuery query = new SolrQuery();
        query.setQuery("handle:" + handle);
        try {
            rsp = this.getSolr().query((SolrParams)query);
        }
        catch (SolrServerException e) {
            throw new SearchServiceException(e.getMessage(), (Throwable)e);
        }
        for (SolrDocument doc : rsp.getResults()) {
            Date lastIndexed;
            inIndex = true;
            Object value = doc.getFieldValue(LAST_INDEXED_FIELD);
            if (!(value instanceof Date) || !(lastIndexed = (Date)value).before(lastModified)) continue;
            reindexItem = true;
        }
        return reindexItem || !inIndex;
    }

    private List<String> getItemLocations(Item myitem) throws SQLException {
        Vector<String> locations = new Vector<String>();
        Community[] communities = myitem.getCommunities();
        Collection[] collections = myitem.getCollections();
        int i = 0;
        for (i = 0; i < communities.length; ++i) {
            locations.add("m" + communities[i].getID());
        }
        for (i = 0; i < collections.length; ++i) {
            locations.add("l" + collections[i].getID());
        }
        return locations;
    }

    private List<String> getCollectionLocations(Collection target) throws SQLException {
        Community[] communities;
        Vector<String> locations = new Vector<String>();
        for (Community community : communities = target.getCommunities()) {
            locations.add("m" + community.getID());
        }
        return locations;
    }

    private void writeDocument(SolrInputDocument doc) throws IOException {
        try {
            this.getSolr().add(doc);
        }
        catch (SolrServerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void buildDocument(Community community) throws SQLException, IOException {
        SolrInputDocument doc = this.buildDocument(4, community.getID(), community.getHandle(), null);
        String name = community.getMetadata("name");
        if (name != null) {
            doc.addField("name", (Object)name);
        }
        List solrServiceIndexPlugins = new DSpace().getServiceManager().getServicesByType(SolrServiceIndexPlugin.class);
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : solrServiceIndexPlugins) {
            solrServiceIndexPlugin.additionalIndex((DSpaceObject)community, doc);
        }
        this.writeDocument(doc);
    }

    private void buildDocument(Collection collection) throws SQLException, IOException {
        List<String> locations = this.getCollectionLocations(collection);
        SolrInputDocument doc = this.buildDocument(3, collection.getID(), collection.getHandle(), locations);
        String name = collection.getMetadata("name");
        if (name != null) {
            doc.addField("name", (Object)name);
        }
        List solrServiceIndexPlugins = new DSpace().getServiceManager().getServicesByType(SolrServiceIndexPlugin.class);
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : solrServiceIndexPlugins) {
            solrServiceIndexPlugin.additionalIndex((DSpaceObject)collection, doc);
        }
        this.writeDocument(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDocument(Context context, Item item) throws SQLException, IOException {
        String handle = item.getHandle();
        if (handle == null) {
            handle = HandleManager.findHandle((Context)context, (DSpaceObject)item);
        }
        List<String> locations = this.getItemLocations(item);
        SolrInputDocument doc = this.buildDocument(2, item.getID(), handle, locations);
        log.debug((Object)("Building Item: " + handle));
        ArrayList<String> sortFieldsAdded = new ArrayList<String>();
        try {
            DCValue[] mydc;
            List discoveryConfigurations = SearchUtils.getAllDiscoveryConfigurations((Item)item);
            HashMap<String, List<DiscoverySearchFilter>> sidebarFacets = new HashMap<String, List<DiscoverySearchFilter>>();
            HashMap<String, List<DiscoverySearchFilter>> searchFilters = new HashMap<String, List<DiscoverySearchFilter>>();
            HashMap<String, DiscoverySortFieldConfiguration> sortFields = new HashMap<String, DiscoverySortFieldConfiguration>();
            HashMap<String, DiscoveryRecentSubmissionsConfiguration> recentSubmissionsConfigurationMap = new HashMap<String, DiscoveryRecentSubmissionsConfiguration>();
            for (DiscoveryConfiguration discoveryConfiguration : discoveryConfigurations) {
                DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration;
                List resultingList;
                String metadataField;
                for (SidebarFacetConfiguration facet : discoveryConfiguration.getSidebarFacets()) {
                    for (int i = 0; i < facet.getMetadataFields().size(); ++i) {
                        metadataField = (String)facet.getMetadataFields().get(i);
                        resultingList = sidebarFacets.get(metadataField) != null ? (List)sidebarFacets.get(metadataField) : new ArrayList();
                        resultingList.add(facet);
                        sidebarFacets.put(metadataField, resultingList);
                    }
                }
                for (int i = 0; i < discoveryConfiguration.getSearchFilters().size(); ++i) {
                    DiscoverySearchFilter discoverySearchFilter = (DiscoverySearchFilter)discoveryConfiguration.getSearchFilters().get(i);
                    for (int j = 0; j < discoverySearchFilter.getMetadataFields().size(); ++j) {
                        metadataField = (String)discoverySearchFilter.getMetadataFields().get(j);
                        resultingList = searchFilters.get(metadataField) != null ? (List)searchFilters.get(metadataField) : new ArrayList();
                        resultingList.add(discoverySearchFilter);
                        searchFilters.put(metadataField, resultingList);
                    }
                }
                DiscoverySortConfiguration sortConfiguration = discoveryConfiguration.getSearchSortConfiguration();
                if (sortConfiguration != null) {
                    for (DiscoverySortFieldConfiguration discoverySortConfiguration : sortConfiguration.getSortFields()) {
                        sortFields.put(discoverySortConfiguration.getMetadataField(), discoverySortConfiguration);
                    }
                }
                if ((recentSubmissionConfiguration = discoveryConfiguration.getRecentSubmissionConfiguration()) == null) continue;
                recentSubmissionsConfigurationMap.put(recentSubmissionConfiguration.getMetadataSortField(), recentSubmissionConfiguration);
            }
            ArrayList<String> toIgnoreFields = new ArrayList<String>();
            String ignoreFieldsString = new DSpace().getConfigurationService().getProperty("discovery.index.ignore");
            if (ignoreFieldsString != null) {
                if (ignoreFieldsString.indexOf(",") != -1) {
                    for (int i = 0; i < ignoreFieldsString.split(",").length; ++i) {
                        toIgnoreFields.add(ignoreFieldsString.split(",")[i].trim());
                    }
                } else {
                    toIgnoreFields.add(ignoreFieldsString);
                }
            }
            for (DCValue meta : mydc = item.getMetadata("*", "*", "*", "*")) {
                Date date;
                String field;
                String unqualifiedField = field = meta.schema + "." + meta.element;
                String value = meta.value;
                if (value == null) continue;
                if (meta.qualifier != null && !meta.qualifier.trim().equals("")) {
                    field = field + "." + meta.qualifier;
                }
                if (toIgnoreFields.contains(field) || toIgnoreFields.contains(unqualifiedField + "." + "*")) continue;
                if (searchFilters.get(field) != null || searchFilters.get(unqualifiedField + "." + "*") != null) {
                    List searchFilterConfigs = (List)searchFilters.get(field);
                    if (searchFilterConfigs == null) {
                        searchFilterConfigs = (List)searchFilters.get(unqualifiedField + "." + "*");
                    }
                    for (DiscoverySearchFilter searchFilter : searchFilterConfigs) {
                        String[] values;
                        if (searchFilter.getType().equals("date") && (date = SolrServiceImpl.toDate(value)) != null) {
                            value = DateFormatUtils.formatUTC((Date)date, (String)"yyyy-MM-dd");
                        }
                        doc.addField(searchFilter.getIndexFieldName(), (Object)value);
                        if (searchFilter.isFullAutoComplete()) {
                            doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)value);
                            continue;
                        }
                        for (String val : values = value.split(" ")) {
                            doc.addField(searchFilter.getIndexFieldName() + "_ac", (Object)val);
                        }
                    }
                }
                if (sidebarFacets.get(field) != null || sidebarFacets.get(unqualifiedField + "." + "*") != null) {
                    List facetConfigurations = (List)sidebarFacets.get(field);
                    if (facetConfigurations == null) {
                        facetConfigurations = (List)sidebarFacets.get(unqualifiedField + "." + "*");
                    }
                    for (SidebarFacetConfiguration configuration : facetConfigurations) {
                        if (configuration.getType().equals("text")) {
                            String separator = new DSpace().getConfigurationService().getProperty("discovery.solr.facets.split.char");
                            if (separator == null) {
                                separator = FILTER_SEPARATOR;
                            }
                            doc.addField(configuration.getIndexFieldName() + "_filter", (Object)(value.toLowerCase() + separator + value));
                            continue;
                        }
                        if (!configuration.getType().equals("date")) continue;
                        date = SolrServiceImpl.toDate(value);
                        if (date != null) {
                            String indexField = configuration.getIndexFieldName() + ".year";
                            doc.addField(indexField, (Object)DateFormatUtils.formatUTC((Date)date, (String)"yyyy"));
                            if (doc.getField(indexField + "_sort") != null) continue;
                            doc.addField(indexField + "_sort", (Object)DateFormatUtils.formatUTC((Date)date, (String)"yyyy"));
                            continue;
                        }
                        log.warn((Object)("Error while indexing sidebar date field, item: " + item.getHandle() + " metadata field: " + field + " date value: " + date));
                    }
                }
                if (!(sortFields.get(field) == null && recentSubmissionsConfigurationMap.get(field) == null || sortFieldsAdded.contains(field))) {
                    String type = sortFields.get(field) != null ? ((DiscoverySortFieldConfiguration)sortFields.get(field)).getType() : ((DiscoveryRecentSubmissionsConfiguration)recentSubmissionsConfigurationMap.get(field)).getType();
                    if (type.equals("date")) {
                        Date date2 = SolrServiceImpl.toDate(value);
                        if (date2 != null) {
                            doc.addField(field + "_dt", (Object)date2);
                        } else {
                            log.warn((Object)("Error while indexing sort date field, item: " + item.getHandle() + " metadata field: " + field + " date value: " + date2));
                        }
                    } else {
                        doc.addField(field + "_sort", (Object)value);
                    }
                    sortFieldsAdded.add(field);
                }
                doc.addField(field, (Object)value.toLowerCase());
                if (meta.language == null || meta.language.trim().equals("")) continue;
                String langField = field + "." + meta.language;
                doc.addField(langField, (Object)value);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.debug((Object)"  Added Metadata");
        try {
            DCValue[] values = item.getMetadata("dc.relation.ispartof");
            if (values != null && values.length > 0 && values[0] != null && values[0].value != null) {
                String handlePrefix = ConfigurationManager.getProperty((String)"handle.canonical.prefix");
                if (handlePrefix == null || handlePrefix.length() == 0) {
                    handlePrefix = "http://hdl.handle.net/";
                }
                doc.addField("publication_grp", (Object)values[0].value.replaceFirst(handlePrefix, ""));
            } else {
                doc.addField("publication_grp", (Object)item.getHandle());
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.debug((Object)"  Added Grouping");
        Vector<InputStreamReader> readers = new Vector<InputStreamReader>();
        try {
            Bundle[] myBundles;
            for (Bundle myBundle : myBundles = item.getBundles()) {
                Bitstream[] myBitstreams;
                if (myBundle.getName() == null || !myBundle.getName().equals("TEXT")) continue;
                for (Bitstream myBitstream : myBitstreams = myBundle.getBitstreams()) {
                    try {
                        InputStreamReader is = new InputStreamReader(myBitstream.retrieve());
                        readers.add(is);
                        doc.addField("fulltext", (Object)IOUtils.toString((Reader)is));
                        log.debug((Object)("  Added BitStream: " + myBitstream.getStoreNumber() + "\t" + myBitstream.getSequenceID() + "   " + myBitstream.getName()));
                    }
                    catch (Exception e) {
                        log.trace((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        List solrServiceIndexPlugins = new DSpace().getServiceManager().getServicesByType(SolrServiceIndexPlugin.class);
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : solrServiceIndexPlugins) {
            solrServiceIndexPlugin.additionalIndex((DSpaceObject)item, doc);
        }
        try {
            this.writeDocument(doc);
            log.info((Object)("Wrote Item: " + handle + " to Index"));
        }
        catch (RuntimeException e) {
            log.error((Object)("Error while writing item to discovery index: " + handle + " message:" + e.getMessage()), (Throwable)e);
        }
        finally {
            for (InputStreamReader reader : readers) {
                if (reader == null) continue;
                reader.close();
            }
            log.debug((Object)("closed " + readers.size() + " readers"));
        }
    }

    private SolrInputDocument buildDocument(int type, int id, String handle, List<String> locations) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField(LAST_INDEXED_FIELD, (Object)new Date());
        doc.addField("search.resourcetype", (Object)Integer.toString(type));
        doc.addField("search.resourceid", (Object)Integer.toString(id));
        if (handle != null) {
            doc.addField("handle", (Object)handle);
        }
        if (locations != null) {
            for (String location : locations) {
                doc.addField("location", (Object)location);
                if (location.startsWith("m")) {
                    doc.addField("location.comm", (Object)location.substring(1));
                    continue;
                }
                doc.addField("location.coll", (Object)location.substring(1));
            }
        }
        return doc;
    }

    public static Date toDate(String t) {
        SimpleDateFormat[] dfArr;
        switch (t.length()) {
            case 4: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy")};
                break;
            }
            case 6: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMM")};
                break;
            }
            case 7: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM")};
                break;
            }
            case 8: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy MMM")};
                break;
            }
            case 10: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd")};
                break;
            }
            case 11: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy MMM dd")};
                break;
            }
            case 20: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")};
                break;
            }
            default: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")};
            }
        }
        for (SimpleDateFormat df : dfArr) {
            try {
                df.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                df.setLenient(false);
                return df.parse(t);
            }
            catch (ParseException pe) {
                log.error((Object)"Unable to parse date format", (Throwable)pe);
            }
        }
        return null;
    }

    public static String locationToName(Context context, String field, String value) throws SQLException {
        int type;
        DSpaceObject commColl;
        if (("location.comm".equals(field) || "location.coll".equals(field)) && (commColl = DSpaceObject.find((Context)context, (int)(type = field.equals("location.comm") ? 4 : 3), (int)Integer.parseInt(value))) != null) {
            return commColl.getName();
        }
        return value;
    }

    public DiscoverResult search(Context context, DSpaceObject dso, DiscoverQuery discoveryQuery) throws SearchServiceException {
        if (dso != null) {
            if (dso instanceof Community) {
                discoveryQuery.addFilterQueries(new String[]{"location:m" + dso.getID()});
            } else if (dso instanceof Collection) {
                discoveryQuery.addFilterQueries(new String[]{"location:l" + dso.getID()});
            } else if (dso instanceof Item) {
                discoveryQuery.addFilterQueries(new String[]{"handle:" + dso.getHandle()});
            }
        }
        return this.search(context, discoveryQuery);
    }

    public DiscoverResult search(Context context, DiscoverQuery discoveryQuery) throws SearchServiceException {
        try {
            String filterQuery;
            int i;
            SolrQuery solrQuery = new SolrQuery();
            String query = "*:*";
            if (discoveryQuery.getQuery() != null) {
                query = discoveryQuery.getQuery();
            }
            solrQuery.setQuery(query);
            for (i = 0; i < discoveryQuery.getFilterQueries().size(); ++i) {
                filterQuery = (String)discoveryQuery.getFilterQueries().get(i);
                solrQuery.addFilterQuery(new String[]{filterQuery});
            }
            if (discoveryQuery.getDSpaceObjectFilter() != -1) {
                solrQuery.addFilterQuery(new String[]{"search.resourcetype:" + discoveryQuery.getDSpaceObjectFilter()});
            }
            for (i = 0; i < discoveryQuery.getFieldPresentQueries().size(); ++i) {
                filterQuery = (String)discoveryQuery.getFieldPresentQueries().get(i);
                solrQuery.addFilterQuery(new String[]{filterQuery + ":[* TO *]"});
            }
            if (discoveryQuery.getStart() != -1) {
                solrQuery.setStart(Integer.valueOf(discoveryQuery.getStart()));
            }
            if (discoveryQuery.getMaxResults() != -1) {
                solrQuery.setRows(Integer.valueOf(discoveryQuery.getMaxResults()));
            }
            if (discoveryQuery.getSortField() != null) {
                SolrQuery.ORDER order = SolrQuery.ORDER.asc;
                if (discoveryQuery.getSortOrder().equals((Object)DiscoverQuery.SORT_ORDER.desc)) {
                    order = SolrQuery.ORDER.desc;
                }
                solrQuery.addSortField(discoveryQuery.getSortField(), order);
            }
            for (String property : discoveryQuery.getProperties().keySet()) {
                List values = (List)discoveryQuery.getProperties().get(property);
                solrQuery.add(property, values.toArray(new String[values.size()]));
            }
            List facetFields = discoveryQuery.getFacetFields();
            if (0 < facetFields.size()) {
                for (DiscoverFacetField facetFieldConfig : facetFields) {
                    String field = this.transformFacetField(facetFieldConfig, facetFieldConfig.getField(), false);
                    solrQuery.addFacetField(new String[]{field});
                    solrQuery.add("f." + field + "." + "facet.limit", new String[]{String.valueOf(facetFieldConfig.getLimit())});
                    String facetSort = DiscoveryConfigurationParameters.SORT.COUNT.equals((Object)facetFieldConfig.getSortOrder()) ? "count" : "index";
                    solrQuery.add("f." + field + "." + "facet.sort", new String[]{facetSort});
                    if (facetFieldConfig.getPrefix() == null) continue;
                    solrQuery.setFacetPrefix(field, facetFieldConfig.getPrefix());
                }
                List facetQueries = discoveryQuery.getFacetQueries();
                for (String facetQuery : facetQueries) {
                    solrQuery.addFacetQuery(facetQuery);
                }
                if (discoveryQuery.getFacetMinCount() != -1) {
                    solrQuery.setFacetMinCount(discoveryQuery.getFacetMinCount());
                }
                solrQuery.setParam("facet.offset", new String[]{String.valueOf(discoveryQuery.getFacetOffset())});
            }
            QueryResponse queryResponse = this.getSolr().query((SolrParams)solrQuery);
            return this.retrieveResult(context, discoveryQuery, queryResponse);
        }
        catch (Exception e) {
            throw new SearchServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public String searchJSON(DiscoverQuery query, DSpaceObject dso, String jsonIdentifier) throws SearchServiceException {
        if (dso != null) {
            if (dso instanceof Community) {
                query.addFilterQueries(new String[]{"location:m" + dso.getID()});
            } else if (dso instanceof Collection) {
                query.addFilterQueries(new String[]{"location:l" + dso.getID()});
            } else if (dso instanceof Item) {
                query.addFilterQueries(new String[]{"handle:" + dso.getHandle()});
            }
        }
        return this.searchJSON(query, jsonIdentifier);
    }

    public String searchJSON(DiscoverQuery query, String jsonIdentifier) throws SearchServiceException {
        HashMap<String, String> params = new HashMap<String, String>();
        String solrRequestUrl = this.solr.getBaseURL() + "/select";
        params.put("rows", "0");
        params.put("wt", "json");
        params.put("json.nl", "map");
        params.put("json.wrf", jsonIdentifier);
        params.put("facet", Boolean.TRUE.toString());
        try {
            params.put("q", URLEncoder.encode(query.getQuery(), "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        params.put("facet.mincount", String.valueOf(query.getFacetMinCount()));
        solrRequestUrl = this.generateURL(solrRequestUrl, params);
        if (query.getFacetFields() != null || query.getFilterQueries() != null) {
            StringBuilder urlBuilder = new StringBuilder(solrRequestUrl);
            if (query.getFacetFields() != null) {
                for (DiscoverFacetField facetFieldConfig : query.getFacetFields()) {
                    urlBuilder.append("&").append("facet.field").append("=");
                    try {
                        String field = facetFieldConfig.getField() + "_ac";
                        urlBuilder.append(URLEncoder.encode(field, "UTF-8"));
                        urlBuilder.append("&f.").append(field).append(".facet.sort").append("=");
                        if (DiscoveryConfigurationParameters.SORT.COUNT.equals((Object)facetFieldConfig.getSortOrder())) {
                            urlBuilder.append("count");
                        } else {
                            urlBuilder.append("index");
                        }
                        urlBuilder.append("&f.").append(field).append(".facet.limit").append("=").append(facetFieldConfig.getLimit());
                    }
                    catch (UnsupportedEncodingException e) {}
                }
            }
            if (query.getFilterQueries() != null) {
                for (String filterQuery : query.getFilterQueries()) {
                    try {
                        urlBuilder.append("&").append("fq").append("=").append(URLEncoder.encode(filterQuery, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {}
                }
            }
            solrRequestUrl = urlBuilder.toString();
        }
        try {
            GetMethod get = new GetMethod(solrRequestUrl);
            new HttpClient().executeMethod((HttpMethod)get);
            return get.getResponseBodyAsString();
        }
        catch (Exception e) {
            log.error((Object)"Error while getting json solr result for discovery search recommendation", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    private String generateURL(String baseURL, Map<String, String> parameters) {
        boolean first = true;
        for (String key : parameters.keySet()) {
            if (first) {
                baseURL = baseURL + "?";
                first = false;
            } else {
                baseURL = baseURL + "&";
            }
            baseURL = baseURL + key + "=" + parameters.get(key);
        }
        return baseURL;
    }

    private DiscoverResult retrieveResult(Context context, DiscoverQuery query, QueryResponse solrQueryResponse) throws SQLException {
        DiscoverResult result = new DiscoverResult();
        if (solrQueryResponse != null) {
            result.setStart(query.getStart());
            result.setMaxResults(query.getMaxResults());
            result.setTotalSearchResults(solrQueryResponse.getResults().getNumFound());
            List searchFields = query.getSearchFields();
            for (SolrDocument doc : solrQueryResponse.getResults()) {
                DSpaceObject dso = SolrServiceImpl.findDSpaceObject(context, doc);
                if (dso == null) {
                    log.error((Object)LogManager.getHeader((Context)context, (String)"Error while retrieving DSpace object from discovery index", (String)("Handle: " + doc.getFirstValue("handle"))));
                    continue;
                }
                result.addDSpaceObject(dso);
                DiscoverResult.SearchDocument resultDoc = new DiscoverResult.SearchDocument();
                for (String field : searchFields) {
                    ArrayList<String> valuesAsString = new ArrayList<String>();
                    for (Object o : doc.getFieldValues(field)) {
                        valuesAsString.add(String.valueOf(o));
                    }
                    resultDoc.addSearchField(field, valuesAsString.toArray(new String[valuesAsString.size()]));
                }
                result.addSearchDocument(dso, resultDoc);
            }
            List facetFields = solrQueryResponse.getFacetFields();
            if (facetFields != null) {
                for (int i = 0; i < facetFields.size(); ++i) {
                    FacetField facetField = (FacetField)facetFields.get(i);
                    DiscoverFacetField facetFieldConfig = (DiscoverFacetField)query.getFacetFields().get(i);
                    List facetValues = facetField.getValues();
                    if (facetValues == null) continue;
                    if (facetFieldConfig.getType().equals("date") && facetFieldConfig.getSortOrder().equals((Object)DiscoveryConfigurationParameters.SORT.VALUE)) {
                        Collections.reverse(facetValues);
                    }
                    for (FacetField.Count facetValue : facetValues) {
                        String displayedValue = this.transformDisplayedValue(context, facetField.getName(), facetValue.getName());
                        String field = this.transformFacetField(facetFieldConfig, facetField.getName(), true);
                        result.addFacetResult(field, new DiscoverResult.FacetResult[]{new DiscoverResult.FacetResult(facetValue.getAsFilterQuery(), displayedValue, facetValue.getCount())});
                    }
                }
            }
            if (solrQueryResponse.getFacetQuery() != null) {
                TreeMap sortedFacetQueries = new TreeMap(solrQueryResponse.getFacetQuery());
                for (String facetQuery : sortedFacetQueries.descendingKeySet()) {
                    String facetField = facetQuery.substring(0, facetQuery.indexOf(":"));
                    String name = facetQuery.substring(facetQuery.indexOf(91) + 1);
                    name = name.substring(0, name.lastIndexOf(93)).replaceAll("TO", "-");
                    Integer count = (Integer)sortedFacetQueries.get(facetQuery);
                    if (0 >= count) continue;
                    result.addFacetResult(facetField, new DiscoverResult.FacetResult[]{new DiscoverResult.FacetResult(facetQuery, name, (long)count.intValue())});
                }
            }
        }
        return result;
    }

    private static DSpaceObject findDSpaceObject(Context context, SolrDocument doc) throws SQLException {
        Integer type = (Integer)doc.getFirstValue("search.resourcetype");
        Integer id = (Integer)doc.getFirstValue("search.resourceid");
        String handle = (String)doc.getFirstValue("handle");
        if (type != null && id != null) {
            return DSpaceObject.find((Context)context, (int)type, (int)id);
        }
        if (handle != null) {
            return HandleManager.resolveToObject((Context)context, (String)handle);
        }
        return null;
    }

    public InputStream searchAsInputStream(DiscoverQuery query) throws SearchServiceException, IOException {
        try {
            GetMethod method = new GetMethod(this.getSolr().getHttpClient().getHostConfiguration().getHostURL() + "");
            method.setQueryString(query.toString());
            this.getSolr().getHttpClient().executeMethod((HttpMethod)method);
            return method.getResponseBodyAsStream();
        }
        catch (SolrServerException e) {
            throw new SearchServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public List<DSpaceObject> search(Context context, String query, int offset, int max, String ... filterquery) {
        return this.search(context, query, null, true, offset, max, filterquery);
    }

    public List<DSpaceObject> search(Context context, String query, String orderfield, boolean ascending, int offset, int max, String ... filterquery) {
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(query);
            solrQuery.setFields(new String[]{"search.resourceid", "search.resourcetype"});
            solrQuery.setStart(Integer.valueOf(offset));
            solrQuery.setRows(Integer.valueOf(max));
            if (orderfield != null) {
                solrQuery.setSortField(orderfield, ascending ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            }
            if (filterquery != null) {
                solrQuery.addFilterQuery(filterquery);
            }
            QueryResponse rsp = this.getSolr().query((SolrParams)solrQuery);
            SolrDocumentList docs = rsp.getResults();
            Iterator iter = docs.iterator();
            ArrayList<DSpaceObject> result = new ArrayList<DSpaceObject>();
            while (iter.hasNext()) {
                SolrDocument doc = (SolrDocument)iter.next();
                DSpaceObject o = DSpaceObject.find((Context)context, (int)((Integer)doc.getFirstValue("search.resourcetype")), (int)((Integer)doc.getFirstValue("search.resourceid")));
                if (o == null) continue;
                result.add(o);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<DSpaceObject>(0);
        }
    }

    public DiscoverFilterQuery toFilterQuery(Context context, String filterQuery) throws SQLException {
        DiscoverFilterQuery result = new DiscoverFilterQuery();
        String field = filterQuery;
        String value = filterQuery;
        if (filterQuery.contains(":")) {
            field = filterQuery.substring(0, filterQuery.indexOf(":"));
            value = filterQuery.substring(filterQuery.indexOf(":") + 1, filterQuery.length());
        } else {
            field = "*";
        }
        value = value.replace("\\", "");
        if ("*".equals(field)) {
            field = "all";
        }
        if (filterQuery.startsWith("*:") || filterQuery.startsWith(":")) {
            filterQuery = filterQuery.substring(filterQuery.indexOf(":") + 1, filterQuery.length());
        }
        value = this.transformDisplayedValue(context, field, value);
        result.setField(field);
        result.setFilterQuery(filterQuery);
        result.setDisplayedValue(value);
        return result;
    }

    public DiscoverFilterQuery toFilterQuery(Context context, String field, String value) throws SQLException {
        DiscoverFilterQuery result = new DiscoverFilterQuery();
        result.setField(field);
        result.setDisplayedValue(this.transformDisplayedValue(context, field, value));
        result.setFilterQuery((field == null || field.equals("") ? "" : field + ":") + "(" + value + ")");
        return result;
    }

    public String toSortFieldIndex(String metadataField, String type) {
        if (type.equals("date")) {
            return metadataField + "_dt";
        }
        return metadataField + "_sort";
    }

    private String transformFacetField(DiscoverFacetField facetFieldConfig, String field, boolean removePostfix) {
        if (facetFieldConfig.getType().equals("text")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_filter"));
            }
            return field + "_filter";
        }
        if (facetFieldConfig.getType().equals("date")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf(".year"));
            }
            return field + ".year";
        }
        if (facetFieldConfig.getType().equals("date")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_ac"));
            }
            return field + "_ac";
        }
        return field;
    }

    private String transformDisplayedValue(Context context, String field, String value) throws SQLException {
        if (field.equals("location.comm") || field.equals("location.coll")) {
            value = SolrServiceImpl.locationToName(context, field, value);
        } else if (field.endsWith("_filter")) {
            int start;
            String separator = new DSpace().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = FILTER_SEPARATOR;
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuffer valueBuffer = new StringBuffer();
            for (int i = start = fqParts.length / 2; i < fqParts.length; ++i) {
                valueBuffer.append(fqParts[i]);
            }
            value = valueBuffer.toString();
        } else if (value.matches("\\((.*?)\\)")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }
}

