/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.discovery.AbstractSearch;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.Option;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.discovery.DiscoverFilterQuery;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.utils.DSpace;
import org.xml.sax.SAXException;

public class SimpleSearch
extends AbstractSearch
implements CacheableProcessingComponent {
    private static final Message T_title = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.title");
    private static final Message T_dspace_home = SimpleSearch.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.trail");
    private static final Message T_search_scope = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.search_scope");
    private static final Message T_head = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.head");
    private static final Message T_search_label = SimpleSearch.message((String)"xmlui.discovery.SimpleSearch.search_label");
    private static final Message T_go = SimpleSearch.message((String)"xmlui.general.go");
    private static final Message T_filter_label = SimpleSearch.message((String)"xmlui.Discovery.SimpleSearch.filter_head");
    private static final Message T_filter_help = SimpleSearch.message((String)"xmlui.Discovery.SimpleSearch.filter_help");
    private static final Message T_add_filter = SimpleSearch.message((String)"xmlui.Discovery.SimpleSearch.filter_add");
    private static final Message T_filter_apply = SimpleSearch.message((String)"xmlui.Discovery.SimpleSearch.filter_apply");
    private static final Message T_FILTERS_SELECTED = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.filter.selected");
    private SearchService searchService = null;

    public SimpleSearch() {
        DSpace dspace = new DSpace();
        this.searchService = (SearchService)dspace.getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class);
    }

    public void addPageMeta(PageMeta pageMeta) throws WingException, SQLException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (dso instanceof Collection || dso instanceof Community) {
            HandleUtil.buildHandleTrail((DSpaceObject)dso, (PageMeta)pageMeta, (String)this.contextPath);
        }
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String queryString = this.getQuery();
        Division search = body.addDivision("search", "primary");
        search.setHead(T_head);
        String searchUrl = ConfigurationManager.getProperty((String)"dspace.url") + "/JSON/discovery/search";
        search.addHidden("discovery-json-search-url").setValue(searchUrl);
        DSpaceObject currentScope = this.getScope();
        if (currentScope != null) {
            search.addHidden("discovery-json-scope").setValue(currentScope.getHandle());
        }
        search.addHidden("contextpath").setValue(this.contextPath);
        String[] fqs = this.getFilterQueries();
        Division mainSearchDiv = search.addInteractiveDivision("general-query", "discover", "get", "discover-search-box search");
        org.dspace.app.xmlui.wing.element.List searchList = mainSearchDiv.addList("primary-search", "form");
        searchList.setHead(T_search_label);
        if (this.variableScope()) {
            Select scope = searchList.addItem().addSelect("scope");
            scope.setLabel(T_search_scope);
            this.buildScopeList(scope);
        }
        Item searchBoxItem = searchList.addItem();
        Text text = searchBoxItem.addText("query");
        text.setValue(queryString);
        text.setSize(75);
        searchBoxItem.addButton("submit").setValue(T_go);
        this.addHiddenFormFields("search", request, fqs, mainSearchDiv);
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)dso);
        List filterFields = discoveryConfiguration.getSearchFilters();
        if (0 < fqs.length || 0 < filterFields.size()) {
            Item item;
            Division searchFiltersDiv = search.addInteractiveDivision("search-filters", "discover", "get", "discover-search-box search");
            org.dspace.app.xmlui.wing.element.List secondarySearchList = searchFiltersDiv.addList("secondary-search", "form");
            secondarySearchList.setHead(T_filter_label);
            if (fqs.length > 0) {
                item = secondarySearchList.addItem("used-filters", "used-filters-list");
                for (int i = 0; i < fqs.length; ++i) {
                    String filterQuery = fqs[i];
                    DiscoverFilterQuery fq = this.searchService.toFilterQuery(this.context, filterQuery);
                    CheckBox box = item.addCheckBox("fq");
                    if (i == 0) {
                        box.setLabel(T_FILTERS_SELECTED);
                    }
                    Option option = box.addOption(true, fq.getFilterQuery());
                    String field = fq.getField();
                    option.addContent(SimpleSearch.message((String)("xmlui.ArtifactBrowser.SimpleSearch.filter." + field)));
                    Pattern pattern = Pattern.compile("\\[(.*? TO .*?)\\]");
                    Matcher matcher = pattern.matcher(fq.getDisplayedValue());
                    boolean hasPattern = matcher.find();
                    if (hasPattern) {
                        String[] years = matcher.group(0).replace("[", "").replace("]", "").split(" TO ");
                        option.addContent(": " + years[0] + " - " + years[1]);
                        continue;
                    }
                    option.addContent(": " + fq.getDisplayedValue());
                }
                secondarySearchList.addItem().addButton("submit_update_filters", "update-filters").setValue(T_filter_apply);
            }
            if (0 < filterFields.size()) {
                item = secondarySearchList.addItem("search-filter-list", "search-filter-list");
                Composite filterComp = item.addComposite("search-filter-controls");
                filterComp.setLabel(T_add_filter);
                filterComp.setHelp(T_filter_help);
                Select select = filterComp.addSelect("filtertype");
                for (DiscoverySearchFilter searchFilter : filterFields) {
                    select.addOption(searchFilter.getIndexFieldName(), SimpleSearch.message((String)("xmlui.ArtifactBrowser.SimpleSearch.filter." + searchFilter.getIndexFieldName())));
                }
                filterComp.addText("filter").setSize(30);
                filterComp.enableAddOperation();
            }
            this.addHiddenFormFields("filter", request, fqs, searchFiltersDiv);
        }
        Division searchControlsDiv = search.addInteractiveDivision("search-controls", "discover", "get", "discover-sort-box search");
        this.buildSearchControls(searchControlsDiv);
        this.addHiddenFormFields("sort", request, fqs, searchControlsDiv);
        try {
            this.buildSearchResultsDivision(search);
        }
        catch (SearchServiceException e) {
            throw new UIException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected String[] getParameterFilterQueries() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ArrayList<String> fqs = new ArrayList<String>();
        if (request.getParameterValues("fq") != null) {
            fqs.addAll(Arrays.asList(request.getParameterValues("fq")));
        }
        if (request.getParameter("filter") != null && !"".equals(request.getParameter("filter"))) {
            fqs.add(request.getParameter("filtertype") + ":" + request.getParameter("filter"));
        }
        return fqs.toArray(new String[fqs.size()]);
    }

    @Override
    protected String[] getFilterQueries() {
        try {
            ArrayList<String> allFilterQueries = new ArrayList<String>();
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            ArrayList<String> fqs = new ArrayList<String>();
            if (request.getParameterValues("fq") != null) {
                fqs.addAll(Arrays.asList(request.getParameterValues("fq")));
            }
            String type = request.getParameter("filtertype");
            String value = request.getParameter("filter");
            if (value != null && !value.equals("")) {
                allFilterQueries.add(this.searchService.toFilterQuery(this.context, type.equals("*") ? "" : type, value).getFilterQuery());
            }
            for (String fq : fqs) {
                allFilterQueries.add(this.searchService.toFilterQuery(this.context, fq).getFilterQuery());
            }
            return allFilterQueries.toArray(new String[allFilterQueries.size()]);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected String getQuery() throws UIException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String query = SimpleSearch.decodeFromURL((String)request.getParameter("query"));
        if (query == null) {
            return "";
        }
        return query.trim();
    }

    @Override
    protected String generateURL(Map<String, String> parameters) throws UIException {
        String query = this.getQuery();
        if (!"".equals(query)) {
            parameters.put("query", SimpleSearch.encodeForURL((String)query));
        }
        if (parameters.get("page") == null) {
            parameters.put("page", String.valueOf(this.getParameterPage()));
        }
        if (parameters.get("rpp") == null) {
            parameters.put("rpp", String.valueOf(this.getParameterRpp()));
        }
        if (parameters.get("group_by") == null) {
            parameters.put("group_by", String.valueOf(this.getParameterGroup()));
        }
        if (parameters.get("sort_by") == null && this.getParameterSortBy() != null) {
            parameters.put("sort_by", String.valueOf(this.getParameterSortBy()));
        }
        if (parameters.get("order") == null && this.getParameterOrder() != null) {
            parameters.put("order", this.getParameterOrder());
        }
        if (parameters.get("etal") == null) {
            parameters.put("etal", String.valueOf(this.getParameterEtAl()));
        }
        if (parameters.get("scope") == null && this.getParameterScope() != null) {
            parameters.put("scope", this.getParameterScope());
        }
        return AbstractDSpaceTransformer.generateURL((String)"discover", parameters);
    }

    private void addHiddenFormFields(String type, Request request, String[] fqs, Division division) throws WingException {
        if (type.equals("filter") || type.equals("sort")) {
            if (request.getParameter("query") != null) {
                division.addHidden("query").setValue(request.getParameter("query"));
            }
            if (request.getParameter("scope") != null) {
                division.addHidden("scope").setValue(request.getParameter("scope"));
            }
        }
        if (type.equals("search") || type.equals("sort")) {
            for (String fq : fqs) {
                division.addHidden("fq").setValue(fq);
            }
        }
        if (type.equals("search") || type.equals("filter")) {
            if (request.getParameter("rpp") != null) {
                division.addHidden("rpp").setValue(request.getParameter("rpp"));
            }
            if (request.getParameter("sort_by") != null) {
                division.addHidden("sort_by").setValue(request.getParameter("sort_by"));
            }
            if (request.getParameter("order") != null) {
                division.addHidden("order").setValue(request.getParameter("order"));
            }
        }
    }
}

