/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.discovery;

import flexjson.JSONSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.webui.discovery.DiscoverUtility;
import org.dspace.app.webui.json.JSONRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchUtils;

public class DiscoveryJSONRequest
extends JSONRequest {
    @Override
    public void doJSONRequest(Context context, HttpServletRequest request, HttpServletResponse resp) throws AuthorizeException, IOException {
        String reqPath = request.getPathInfo();
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (reqPath.equalsIgnoreCase(this.getSubPath() + "/autocomplete")) {
            this.doAutocomplete(context, request, resp);
            return;
        }
        resp.sendError(404);
    }

    private void doAutocomplete(Context context, HttpServletRequest request, HttpServletResponse resp) {
        try {
            DSpaceObject scope = DiscoverUtility.getSearchScope(context, request);
            DiscoverQuery autocompleteQuery = DiscoverUtility.getDiscoverAutocomplete(context, request, scope);
            DiscoverResult qResults = SearchUtils.getSearchService().search(context, autocompleteQuery);
            Set facets = qResults.getFacetResults().keySet();
            List fResults = new ArrayList();
            if (facets != null && facets.size() > 0) {
                String autocompleteField = (String)facets.toArray()[0];
                fResults = qResults.getFacetResult(autocompleteField);
            }
            JSONSerializer serializer = new JSONSerializer();
            serializer.rootName("autocomplete");
            serializer.exclude(new String[]{"class", "asFilterQuery"});
            serializer.deepSerialize(fResults, (Writer)resp.getWriter());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

