/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.search;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataExport;
import org.dspace.app.util.OpenSearch;
import org.dspace.app.util.SyndicationFeed;
import org.dspace.app.util.Util;
import org.dspace.app.webui.search.SearchProcessorException;
import org.dspace.app.webui.search.SearchRequestProcessor;
import org.dspace.app.webui.servlet.SimpleSearchServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSQuery;
import org.dspace.search.QueryArgs;
import org.dspace.search.QueryResults;
import org.dspace.services.model.Event;
import org.dspace.sort.SortOption;
import org.dspace.usage.UsageEvent;
import org.dspace.usage.UsageSearchEvent;
import org.dspace.utils.DSpace;
import org.w3c.dom.Document;

public class LuceneSearchRequestProcessor
implements SearchRequestProcessor {
    private static Logger log = Logger.getLogger(SimpleSearchServlet.class);
    private Map<String, Map<String, String>> localeLabels = null;
    private static String msgKey = "org.dspace.app.webui.servlet.FeedServlet";

    public synchronized void init() {
        if (this.localeLabels == null) {
            this.localeLabels = new HashMap<String, Map<String, String>>();
        }
    }

    @Override
    public void doSimpleSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, IOException, ServletException {
        try {
            int i;
            String location;
            String query = request.getParameter("query");
            int start = UIUtil.getIntParameter((HttpServletRequest)request, (String)"start");
            String advanced = request.getParameter("advanced");
            String fromAdvanced = request.getParameter("from_advanced");
            int sortBy = UIUtil.getIntParameter((HttpServletRequest)request, (String)"sort_by");
            String order = request.getParameter("order");
            int rpp = UIUtil.getIntParameter((HttpServletRequest)request, (String)"rpp");
            String advancedQuery = "";
            if (start < 0) {
                start = 0;
            }
            int collCount = 0;
            int commCount = 0;
            int itemCount = 0;
            QueryResults qResults = null;
            QueryArgs qArgs = new QueryArgs();
            SortOption sortOption = null;
            if (request.getParameter("etal") != null) {
                qArgs.setEtAl(UIUtil.getIntParameter((HttpServletRequest)request, (String)"etal"));
            }
            try {
                if (sortBy > 0) {
                    sortOption = SortOption.getSortOption((int)sortBy);
                    qArgs.setSortOption(sortOption);
                }
                if ("ASC".equalsIgnoreCase(order)) {
                    qArgs.setSortOrder("ASC");
                } else {
                    qArgs.setSortOrder("DESC");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if ("submit_export_metadata".equals(UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit"))) {
                qArgs.setPageSize(Integer.MAX_VALUE);
            } else if (rpp > 0) {
                qArgs.setPageSize(rpp);
            }
            if (advanced != null) {
                query = qArgs.buildQuery(request);
                advancedQuery = qArgs.buildHTTPQuery(request);
            }
            if (query == null) {
                query = "";
            }
            if ((location = request.getParameter("location")) != null && !location.equals("")) {
                String url = "";
                if (!location.equals("/")) {
                    url = "/handle/" + location;
                }
                query = URLEncoder.encode(query, "UTF-8");
                if (advancedQuery.length() > 0) {
                    query = query + "&from_advanced=true&" + advancedQuery;
                }
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + url + "/simple-search?query=" + query));
                return;
            }
            String logInfo = "";
            Community community = UIUtil.getCommunityLocation(request);
            Collection collection = UIUtil.getCollectionLocation(request);
            qArgs.setQuery(query);
            qArgs.setStart(start);
            if (collection != null) {
                logInfo = "collection_id=" + collection.getID() + ",";
                request.setAttribute("community", (Object)community);
                request.setAttribute("collection", (Object)collection);
                qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Collection)collection);
            } else if (community != null) {
                logInfo = "community_id=" + community.getID() + ",";
                request.setAttribute("community", (Object)community);
                request.setAttribute("collection.array", (Object)community.getCollections());
                qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Community)community);
            } else {
                Community[] communities = Community.findAll((Context)context);
                request.setAttribute("community.array", (Object)communities);
                qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs);
            }
            block15: for (i = 0; i < qResults.getHitTypes().size(); ++i) {
                Integer myType = (Integer)qResults.getHitTypes().get(i);
                switch (myType) {
                    case 2: {
                        ++itemCount;
                        continue block15;
                    }
                    case 3: {
                        ++collCount;
                        continue block15;
                    }
                    case 4: {
                        ++commCount;
                    }
                }
            }
            Community[] resultsCommunities = new Community[commCount];
            Collection[] resultsCollections = new Collection[collCount];
            Item[] resultsItems = new Item[itemCount];
            collCount = 0;
            commCount = 0;
            itemCount = 0;
            block16: for (i = 0; i < qResults.getHitTypes().size(); ++i) {
                Integer myId = (Integer)qResults.getHitIds().get(i);
                String myHandle = (String)qResults.getHitHandles().get(i);
                Integer myType = (Integer)qResults.getHitTypes().get(i);
                switch (myType) {
                    case 2: {
                        resultsItems[itemCount] = myId != null ? Item.find((Context)context, (int)myId) : (Item)HandleManager.resolveToObject((Context)context, (String)myHandle);
                        if (resultsItems[itemCount] == null) {
                            throw new SQLException("Query \"" + query + "\" returned unresolvable item");
                        }
                        ++itemCount;
                        continue block16;
                    }
                    case 3: {
                        resultsCollections[collCount] = myId != null ? Collection.find((Context)context, (int)myId) : (Collection)HandleManager.resolveToObject((Context)context, (String)myHandle);
                        if (resultsCollections[collCount] == null) {
                            throw new SQLException("Query \"" + query + "\" returned unresolvable collection");
                        }
                        ++collCount;
                        continue block16;
                    }
                    case 4: {
                        resultsCommunities[commCount] = myId != null ? Community.find((Context)context, (int)myId) : (Community)HandleManager.resolveToObject((Context)context, (String)myHandle);
                        if (resultsCommunities[commCount] == null) {
                            throw new SQLException("Query \"" + query + "\" returned unresolvable community");
                        }
                        ++commCount;
                    }
                }
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"search", (String)(logInfo + "query=\"" + query + "\",results=(" + resultsCommunities.length + "," + resultsCollections.length + "," + resultsItems.length + ")")));
            int pageTotal = 1 + (qResults.getHitCount() - 1) / qResults.getPageSize();
            int pageCurrent = 1 + qResults.getStart() / qResults.getPageSize();
            int pageLast = pageCurrent + 9 > pageTotal ? pageTotal : pageCurrent + 9;
            int pageFirst = pageCurrent - 9 > 1 ? pageCurrent - 9 : 1;
            Collection scope = null;
            if (collection != null) {
                scope = collection;
            } else if (community != null) {
                scope = community;
            }
            this.logSearch(context, request, query, pageCurrent, (DSpaceObject)scope);
            request.setAttribute("items", (Object)resultsItems);
            request.setAttribute("communities", (Object)resultsCommunities);
            request.setAttribute("collections", (Object)resultsCollections);
            request.setAttribute("pagetotal", (Object)pageTotal);
            request.setAttribute("pagecurrent", (Object)pageCurrent);
            request.setAttribute("pagelast", (Object)pageLast);
            request.setAttribute("pagefirst", (Object)pageFirst);
            request.setAttribute("queryresults", (Object)qResults);
            request.setAttribute("query", (Object)query);
            request.setAttribute("order", (Object)qArgs.getSortOrder());
            request.setAttribute("sortedBy", (Object)sortOption);
            if (AuthorizeManager.isAdmin((Context)context)) {
                request.setAttribute("admin_button", (Object)Boolean.TRUE);
            }
            if (fromAdvanced != null && qResults.getHitCount() == 0) {
                Community[] communities = Community.findAll((Context)context);
                request.setAttribute("communities", (Object)communities);
                request.setAttribute("no_results", (Object)"yes");
                Map queryHash = qArgs.buildQueryMap(request);
                if (queryHash != null) {
                    for (Map.Entry entry : queryHash.entrySet()) {
                        request.setAttribute((String)entry.getKey(), entry.getValue());
                    }
                }
                JSPManager.showJSP(request, response, "/search/advanced.jsp");
            } else if ("submit_export_metadata".equals(UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit"))) {
                this.exportMetadata(context, response, resultsItems);
            } else {
                JSPManager.showJSP(request, response, "/search/results.jsp");
            }
        }
        catch (IllegalStateException e) {
            throw new SearchProcessorException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new SearchProcessorException(e.getMessage(), e);
        }
    }

    protected void logSearch(Context context, HttpServletRequest request, String query, int start, DSpaceObject scope) {
        UsageSearchEvent searchEvent = new UsageSearchEvent(UsageEvent.Action.SEARCH, request, context, null, Arrays.asList(query), scope);
        if (!StringUtils.isBlank((String)request.getParameter("rpp"))) {
            searchEvent.setRpp(Integer.parseInt(request.getParameter("rpp")));
        }
        if (!StringUtils.isBlank((String)request.getParameter("sort_by"))) {
            searchEvent.setSortBy(request.getParameter("sort_by"));
        }
        if (!StringUtils.isBlank((String)request.getParameter("order"))) {
            searchEvent.setSortOrder(request.getParameter("order"));
        }
        if (!StringUtils.isBlank((String)request.getParameter("start"))) {
            searchEvent.setPage(start);
        }
        new DSpace().getEventService().fireEvent((Event)searchEvent);
    }

    @Override
    public void doAdvancedSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, ServletException, IOException {
        Community[] communities;
        try {
            communities = Community.findAllTop((Context)context);
        }
        catch (SQLException e) {
            throw new SearchProcessorException(e.getMessage(), e);
        }
        request.setAttribute("communities", (Object)communities);
        JSPManager.showJSP(request, response, "/search/advanced.jsp");
    }

    @Override
    public void doOpenSearch(Context context, HttpServletRequest request, HttpServletResponse response) throws SearchProcessorException, IOException, ServletException {
        DSpaceObject container;
        String path;
        this.init();
        String scope = request.getParameter("scope");
        if (scope != null && "".equals(scope)) {
            scope = null;
        }
        if ((path = request.getPathInfo()) != null && path.endsWith("description.xml")) {
            String svcDescrip = OpenSearch.getDescription((String)scope);
            response.setContentType(OpenSearch.getContentType((String)"opensearchdescription"));
            response.setContentLength(svcDescrip.length());
            response.getWriter().write(svcDescrip);
            return;
        }
        String format = request.getParameter("format");
        if (format == null || "".equals(format)) {
            format = "atom";
        }
        if (!OpenSearch.getFormats().contains(format)) {
            response.sendError(400);
            return;
        }
        String query = request.getParameter("query");
        int start = Util.getIntParameter((HttpServletRequest)request, (String)"start");
        int rpp = Util.getIntParameter((HttpServletRequest)request, (String)"rpp");
        int sort = Util.getIntParameter((HttpServletRequest)request, (String)"sort_by");
        String order = request.getParameter("order");
        String sortOrder = order == null || order.length() == 0 || order.toLowerCase().startsWith("asc") ? "ASC" : "DESC";
        QueryArgs qArgs = new QueryArgs();
        if (start < 0) {
            start = 0;
        }
        qArgs.setStart(start);
        if (rpp > 0) {
            qArgs.setPageSize(rpp);
        }
        qArgs.setSortOrder(sortOrder);
        if (sort > 0) {
            try {
                qArgs.setSortOption(SortOption.getSortOption((int)sort));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        qArgs.setSortOrder(sortOrder);
        if (query == null) {
            query = "";
        }
        try {
            container = scope != null ? HandleManager.resolveToObject((Context)context, (String)scope) : null;
        }
        catch (IllegalStateException e) {
            throw new SearchProcessorException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new SearchProcessorException(e.getMessage(), e);
        }
        String logInfo = "";
        qArgs.setQuery(query);
        QueryResults qResults = null;
        if (container == null) {
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs);
        } else if (container instanceof Collection) {
            logInfo = "collection_id=" + container.getID() + ",";
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Collection)((Collection)container));
        } else if (container instanceof Community) {
            logInfo = "community_id=" + container.getID() + ",";
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Community)((Community)container));
        } else {
            throw new IllegalStateException("Invalid container for search context");
        }
        DSpaceObject[] results = new DSpaceObject[qResults.getHitHandles().size()];
        for (int i = 0; i < qResults.getHitHandles().size(); ++i) {
            DSpaceObject dso;
            String myHandle = (String)qResults.getHitHandles().get(i);
            try {
                dso = HandleManager.resolveToObject((Context)context, (String)myHandle);
            }
            catch (IllegalStateException e) {
                throw new SearchProcessorException(e.getMessage(), e);
            }
            catch (SQLException e) {
                throw new SearchProcessorException(e.getMessage(), e);
            }
            if (dso == null) {
                throw new SearchProcessorException("Query \"" + query + "\" returned unresolvable handle: " + myHandle);
            }
            results[i] = dso;
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"search", (String)(logInfo + "query=\"" + query + "\",results=(" + results.length + ")")));
        Map<String, String> labelMap = this.getLabels(request);
        Document resultsDoc = OpenSearch.getResultsDoc((String)format, (String)query, (int)qResults.getHitCount(), (int)qResults.getStart(), (int)qResults.getPageSize(), (DSpaceObject)container, (DSpaceObject[])results, labelMap);
        try {
            Transformer xf = TransformerFactory.newInstance().newTransformer();
            response.setContentType(OpenSearch.getContentType((String)format));
            xf.transform(new DOMSource(resultsDoc), new StreamResult(response.getWriter()));
        }
        catch (TransformerException e) {
            log.error((Object)e);
            throw new ServletException(e.toString(), (Throwable)e);
        }
    }

    protected void exportMetadata(Context context, HttpServletResponse response, Item[] items) throws IOException, ServletException {
        log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)"exporting_search"));
        ArrayList<Integer> iids = new ArrayList<Integer>();
        for (Item item : items) {
            iids.add(item.getID());
        }
        ItemIterator ii = new ItemIterator(context, iids);
        MetadataExport exporter = new MetadataExport(context, ii, false);
        DSpaceCSV csv = exporter.export();
        response.setContentType("text/csv; charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=search-results.csv");
        PrintWriter out = response.getWriter();
        out.write(csv.toString());
        out.flush();
        out.close();
        log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)"exported_file:search-results.csv"));
    }

    private Map<String, String> getLabels(HttpServletRequest request) {
        Locale locale = UIUtil.getSessionLocale(request);
        Map<String, String> labelMap = this.localeLabels.get(locale.toString());
        if (labelMap == null) {
            labelMap = this.getLocaleLabels(locale);
            this.localeLabels.put(locale.toString(), labelMap);
        }
        return labelMap;
    }

    private Map<String, String> getLocaleLabels(Locale locale) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        labelMap.put("notitle", I18nUtil.getMessage((String)(msgKey + ".notitle"), (Locale)locale));
        labelMap.put("logo.title", I18nUtil.getMessage((String)(msgKey + ".logo.title"), (Locale)locale));
        labelMap.put("general-feed.description", I18nUtil.getMessage((String)(msgKey + ".general-feed.description"), (Locale)locale));
        labelMap.put("ui.type", "jspui");
        for (String selector : SyndicationFeed.getDescriptionSelectors()) {
            labelMap.put("metadata." + selector, I18nUtil.getMessage((String)("metadata." + selector), (Locale)locale));
        }
        return labelMap;
    }
}

