/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class X509CertificateServlet
extends DSpaceServlet {
    private static final long serialVersionUID = -3571151231655696793L;
    private static Logger log = Logger.getLogger(X509CertificateServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length == 0) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)"type=x509certificate"));
            JSPManager.showJSP(request, response, "/login/no-valid-cert.jsp");
        } else {
            Context ctx = UIUtil.obtainContext(request);
            EPerson eperson = ctx.getCurrentUser();
            if (eperson != null && eperson.canLogIn()) {
                Authenticate.resumeInterruptedRequest(request, response);
                return;
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)"type=x509certificate"));
            JSPManager.showJSP(request, response, "/login/no-valid-cert.jsp");
        }
    }
}

