/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.SupervisedItem;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.Group;
import org.dspace.eperson.Supervisor;

public class SuperviseServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(SuperviseServlet.class);

    @Override
    protected void doDSGet(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(c, request, response);
    }

    @Override
    protected void doDSPost(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_base");
        if (button.equals("submit_add")) {
            this.showLinkPage(c, request, response);
        } else if (button.equals("submit_view")) {
            this.showListPage(c, request, response);
        } else if (button.equals("submit_base")) {
            this.showMainPage(c, request, response);
        } else if (button.equals("submit_link")) {
            if (this.validateAddForm(c, request, response)) {
                this.addSupervisionOrder(c, request, response);
                this.showMainPage(c, request, response);
            }
        } else if (button.equals("submit_remove")) {
            this.showConfirmRemovePage(c, request, response);
        } else if (button.equals("submit_doremove")) {
            this.removeSupervisionOrder(c, request, response);
            this.showMainPage(c, request, response);
        } else if (button.equals("submit_clean")) {
            this.cleanSupervisorDatabase(c, request, response);
            this.showMainPage(c, request, response);
        }
    }

    private void showConfirmRemovePage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"siID");
        int groupID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"gID");
        WorkspaceItem wsItem = WorkspaceItem.find((Context)context, (int)wsItemID);
        Group group = Group.find((Context)context, (int)groupID);
        request.setAttribute("wsItem", (Object)wsItem);
        request.setAttribute("group", (Object)group);
        JSPManager.showJSP(request, response, "/dspace-admin/supervise-confirm-remove.jsp");
    }

    private void showLinkPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Group[] groups = Group.findAll((Context)context, (int)1);
        WorkspaceItem[] wsItems = WorkspaceItem.findAll((Context)context);
        request.setAttribute("groups", (Object)groups);
        request.setAttribute("wsItems", (Object)wsItems);
        JSPManager.showJSP(request, response, "/dspace-admin/supervise-link.jsp");
    }

    private void showMainPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP(request, response, "/dspace-admin/supervise-main.jsp");
    }

    private void showListPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        SupervisedItem[] si = SupervisedItem.getAll((Context)context);
        request.setAttribute("supervised", (Object)si);
        JSPManager.showJSP(request, response, "/dspace-admin/supervise-list.jsp");
    }

    void addSupervisionOrder(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, AuthorizeException, ServletException, IOException {
        int groupID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"TargetGroup");
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"TargetWSItem");
        int policyType = UIUtil.getIntParameter((HttpServletRequest)request, (String)"PolicyType");
        Supervisor.add((Context)context, (int)groupID, (int)wsItemID, (int)policyType);
        log.info((Object)LogManager.getHeader((Context)context, (String)"Supervision Order Set", (String)("workspace_item_id=" + wsItemID + ",eperson_group_id=" + groupID)));
        context.complete();
    }

    private void cleanSupervisorDatabase(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Supervisor.removeRedundant((Context)context);
        context.complete();
    }

    void removeSupervisionOrder(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, AuthorizeException, ServletException, IOException {
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"siID");
        int groupID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"gID");
        Supervisor.remove((Context)context, (int)wsItemID, (int)groupID);
        log.info((Object)LogManager.getHeader((Context)context, (String)"Supervision Order Removed", (String)("workspace_item_id=" + wsItemID + ",eperson_group_id=" + groupID)));
        context.complete();
    }

    private boolean validateAddForm(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int groupID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"TargetGroup");
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"TargetWSItem");
        boolean invalid = Supervisor.isOrder((Context)context, (int)wsItemID, (int)groupID);
        if (invalid) {
            JSPManager.showJSP(request, response, "/dspace-admin/supervise-duplicate.jsp");
            return false;
        }
        return true;
    }
}

