/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RequestInfo
implements Serializable {
    private Map originalParameterMap;
    private String originalMethod;
    private String originalQueryString;

    public RequestInfo(HttpServletRequest request) {
        this.originalParameterMap = new HashMap(request.getParameterMap());
        this.originalMethod = request.getMethod();
        this.originalQueryString = request.getQueryString();
    }

    public HttpServletRequest wrapRequest(HttpServletRequest request) {
        return new MyWrapper(request);
    }

    class MyWrapper
    extends HttpServletRequestWrapper {
        public MyWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getParameter(String name) {
            String[] vals = (String[])RequestInfo.this.originalParameterMap.get(name);
            if (vals == null) {
                return super.getParameter(name);
            }
            return vals[0];
        }

        public Map getParameterMap() {
            return RequestInfo.this.originalParameterMap;
        }

        public Enumeration getParameterNames() {
            Iterator i = RequestInfo.this.originalParameterMap.keySet().iterator();
            return new EnumIterator(i);
        }

        public String[] getParameterValues(String name) {
            return (String[])RequestInfo.this.originalParameterMap.get(name);
        }

        public String getMethod() {
            return RequestInfo.this.originalMethod;
        }

        public String getQueryString() {
            return RequestInfo.this.originalQueryString;
        }

        class EnumIterator
        implements Enumeration {
            private Iterator iterator;

            public EnumIterator(Iterator i) {
                this.iterator = i;
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            public Object nextElement() {
                return this.iterator.next();
            }
        }
    }
}

