/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class CommunityListServlet
extends DSpaceServlet {
    private Map<Integer, Collection[]> colMap;
    private Map<Integer, Community[]> commMap;
    private static final Object staticLock = new Object();
    private static Logger log = Logger.getLogger(CommunityListServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Object object = staticLock;
        synchronized (object) {
            this.colMap = new HashMap<Integer, Collection[]>();
            this.commMap = new HashMap<Integer, Community[]>();
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_community_list", (String)""));
            Community[] communities = Community.findAllTop((Context)context);
            for (int com = 0; com < communities.length; ++com) {
                this.build(communities[com]);
            }
            if (AuthorizeManager.isAdmin((Context)context)) {
                request.setAttribute("admin_button", (Object)Boolean.TRUE);
            }
            request.setAttribute("communities", (Object)communities);
            request.setAttribute("collections.map", this.colMap);
            request.setAttribute("subcommunities.map", this.commMap);
            JSPManager.showJSP(request, response, "/community-list.jsp");
        }
    }

    private void build(Community c) throws SQLException {
        Integer comID = c.getID();
        Collection[] colls = c.getCollections();
        this.colMap.put(comID, colls);
        Community[] comms = c.getSubcommunities();
        if (comms.length > 0) {
            this.commMap.put(comID, comms);
            for (int sub = 0; sub < comms.length; ++sub) {
                this.build(comms[sub]);
            }
        }
    }
}

