/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.app.webui.util.VersionUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;

public class VersionHistoryServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(VersionHistoryServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String submit;
        Version version;
        Integer itemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"itemID");
        String versionID = request.getParameter("versionID");
        Item item = Item.find((Context)context, (int)itemID);
        if (item == null) {
            throw new IllegalArgumentException("Item is null");
        }
        if (!AuthorizeManager.isAdmin((Context)context, (DSpaceObject)item.getOwningCollection()) && ((Boolean)new DSpace().getConfigurationService().getPropertyAsType("versioning.item.history.view.admin", (Object)true)).booleanValue()) {
            throw new AuthorizeException();
        }
        VersionHistory history = VersionUtil.retrieveVersionHistory(context, item);
        if ((versionID == null || versionID.isEmpty()) && (version = history.getVersion(item)) != null) {
            versionID = String.valueOf(version.getVersionId());
        }
        if ((submit = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit")) != null && submit.equals("submit_cancel")) {
            response.sendRedirect(request.getContextPath() + "/handle/" + item.getHandle());
            context.complete();
            return;
        }
        if (submit != null && submit.equals("submit_delete")) {
            String[] versionIDs = request.getParameterValues("remove");
            Integer result = this.doDeleteVersions(request, itemID, versionIDs);
            if (result != null) {
                response.sendRedirect(request.getContextPath() + "/tools/history?delete=true&itemID=" + history.getLatestVersion().getItemID());
            } else {
                response.sendRedirect(request.getContextPath());
            }
            context.complete();
            return;
        }
        if (submit != null && submit.equals("submit_restore")) {
            this.doRestoreVersion(request, itemID, versionID);
        } else if (submit != null && submit.equals("submit_update")) {
            this.doUpdateVersion(request, itemID, versionID);
            response.sendRedirect(request.getContextPath() + "/tools/history?itemID=" + itemID + "&versionID=" + versionID);
            context.complete();
            return;
        }
        request.setAttribute("item", (Object)item);
        request.setAttribute("itemID", (Object)itemID);
        request.setAttribute("versionID", (Object)versionID);
        JSPManager.showJSP(request, response, "/tools/version-history.jsp");
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(UIUtil.obtainContext(request), request, response);
    }

    private Integer doDeleteVersions(HttpServletRequest request, Integer itemID, String ... versionIDs) throws SQLException, AuthorizeException, IOException {
        return VersionUtil.processDeleteVersions(UIUtil.obtainContext(request), itemID, versionIDs);
    }

    private Integer doRestoreVersion(HttpServletRequest request, Integer itemID, String versionID) throws NumberFormatException, SQLException, AuthorizeException, IOException {
        String summary = request.getParameter("summary");
        VersionUtil.processRestoreVersion(UIUtil.obtainContext(request), Integer.parseInt(versionID), summary);
        return itemID;
    }

    private Integer doUpdateVersion(HttpServletRequest request, Integer itemID, String versionID) throws SQLException, AuthorizeException, IOException {
        String summary = request.getParameter("summary");
        VersionUtil.processUpdateVersion(UIUtil.obtainContext(request), itemID, summary);
        return itemID;
    }
}

